/*
 * Decompiled with CFR 0.152.
 */
package cassetu.mystbornhorizons.event;

import cassetu.mystbornhorizons.item.ModItems;
import cassetu.mystbornhorizons.util.EnhancedMobEquipment;
import cassetu.mystbornhorizons.world.CurseState;
import net.fabricmc.fabric.api.entity.event.v1.ServerLivingEntityEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerEntityEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1528;
import net.minecraft.class_1542;
import net.minecraft.class_1545;
import net.minecraft.class_1548;
import net.minecraft.class_1588;
import net.minecraft.class_1604;
import net.minecraft.class_1613;
import net.minecraft.class_1627;
import net.minecraft.class_1628;
import net.minecraft.class_1632;
import net.minecraft.class_1640;
import net.minecraft.class_1642;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_268;
import net.minecraft.class_2902;
import net.minecraft.class_2995;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3730;
import net.minecraft.class_5425;
import net.minecraft.class_9254;

public class MobSpawnHandler {
    public static void register() {
        ServerEntityEvents.ENTITY_LOAD.register((entity, world) -> {
            class_1588 mob;
            if (!(world instanceof class_3218)) {
                return;
            }
            class_3218 serverWorld = world;
            if (entity instanceof class_1588 && MobSpawnHandler.shouldEnhanceMob(mob = (class_1588)entity)) {
                String name;
                CurseState curseState = CurseState.getOrCreate(serverWorld);
                if (curseState.isCurseActive()) {
                    return;
                }
                if (mob.method_16914() && mob.method_5797() != null && (name = mob.method_5797().getString()).contains("Cursed")) {
                    return;
                }
                serverWorld.method_8503().execute(() -> {
                    EnhancedMobEquipment.equipPostHavenicaMob((class_1308)mob, serverWorld);
                    if (serverWorld.method_8409().method_43057() < 0.3f) {
                        EnhancedMobEquipment.applyCorruptionEffects((class_1308)mob, serverWorld);
                    }
                });
            }
        });
        ServerLivingEntityEvents.AFTER_DEATH.register((entity, damageSource) -> {
            if (entity instanceof class_1588) {
                class_1588 hostileEntity = (class_1588)entity;
                class_1937 patt0$temp = entity.method_37908();
                if (patt0$temp instanceof class_3218) {
                    String name;
                    class_3218 serverWorld = (class_3218)patt0$temp;
                    if (entity.method_16914() && entity.method_5797() != null && (name = entity.method_5797().getString()).contains("Infected")) {
                        MobSpawnHandler.dropInfectedEssence(hostileEntity, serverWorld);
                    }
                }
            }
        });
        ServerTickEvents.END_WORLD_TICK.register(world -> {
            class_3218 serverWorld;
            CurseState curseState;
            if (world instanceof class_3218 && (curseState = CurseState.getOrCreate(serverWorld = world)).isCurseActive() && serverWorld.method_8510() % 40L == 0L) {
                MobSpawnHandler.spawnCursedMobs(serverWorld);
            }
        });
    }

    private static void dropInfectedEssence(class_1588 mob, class_3218 world) {
        String teamName;
        class_2995 scoreboard = world.method_14170();
        class_268 team = scoreboard.method_1153(teamName = "infectedEssenceGlow");
        if (team == null) {
            team = scoreboard.method_1171(teamName);
            team.method_1141(class_124.field_1060);
            team.method_1143(false);
        }
        class_1799 essence = new class_1799((class_1935)ModItems.INFECTED_ESSENCE);
        class_1542 itemEntity = new class_1542((class_1937)world, mob.method_23317(), mob.method_23318() + 0.5, mob.method_23321(), essence);
        double velocityX = (world.method_8409().method_43058() - 0.5) * 0.3;
        double velocityY = world.method_8409().method_43058() * 0.2 + 0.1;
        double velocityZ = (world.method_8409().method_43058() - 0.5) * 0.3;
        itemEntity.method_18800(velocityX, velocityY, velocityZ);
        world.method_8649((class_1297)itemEntity);
        scoreboard.method_1172(itemEntity.method_5845(), team);
        itemEntity.method_5834(true);
        world.method_14199((class_2394)class_2398.field_11211, mob.method_23317(), mob.method_23318() + 1.0, mob.method_23321(), 8, 0.5, 0.5, 0.5, 0.05);
    }

    private static boolean isValidSpawnLocation(class_3218 world, class_2338 pos) {
        if (!world.method_8320(pos).method_26215() || !world.method_8320(pos.method_10084()).method_26215()) {
            return false;
        }
        if (world.method_8320(pos.method_10074()).method_26215()) {
            return false;
        }
        return world.method_22339(pos) < 6;
    }

    private static void spawnCursedMobs(class_3218 world) {
        for (class_3222 player : world.method_18456()) {
            class_1299[] mobTypes;
            class_1299 chosenType;
            class_1297 class_12972;
            double z;
            if (!(world.method_8409().method_43057() < 0.4f)) continue;
            double angle = world.method_8409().method_43058() * Math.PI * 2.0;
            double distance = 18.0 + world.method_8409().method_43058() * 16.0;
            double x = player.method_23317() + Math.cos(angle) * distance;
            class_2338 spawnPos = new class_2338((int)x, world.method_8624(class_2902.class_2903.field_13203, (int)x, (int)(z = player.method_23321() + Math.sin(angle) * distance)), (int)z);
            if (!MobSpawnHandler.isValidSpawnLocation(world, spawnPos) || !((class_12972 = (chosenType = (mobTypes = new class_1299[]{class_1299.field_6051, class_1299.field_49148, class_1299.field_6079, class_1299.field_6098, class_1299.field_6137})[world.method_8409().method_43048(mobTypes.length)]).method_5883((class_1937)world)) instanceof class_1588)) continue;
            class_1588 mob = (class_1588)class_12972;
            mob.method_5808((double)spawnPos.method_10263() + 0.5, (double)spawnPos.method_10264(), (double)spawnPos.method_10260() + 0.5, 0.0f, 0.0f);
            mob.method_5943((class_5425)world, world.method_8404(spawnPos), class_3730.field_16467, null);
            if (MobSpawnHandler.shouldEnhanceMob(mob)) {
                EnhancedMobEquipment.equipCursedMob((class_1308)mob, world);
                EnhancedMobEquipment.applyCurseEffects((class_1308)mob, world);
                world.method_14199((class_2394)class_2398.field_22246, mob.method_23317(), mob.method_23318() + 1.0, mob.method_23321(), 10, 1.0, 1.0, 1.0, 0.1);
            }
            world.method_8649((class_1297)mob);
        }
    }

    private static boolean shouldEnhanceMob(class_1588 mob) {
        if (mob instanceof class_1528 || mob.getClass().getSimpleName().contains("Boss") || mob.getClass().getSimpleName().contains("Havenica") || mob.getClass().getSimpleName().contains("Dragon")) {
            return false;
        }
        return mob instanceof class_1642 || mob instanceof class_1613 || mob instanceof class_1548 || mob instanceof class_1628 || mob instanceof class_1632 || mob instanceof class_1604 || mob instanceof class_1640 || mob instanceof class_1627 || mob instanceof class_1545 || mob instanceof class_9254 || mob.getClass().getSimpleName().contains("Entity");
    }
}

