/*
 * Decompiled with CFR 0.152.
 */
package cassetu.mystbornhorizons.event;

import cassetu.mystbornhorizons.world.NetherAccessState;
import java.util.HashSet;
import java.util.Set;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public class NetherPortalHandler {
    private static final Set<class_2338> processedFirePositions = new HashSet<class_2338>();
    private static int tickCounter = 0;

    public static void register() {
        UseBlockCallback.EVENT.register((player, world, hand, hitResult) -> {
            if (world.field_9236) {
                return class_1269.field_5811;
            }
            if (!(player instanceof class_3222)) {
                return class_1269.field_5811;
            }
            class_3222 serverPlayer = (class_3222)player;
            if (player.method_5998(hand).method_7909() != class_1802.field_8884 && player.method_5998(hand).method_7909() != class_1802.field_8814) {
                return class_1269.field_5811;
            }
            NetherAccessState accessState = NetherAccessState.getOrCreate(serverPlayer.method_5682());
            if (accessState.hasNetherAccess(serverPlayer.method_5667())) {
                return class_1269.field_5811;
            }
            class_2338 clickedPos = hitResult.method_17777();
            class_2338 targetPos = clickedPos.method_10093(hitResult.method_17780());
            class_2680 clickedState = world.method_8320(clickedPos);
            if (NetherPortalHandler.isNearNetherPortalOrObsidian(world, targetPos) || NetherPortalHandler.isNearNetherPortalOrObsidian(world, clickedPos)) {
                serverPlayer.method_7353((class_2561)class_2561.method_43470((String)"You cannot light fire near a Nether portal without a Nether Key!").method_27692(class_124.field_1061), true);
                return class_1269.field_5814;
            }
            if (clickedState.method_26204() == class_2246.field_10540 && NetherPortalHandler.isPartOfPortalFrame(world, clickedPos)) {
                serverPlayer.method_7353((class_2561)class_2561.method_43470((String)"You cannot create a Nether portal without a Nether Key!").method_27692(class_124.field_1061), true);
                return class_1269.field_5814;
            }
            return class_1269.field_5811;
        });
        ServerTickEvents.END_WORLD_TICK.register(world -> {
            if (!(world instanceof class_3218)) {
                return;
            }
            class_3218 serverWorld = world;
            if (++tickCounter % 5 != 0) {
                return;
            }
            processedFirePositions.removeIf(pos -> serverWorld.method_8320(pos).method_26204() != class_2246.field_10036);
            for (class_3222 player : serverWorld.method_18456()) {
                NetherAccessState accessState = NetherAccessState.getOrCreate(serverWorld.method_8503());
                if (accessState.hasNetherAccess(player.method_5667())) continue;
                class_2338 playerPos = player.method_24515();
                for (int x = -10; x <= 10; ++x) {
                    for (int y = -10; y <= 10; ++y) {
                        for (int z = -10; z <= 10; ++z) {
                            class_2680 state;
                            class_2338 checkPos = playerPos.method_10069(x, y, z);
                            if (processedFirePositions.contains(checkPos) || (state = serverWorld.method_8320(checkPos)).method_26204() != class_2246.field_10036 || !NetherPortalHandler.isNearNetherPortalOrObsidian((class_1937)serverWorld, checkPos)) continue;
                            serverWorld.method_8501(checkPos, class_2246.field_10124.method_9564());
                            player.method_7353((class_2561)class_2561.method_43470((String)"The fire extinguishes mysteriously... You need a Nether Key!").method_27692(class_124.field_1061), true);
                            processedFirePositions.add(checkPos);
                        }
                    }
                }
            }
        });
    }

    private static boolean isNearNetherPortalOrObsidian(class_1937 world, class_2338 pos) {
        for (int x = -2; x <= 2; ++x) {
            for (int y = -2; y <= 2; ++y) {
                for (int z = -2; z <= 2; ++z) {
                    class_2338 checkPos = pos.method_10069(x, y, z);
                    class_2680 state = world.method_8320(checkPos);
                    if (state.method_26204() == class_2246.field_10316) {
                        return true;
                    }
                    if (state.method_26204() != class_2246.field_10540 || !NetherPortalHandler.isPartOfPortalFrame(world, checkPos)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean isPartOfPortalFrame(class_1937 world, class_2338 pos) {
        for (class_2350.class_2351 axis : new class_2350.class_2351[]{class_2350.class_2351.field_11048, class_2350.class_2351.field_11051}) {
            if (!NetherPortalHandler.checkPortalFrameInAxis(world, pos, axis)) continue;
            return true;
        }
        return false;
    }

    private static boolean checkPortalFrameInAxis(class_1937 world, class_2338 pos, class_2350.class_2351 axis) {
        class_2350 perpendicular = axis == class_2350.class_2351.field_11048 ? class_2350.field_11043 : class_2350.field_11034;
        int obsidianCount = 0;
        int airCount = 0;
        for (int height = -4; height <= 4; ++height) {
            for (int width = -4; width <= 4; ++width) {
                class_2338 checkPos = pos.method_10079(class_2350.field_11036, height).method_10079(perpendicular, width);
                class_2680 state = world.method_8320(checkPos);
                if (state.method_26204() == class_2246.field_10540) {
                    ++obsidianCount;
                    continue;
                }
                if (!state.method_26215()) continue;
                ++airCount;
            }
        }
        return obsidianCount >= 10 && airCount >= 6;
    }
}

