/*
 * Decompiled with CFR 0.152.
 */
package cassetu.mystbornhorizons.util;

import cassetu.mystbornhorizons.item.ModItems;
import cassetu.mystbornhorizons.world.HavenicaDefeatState;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5134;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_8053;
import net.minecraft.class_9304;
import net.minecraft.class_9334;

public class EnhancedMobEquipment {
    public static void equipPostHavenicaMob(class_1308 mob, class_3218 world) {
        class_2487 nbt = new class_2487();
        mob.method_5647(nbt);
        if (nbt.method_10577("IsSpawnerMob")) {
            return;
        }
        HavenicaDefeatState state = HavenicaDefeatState.getOrCreate(world);
        if (!state.isHavenicaDefeated()) {
            return;
        }
        class_5819 random = mob.method_59922();
        float enhancementChance = EnhancedMobEquipment.calculateEnhancementChance(world, state.getDefeatTime());
        if (random.method_43057() < enhancementChance) {
            EnhancedMobEquipment.equipEnhancedArmor(mob, world, random, false);
            EnhancedMobEquipment.applyPostDefeatBuffs(mob, random);
            EnhancedMobEquipment.preventEquipmentDrops(mob);
        }
    }

    public static void equipCursedMob(class_1308 mob, class_3218 world) {
        class_2487 nbt = new class_2487();
        mob.method_5647(nbt);
        if (nbt.method_10577("IsSpawnerMob")) {
            return;
        }
        class_5819 random = mob.method_59922();
        EnhancedMobEquipment.equipEnhancedArmor(mob, world, random, true);
        EnhancedMobEquipment.applyCursedBuffs(mob, random);
        EnhancedMobEquipment.preventEquipmentDrops(mob);
    }

    private static void preventEquipmentDrops(class_1308 mob) {
        for (class_1304 slot : class_1304.values()) {
            mob.method_5946(slot, 0.0f);
        }
    }

    private static float calculateEnhancementChance(class_3218 world, long defeatTime) {
        long timeSinceDefeat = world.method_8510() - defeatTime;
        long daysPassedTicks = timeSinceDefeat / 24000L;
        long cycle = daysPassedTicks % 20L;
        if (cycle <= 10L) {
            return 0.3f + (float)cycle * 0.05f;
        }
        return 0.8f - (float)(cycle - 10L) * 0.05f;
    }

    private static void equipEnhancedArmor(class_1308 mob, class_3218 world, class_5819 random, boolean isCursed) {
        EnhancedMobEquipment.equipSpecificWeapon(mob, world, random);
        if (isCursed) {
            EnhancedMobEquipment.setCursedName(mob);
        } else {
            EnhancedMobEquipment.setInfectedName(mob);
        }
        if (random.method_43057() < 0.8f) {
            class_1799 helmet = isCursed ? EnhancedMobEquipment.createEnhancedHelmet(random, world, true) : EnhancedMobEquipment.createEnhancedHelmet(random, world, false);
            mob.method_5673(class_1304.field_6169, helmet);
        }
        if (random.method_43057() < 0.9f) {
            class_1799 chestplate = isCursed ? EnhancedMobEquipment.createEnhancedChestplate(random, world, true) : EnhancedMobEquipment.createEnhancedChestplate(random, world, false);
            mob.method_5673(class_1304.field_6174, chestplate);
        }
        if (random.method_43057() < 0.7f) {
            class_1799 leggings = isCursed ? EnhancedMobEquipment.createEnhancedLeggings(random, world, true) : EnhancedMobEquipment.createEnhancedLeggings(random, world, false);
            mob.method_5673(class_1304.field_6172, leggings);
        }
        if (random.method_43057() < 0.8f) {
            class_1799 boots = isCursed ? EnhancedMobEquipment.createEnhancedBoots(random, world, true) : EnhancedMobEquipment.createEnhancedBoots(random, world, false);
            mob.method_5673(class_1304.field_6166, boots);
        }
        if (random.method_43057() < 0.3f) {
            class_1799 offhand = EnhancedMobEquipment.createSpecialOffhandItem(random);
            mob.method_5673(class_1304.field_6171, offhand);
        }
    }

    private static void setInfectedName(class_1308 mob) {
        String mobTypeName = mob.method_5864().method_5897().getString();
        String infectedName = "\u00a72Infected \u00a7r" + mobTypeName;
        mob.method_5665((class_2561)class_2561.method_43470((String)infectedName));
        mob.method_5880(false);
    }

    private static void setCursedName(class_1308 mob) {
        String mobTypeName = mob.method_5864().method_5897().getString();
        String cursedName = "\u00a74Cursed \u00a7r" + mobTypeName;
        mob.method_5665((class_2561)class_2561.method_43470((String)cursedName));
        mob.method_5880(false);
    }

    private static class_1799 createEnhancedHelmet(class_5819 random, class_3218 world, boolean isCursed) {
        float armorRoll = random.method_43057();
        class_1799 helmet = armorRoll < 0.2f ? new class_1799((class_1935)class_1802.field_8805) : (isCursed ? new class_1799((class_1935)class_1802.field_22027) : new class_1799((class_1935)class_1802.field_8743));
        if (isCursed) {
            EnhancedMobEquipment.addRedstoneTrim(helmet, world);
        } else {
            EnhancedMobEquipment.addEmeraldTrim(helmet, world);
        }
        try {
            class_6880 respiration;
            class_6880 unbreaking;
            class_6880 protection;
            class_9304.class_9305 enchantments = new class_9304.class_9305(class_9304.field_49385);
            if (random.method_43057() < 0.4f && (protection = (class_6880)world.method_30349().method_30530(class_7924.field_41265).method_40264(class_1893.field_9111).orElse(null)) != null) {
                enchantments.method_57550(protection, 1 + random.method_43048(2));
            }
            if (random.method_43057() < 0.2f && (unbreaking = (class_6880)world.method_30349().method_30530(class_7924.field_41265).method_40264(class_1893.field_9119).orElse(null)) != null) {
                enchantments.method_57550(unbreaking, 1 + random.method_43048(2));
            }
            if (random.method_43057() < 0.1f && (respiration = (class_6880)world.method_30349().method_30530(class_7924.field_41265).method_40264(class_1893.field_9127).orElse(null)) != null) {
                enchantments.method_57550(respiration, 1 + random.method_43048(2));
            }
            helmet.method_57379(class_9334.field_49633, (Object)enchantments.method_57549());
        }
        catch (Exception e) {
            System.out.println("Error adding helmet enchantments: " + e.getMessage());
        }
        return helmet;
    }

    private static class_1799 createEnhancedChestplate(class_5819 random, class_3218 world, boolean isCursed) {
        float armorRoll = random.method_43057();
        class_1799 chestplate = armorRoll < 0.6f ? new class_1799((class_1935)class_1802.field_8058) : new class_1799((class_1935)class_1802.field_8523);
        if (isCursed) {
            EnhancedMobEquipment.addRedstoneTrim(chestplate, world);
        } else {
            EnhancedMobEquipment.addEmeraldTrim(chestplate, world);
        }
        try {
            class_6880 unbreaking;
            class_6880 protection;
            class_9304.class_9305 enchantments = new class_9304.class_9305(class_9304.field_49385);
            if (random.method_43057() < 0.4f && (protection = (class_6880)world.method_30349().method_30530(class_7924.field_41265).method_40264(class_1893.field_9111).orElse(null)) != null) {
                enchantments.method_57550(protection, 1 + random.method_43048(2));
            }
            if (random.method_43057() < 0.2f && (unbreaking = (class_6880)world.method_30349().method_30530(class_7924.field_41265).method_40264(class_1893.field_9119).orElse(null)) != null) {
                enchantments.method_57550(unbreaking, 1 + random.method_43048(2));
            }
            chestplate.method_57379(class_9334.field_49633, (Object)enchantments.method_57549());
        }
        catch (Exception e) {
            System.out.println("Error adding chestplate enchantments: " + e.getMessage());
        }
        return chestplate;
    }

    private static class_1799 createEnhancedLeggings(class_5819 random, class_3218 world, boolean isCursed) {
        float armorRoll = random.method_43057();
        class_1799 leggings = armorRoll < 0.2f ? new class_1799((class_1935)class_1802.field_8348) : new class_1799((class_1935)class_1802.field_8396);
        if (isCursed) {
            EnhancedMobEquipment.addRedstoneTrim(leggings, world);
        } else {
            EnhancedMobEquipment.addEmeraldTrim(leggings, world);
        }
        try {
            class_6880 unbreaking;
            class_6880 protection;
            class_9304.class_9305 enchantments = new class_9304.class_9305(class_9304.field_49385);
            if (random.method_43057() < 0.8f && (protection = (class_6880)world.method_30349().method_30530(class_7924.field_41265).method_40264(class_1893.field_9111).orElse(null)) != null) {
                enchantments.method_57550(protection, 1 + random.method_43048(2));
            }
            if (random.method_43057() < 0.4f && (unbreaking = (class_6880)world.method_30349().method_30530(class_7924.field_41265).method_40264(class_1893.field_9119).orElse(null)) != null) {
                enchantments.method_57550(unbreaking, 1 + random.method_43048(2));
            }
            leggings.method_57379(class_9334.field_49633, (Object)enchantments.method_57549());
        }
        catch (Exception e) {
            System.out.println("Error adding leggings enchantments: " + e.getMessage());
        }
        return leggings;
    }

    private static class_1799 createEnhancedBoots(class_5819 random, class_3218 world, boolean isCursed) {
        float armorRoll = random.method_43057();
        class_1799 boots = armorRoll < 0.4f ? new class_1799((class_1935)class_1802.field_8285) : new class_1799((class_1935)class_1802.field_8660);
        if (isCursed) {
            EnhancedMobEquipment.addRedstoneTrim(boots, world);
        } else {
            EnhancedMobEquipment.addEmeraldTrim(boots, world);
        }
        try {
            class_6880 unbreaking;
            class_6880 depthStrider;
            class_6880 featherFalling;
            class_6880 protection;
            class_9304.class_9305 enchantments = new class_9304.class_9305(class_9304.field_49385);
            if (random.method_43057() < 0.7f && (protection = (class_6880)world.method_30349().method_30530(class_7924.field_41265).method_40264(class_1893.field_9111).orElse(null)) != null) {
                enchantments.method_57550(protection, 1 + random.method_43048(2));
            }
            if (random.method_43057() < 0.6f && (featherFalling = (class_6880)world.method_30349().method_30530(class_7924.field_41265).method_40264(class_1893.field_9129).orElse(null)) != null) {
                enchantments.method_57550(featherFalling, 1 + random.method_43048(2));
            }
            if (random.method_43057() < 0.4f && (depthStrider = (class_6880)world.method_30349().method_30530(class_7924.field_41265).method_40264(class_1893.field_9128).orElse(null)) != null) {
                enchantments.method_57550(depthStrider, 1 + random.method_43048(2));
            }
            if (random.method_43057() < 0.3f && (unbreaking = (class_6880)world.method_30349().method_30530(class_7924.field_41265).method_40264(class_1893.field_9119).orElse(null)) != null) {
                enchantments.method_57550(unbreaking, 1 + random.method_43048(2));
            }
            boots.method_57379(class_9334.field_49633, (Object)enchantments.method_57549());
        }
        catch (Exception e) {
            System.out.println("Error adding boots enchantments: " + e.getMessage());
        }
        return boots;
    }

    private static void addEmeraldTrim(class_1799 armor, class_3218 world) {
        try {
            class_6880 emerald = world.method_30349().method_30530(class_7924.field_42083).method_55841(class_2960.method_60654((String)"emerald")).orElse(null);
            class_6880 pattern = world.method_30349().method_30530(class_7924.field_42082).method_55841(class_2960.method_60654((String)"wild")).orElse(null);
            if (emerald != null && pattern != null) {
                class_8053 trim = new class_8053(emerald, pattern);
                armor.method_57379(class_9334.field_49607, (Object)trim);
            }
        }
        catch (Exception e) {
            System.out.println("Error adding armor trim: " + e.getMessage());
        }
    }

    private static void addRedstoneTrim(class_1799 armor, class_3218 world) {
        try {
            class_6880 emerald = world.method_30349().method_30530(class_7924.field_42083).method_55841(class_2960.method_60654((String)"redstone")).orElse(null);
            class_6880 pattern = world.method_30349().method_30530(class_7924.field_42082).method_55841(class_2960.method_60654((String)"silence")).orElse(null);
            if (emerald != null && pattern != null) {
                class_8053 trim = new class_8053(emerald, pattern);
                armor.method_57379(class_9334.field_49607, (Object)trim);
            }
        }
        catch (Exception e) {
            System.out.println("Error adding armor trim: " + e.getMessage());
        }
    }

    private static void equipSpecificWeapon(class_1308 mob, class_3218 world, class_5819 random) {
        String mobType = mob.getClass().getSimpleName().toLowerCase();
        if (mobType.contains("pillager") || mobType.contains("vindicator")) {
            class_1799 axe = random.method_43057() < 0.3f ? new class_1799((class_1935)class_1802.field_8556) : (random.method_43057() < 0.6f ? new class_1799((class_1935)class_1802.field_8475) : new class_1799((class_1935)class_1802.field_8062));
            mob.method_5673(class_1304.field_6173, axe);
        } else if (mobType.contains("skeleton") || mobType.contains("bogged")) {
            class_1799 bow = new class_1799((class_1935)class_1802.field_8102);
            mob.method_5673(class_1304.field_6173, bow);
        } else if (mobType.contains("zombie") || mobType.contains("husk") || mobType.contains("drowned")) {
            float weaponRoll = random.method_43057();
            class_1799 weapon = weaponRoll < 0.2f ? new class_1799((class_1935)class_1802.field_8371) : (weaponRoll < 0.4f ? new class_1799((class_1935)class_1802.field_8528) : new class_1799((class_1935)class_1802.field_8091));
            mob.method_5673(class_1304.field_6173, weapon);
        } else if (mobType.contains("spider")) {
            if (random.method_43057() < 0.3f) {
                class_1799 weapon = new class_1799((class_1935)class_1802.field_8528);
                mob.method_5673(class_1304.field_6173, weapon);
            }
        } else if (mobType.contains("enderman")) {
            if (random.method_43057() < 0.4f) {
                class_1799 weapon = random.method_43057() < 0.5f ? new class_1799((class_1935)class_1802.field_8371) : new class_1799((class_1935)class_1802.field_8528);
                mob.method_5673(class_1304.field_6173, weapon);
            }
        } else if (mobType.contains("creeper")) {
            if (random.method_43057() < 0.15f) {
                class_1799 weapon = new class_1799((class_1935)class_1802.field_8091);
                mob.method_5673(class_1304.field_6173, weapon);
            }
        } else if (mobType.contains("witch")) {
            if (random.method_43057() < 0.6f) {
                class_1799 weapon = random.method_43057() < 0.3f ? new class_1799((class_1935)class_1802.field_8725) : new class_1799((class_1935)class_1802.field_8600);
                mob.method_5673(class_1304.field_6173, weapon);
            }
        } else if (mobType.contains("blaze") && random.method_43057() < 0.5f) {
            class_1799 weapon = new class_1799((class_1935)class_1802.field_8894);
            mob.method_5673(class_1304.field_6173, weapon);
        }
    }

    private static class_1799 createSpecialOffhandItem(class_5819 random) {
        float roll = random.method_43057();
        if (roll < 0.4f) {
            return new class_1799((class_1935)class_1802.field_8255);
        }
        if (roll < 0.6f) {
            return new class_1799((class_1935)class_1802.field_8288);
        }
        if (roll < 0.8f) {
            return new class_1799((class_1935)ModItems.ROOT);
        }
        return new class_1799((class_1935)class_1802.field_8635);
    }

    private static void applyPostDefeatBuffs(class_1308 mob, class_5819 random) {
        if (random.method_43057() < 0.5f) {
            float damageMultiplier = 1.2f + random.method_43057() * 0.5f;
            if (mob.method_5996(class_5134.field_23721) != null) {
                mob.method_5996(class_5134.field_23721).method_6192(mob.method_5996(class_5134.field_23721).method_6201() * (double)damageMultiplier);
            }
        }
    }

    private static void applyCursedBuffs(class_1308 mob, class_5819 random) {
        if (random.method_43057() < 0.4f) {
            float healthMultiplier = 1.2f + random.method_43057() * 0.9f;
            if (mob.method_5996(class_5134.field_23716) != null) {
                mob.method_5996(class_5134.field_23716).method_6192((double)(mob.method_6063() * healthMultiplier));
                mob.method_6033(mob.method_6063());
            }
        }
    }

    public static void applyCorruptionEffects(class_1308 mob, class_3218 world) {
        if (world.method_8409().method_43057() < 0.25f) {
            mob.method_6092(new class_1293(class_1294.field_5907, 2400, 2, false, true));
        }
        if (world.method_8510() % 20L == 0L) {
            int particleCount = 2 + world.method_8409().method_43048(3);
            for (int i = 0; i < particleCount; ++i) {
                double offsetX = (world.method_8409().method_43058() - 0.5) * 1.2;
                double offsetY = world.method_8409().method_43058() * 1.5 + 0.2;
                double offsetZ = (world.method_8409().method_43058() - 0.5) * 1.2;
                world.method_14199((class_2394)class_2398.field_28803, mob.method_23317() + offsetX, mob.method_23318() + offsetY, mob.method_23321() + offsetZ, 1, 0.1, 0.1, 0.1, 0.01);
            }
            if (world.method_8409().method_43057() < 0.3f) {
                world.method_14199((class_2394)class_2398.field_50247, mob.method_23317(), mob.method_23318() + 1.2, mob.method_23321(), 8, 0.3, 0.3, 0.3, 0.02);
            }
        }
    }

    public static void applyCurseEffects(class_1308 mob, class_3218 world) {
        if (world.method_8409().method_43057() < 0.4f) {
            mob.method_6092(new class_1293(class_1294.field_5907, 3600, 3, false, true));
        }
        if (world.method_8409().method_43057() < 0.3f) {
            mob.method_6092(new class_1293(class_1294.field_5924, 3600, 2, false, true));
        }
        if (world.method_8409().method_43057() < 0.3f) {
            mob.method_6092(new class_1293(class_1294.field_5920, 120, 1, false, true));
        }
        if (world.method_8510() % 15L == 0L) {
            int particleCount = 3 + world.method_8409().method_43048(4);
            for (int i = 0; i < particleCount; ++i) {
                double offsetX = (world.method_8409().method_43058() - 0.5) * 1.5;
                double offsetY = world.method_8409().method_43058() * 2.0 + 0.3;
                double offsetZ = (world.method_8409().method_43058() - 0.5) * 1.5;
                world.method_14199((class_2394)class_2398.field_22447, mob.method_23317() + offsetX, mob.method_23318() + offsetY, mob.method_23321() + offsetZ, 1, 0.15, 0.15, 0.15, 0.02);
            }
            if (world.method_8409().method_43057() < 0.4f) {
                world.method_14199((class_2394)class_2398.field_22248, mob.method_23317(), mob.method_23318() + 1.5, mob.method_23321(), 10, 0.4, 0.4, 0.4, 0.03);
            }
        }
    }
}

