/*
 * Decompiled with CFR 0.152.
 */
package cassetu.mystbornhorizons.world;

import cassetu.mystbornhorizons.effect.ModEffects;
import cassetu.mystbornhorizons.event.LoreHandler;
import cassetu.mystbornhorizons.sound.ModSounds;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1259;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1295;
import net.minecraft.class_1297;
import net.minecraft.class_1588;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2770;
import net.minecraft.class_2902;
import net.minecraft.class_3213;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_7225;

public class CurseState
extends class_18 {
    private boolean curseActive = false;
    private boolean cursePaused = false;
    private int mobsKilled = 0;
    private static final int MOBS_NEEDED = 10;
    private class_3213 curseBossBar;
    private long musicStartTime = 0L;
    private static final long MUSIC_DURATION = 2820L;
    private Map<UUID, Long> playerMusicStartTimes = new HashMap<UUID, Long>();
    private Map<UUID, Boolean> playerMusicPlaying = new HashMap<UUID, Boolean>();
    private static final String[] CREEPY_MESSAGES = new String[]{"<???> Something ancient stirs beneath our feet", "<???> We've poisoned this place just by being here", "<???> The earth itself rejects us now", "<???> The world grows darker with each breath...", "<???> Can you feel it spreading? The taint seeps into everything...", "<???> The curse feeds on our fear", "<???> The forest remembers what we've done", "<???> It knows we're here", "<???> Do you hear them too? The voices in the wind?"};

    public static CurseState getOrCreate(class_3218 world) {
        return (CurseState)world.method_17983().method_17924(new class_18.class_8645(CurseState::new, CurseState::fromNbt, null), "forests_curse_state");
    }

    public static CurseState fromNbt(class_2487 nbt, class_7225.class_7874 registryLookup) {
        CurseState state = new CurseState();
        state.curseActive = nbt.method_10577("curse_active");
        state.cursePaused = nbt.method_10577("curse_paused");
        state.mobsKilled = nbt.method_10550("mobs_killed");
        state.musicStartTime = nbt.method_10537("music_start_time");
        if (state.curseActive) {
            state.createBossBar();
        }
        return state;
    }

    public class_2487 method_75(class_2487 nbt, class_7225.class_7874 registryLookup) {
        nbt.method_10556("curse_active", this.curseActive);
        nbt.method_10556("curse_paused", this.cursePaused);
        nbt.method_10569("mobs_killed", this.mobsKilled);
        nbt.method_10544("music_start_time", this.musicStartTime);
        return nbt;
    }

    public void activateCurse(class_3218 world) {
        if (!this.curseActive) {
            this.curseActive = true;
            this.cursePaused = false;
            this.mobsKilled = 0;
            this.musicStartTime = world.method_8510();
            this.createBossBar();
            this.method_80();
            this.stopBackgroundMusic(world);
            this.startCurseMusicForAllPlayers(world);
            for (class_3222 player : world.method_18456()) {
                if (this.curseBossBar != null) {
                    this.curseBossBar.method_14088(player);
                }
                player.method_7353((class_2561)class_2561.method_43470((String)"\u00a74\u00a7lThe Curse has begun!"), false);
                player.method_7353((class_2561)class_2561.method_43470((String)("\u00a76Kill cursed mobs to lift the curse (" + this.mobsKilled + "/10)")), false);
            }
        }
    }

    private void startCurseMusicForAllPlayers(class_3218 world) {
        for (class_3222 player : world.method_18456()) {
            this.startCurseMusicForPlayer(world, player);
        }
    }

    private void startCurseMusicForPlayer(class_3218 world, class_3222 player) {
        UUID playerId = player.method_5667();
        this.stopBackgroundMusicForPlayer(player);
        player.method_17356(ModSounds.NIGHT_SHACKLES_BG, class_3419.field_15253, 0.8f, 1.0f);
        this.playerMusicStartTimes.put(playerId, world.method_8510());
        this.playerMusicPlaying.put(playerId, true);
    }

    private void stopBackgroundMusic(class_3218 world) {
        for (class_3222 player : world.method_18456()) {
            this.stopBackgroundMusicForPlayer(player);
        }
    }

    private void stopBackgroundMusicForPlayer(class_3222 player) {
        player.field_13987.method_14364((class_2596)new class_2770(null, class_3419.field_15256));
        player.field_13987.method_14364((class_2596)new class_2770(null, class_3419.field_15247));
    }

    private void stopCurseMusic(class_3218 world) {
        for (class_3222 player : world.method_18456()) {
            this.stopCurseMusicForPlayer(player);
        }
    }

    private void stopCurseMusicForPlayer(class_3222 player) {
        UUID playerId = player.method_5667();
        player.field_13987.method_14364((class_2596)new class_2770(null, class_3419.field_15253));
        this.playerMusicPlaying.put(playerId, false);
        this.playerMusicStartTimes.remove(playerId);
    }

    public void addMobKill(class_3218 world) {
        if (this.curseActive) {
            ++this.mobsKilled;
            this.updateBossBar();
            this.method_80();
            for (class_3222 player : world.method_18456()) {
                player.method_7353((class_2561)class_2561.method_43470((String)("\u00a76Curse Progress: " + this.mobsKilled + "/10 cursed mobs killed")), true);
            }
            if (world.method_8409().method_43057() < 0.7f) {
                String creepyMessage = CREEPY_MESSAGES[world.method_8409().method_43048(CREEPY_MESSAGES.length)];
                for (class_3222 player : world.method_18456()) {
                    player.method_7353((class_2561)class_2561.method_43470((String)creepyMessage), false);
                    player.method_6092(new class_1293(class_1294.field_38092, 160, 0, false, false));
                    player.method_6092(new class_1293(class_1294.field_5920, 160, 0, false, true));
                }
            }
            if (this.mobsKilled >= 10) {
                this.endCurse(world);
            }
        }
    }

    public void endCurse(class_3218 world) {
        if (this.curseActive) {
            this.curseActive = false;
            this.cursePaused = false;
            this.mobsKilled = 0;
            this.stopCurseMusic(world);
            this.playerMusicStartTimes.clear();
            this.playerMusicPlaying.clear();
            if (this.curseBossBar != null) {
                this.curseBossBar.method_14094();
                this.curseBossBar = null;
            }
            world.method_29199(1000L);
            world.method_27910(0, 0, false, false);
            world.method_27909().forEach(entity -> {
                if (entity instanceof class_1588 && entity.method_16914() && entity.method_5797() != null && entity.method_5797().getString().contains("Cursed")) {
                    entity.method_31472();
                }
            });
            this.method_80();
            for (class_3222 player : world.method_18456()) {
                this.clearHostileEffects(player);
                player.method_7353((class_2561)class_2561.method_43470((String)"\u00a72\u00a7lThe Curse has been lifted!"), false);
                player.method_7353((class_2561)class_2561.method_43470((String)"\u00a7aThe world returns to its natural state."), false);
                LoreHandler.showChapter2Title(player);
            }
        }
    }

    private void clearHostileEffects(class_3222 player) {
        ArrayList<class_1293> effectsToRemove = new ArrayList<class_1293>();
        for (class_1293 effect : player.method_6026()) {
            if (((class_1291)effect.method_5579().comp_349()).method_5573()) continue;
            effectsToRemove.add(effect);
        }
        for (class_1293 effect : effectsToRemove) {
            player.method_6016(effect.method_5579());
        }
    }

    public void onPlayerJoin(class_3222 player) {
        if (this.curseActive) {
            if (this.curseBossBar != null) {
                this.curseBossBar.method_14088(player);
            }
            class_3218 world = (class_3218)player.method_37908();
            this.startCurseMusicForPlayer(world, player);
            this.cursePaused = false;
            this.method_80();
        }
    }

    public void onPlayerLeave(class_3222 player) {
        UUID playerId = player.method_5667();
        if (this.curseBossBar != null) {
            this.curseBossBar.method_14089(player);
        }
        this.playerMusicStartTimes.remove(playerId);
        this.playerMusicPlaying.remove(playerId);
    }

    public void checkPauseState(class_3218 world) {
        if (this.curseActive && world.method_18456().size() == 0) {
            this.cursePaused = true;
            this.method_80();
        }
    }

    private void createBossBar() {
        this.curseBossBar = new class_3213((class_2561)class_2561.method_43470((String)"\u00a74 Curse"), class_1259.class_1260.field_5784, class_1259.class_1261.field_5791);
        this.updateBossBar();
    }

    private void updateBossBar() {
        if (this.curseBossBar != null) {
            float progress = (float)this.mobsKilled / 10.0f;
            this.curseBossBar.method_5408(progress);
            this.curseBossBar.method_5413((class_2561)class_2561.method_43470((String)("\u00a74Curse \u00a7r- Kill Cursed Mobs: " + this.mobsKilled + "/10")));
        }
    }

    public boolean isCurseActive() {
        return this.curseActive;
    }

    public boolean isCursePaused() {
        return this.cursePaused;
    }

    public int getMobsKilled() {
        return this.mobsKilled;
    }

    public boolean isCurseMusicPlayingForPlayer(UUID playerId) {
        return this.curseActive && this.playerMusicPlaying.getOrDefault(playerId, false) != false;
    }

    public void tick(class_3218 world) {
        if (this.curseActive && !this.cursePaused) {
            world.method_29199(18000L);
            world.method_27910(6000, 0, false, true);
            for (class_3222 player : world.method_18456()) {
                long timeSinceStart;
                UUID playerId = player.method_5667();
                Long playerMusicStart = this.playerMusicStartTimes.get(playerId);
                if (playerMusicStart == null || (timeSinceStart = world.method_8510() - playerMusicStart) < 2730L) continue;
                this.startCurseMusicForPlayer(world, player);
            }
            if (world.method_8510() % 40L == 0L) {
                for (class_3222 player : world.method_18456()) {
                    this.stopBackgroundMusicForPlayer(player);
                }
            }
            if (world.method_8510() % 20L == 0L) {
                for (class_3222 player : world.method_18456()) {
                    double playerX = player.method_23317();
                    double playerZ = player.method_23321();
                    for (int i = 0; i < 15; ++i) {
                        double x = playerX + (world.method_8409().method_43058() - 0.5) * 40.0;
                        double z = playerZ + (world.method_8409().method_43058() - 0.5) * 40.0;
                        double y = world.method_8624(class_2902.class_2903.field_13203, (int)x, (int)z);
                        world.method_14199((class_2394)class_2398.field_11219, x, y + 20.0, z, 12, 0.5, 0.0, 0.5, 0.0);
                        world.method_14199((class_2394)class_2398.field_11251, x, y + 1.0, z, 8, 1.0, 0.5, 1.0, 0.05);
                        world.method_14199((class_2394)class_2398.field_23114, x, y + 1.0, z, 4, 2.0, 1.0, 2.0, 0.02);
                    }
                    world.method_14199((class_2394)class_2398.field_22248, playerX, player.method_23318() + 2.0, playerZ, 9, 3.0, 1.0, 3.0, 0.1);
                }
            }
            if (world.method_8510() % 80L == 0L) {
                for (class_3222 player : world.method_18456()) {
                    if (!(world.method_8409().method_43057() < 0.4f)) continue;
                    this.spawnSporeVisionCloud(world, player);
                }
            }
        }
    }

    private void spawnSporeVisionCloud(class_3218 world, class_3222 player) {
        double distance = 6.0 + world.method_8409().method_43058() * 2.0;
        double angle = world.method_8409().method_43058() * 2.0 * Math.PI;
        double offsetX = Math.cos(angle) * distance;
        double offsetZ = Math.sin(angle) * distance;
        double x = player.method_23317() + offsetX;
        double z = player.method_23321() + offsetZ;
        double y = player.method_23318() + world.method_8409().method_43058() * 2.0;
        class_1295 cloud = new class_1295((class_1937)world, x, y, z);
        cloud.method_5603(3.5f);
        cloud.method_5604(300);
        cloud.method_5595(10);
        cloud.method_5596(-0.005f);
        class_1293 effect = new class_1293(ModEffects.SPORE_VISION_EFFECT, 280, 0, false, true);
        cloud.method_5610(effect);
        cloud.method_5608((class_2394)class_2398.field_29645);
        world.method_8649((class_1297)cloud);
    }
}

