/*
 * Decompiled with CFR 0.152.
 */
package com.example.screeneffects;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;

public class ClientEffects {
    private static long shakeEndTime = 0L;
    private static float shakeIntensity = 0.0f;
    private static float shakeSpeed = 0.0f;
    private static long flashEndTime = 0L;
    private static long pulseEndTime = 0L;
    private static float pulseIntensity = 0.0f;
    private static float pulseSpeed = 0.0f;
    private static long warnEndTime = 0L;

    public static void startShake(int duration, float intensity, float speed) {
        shakeEndTime = System.currentTimeMillis() + (long)duration;
        shakeIntensity = intensity;
        shakeSpeed = speed;
    }

    public static void startFlash(int duration, float intensity) {
        flashEndTime = System.currentTimeMillis() + (long)duration;
    }

    public static void startPulse(int duration, float intensity, float speed) {
        pulseEndTime = System.currentTimeMillis() + (long)duration;
        pulseIntensity = intensity;
        pulseSpeed = speed;
    }

    public static void startWarning(int duration) {
        warnEndTime = System.currentTimeMillis() + (long)duration;
    }

    public static void renderEffects(GuiGraphics guiGraphics, float partialTicks, int width, int height) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        long now = System.currentTimeMillis();
        if (now < shakeEndTime) {
            double offsetX = Math.sin((double)now * 0.01 * (double)shakeSpeed) * 0.05 * (double)shakeIntensity;
            double offsetY = Math.cos((double)now * 0.01 * (double)shakeSpeed) * 0.05 * (double)shakeIntensity;
            player.m_6034_(player.m_20185_() + offsetX, player.m_20186_() + offsetY, player.m_20189_());
        }
        if (now < flashEndTime) {
            // empty if block
        }
        if (now < pulseEndTime) {
            // empty if block
        }
        if (now < warnEndTime) {
            String text = "\u0411\u0415\u0413\u0418\u0422\u0415";
            int textWidth = Minecraft.m_91087_().f_91062_.m_92895_(text);
            int x = (width - textWidth) / 2;
            int y = height / 2 - 20;
            guiGraphics.m_280056_(Minecraft.m_91087_().f_91062_, text, x, y, 0xFF0000, true);
        }
    }
}

