/*
 * Decompiled with CFR 0.152.
 */
package com.example.screeneffects;

import com.example.screeneffects.ClientEffects;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class EffectPacket {
    private final String effect;
    private final int duration;
    private final float intensity;
    private final float speed;

    public EffectPacket(String effect, int duration, float intensity, float speed) {
        this.effect = effect;
        this.duration = duration;
        this.intensity = intensity;
        this.speed = speed;
    }

    public static void encode(EffectPacket pkt, FriendlyByteBuf buf) {
        buf.m_130070_(pkt.effect);
        buf.writeInt(pkt.duration);
        buf.writeFloat(pkt.intensity);
        buf.writeFloat(pkt.speed);
    }

    public static EffectPacket decode(FriendlyByteBuf buf) {
        String effect = buf.m_130277_();
        int duration = buf.readInt();
        float intensity = buf.readFloat();
        float speed = buf.readFloat();
        return new EffectPacket(effect, duration, intensity, speed);
    }

    public static void handle(EffectPacket pkt, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            if (Minecraft.m_91087_().f_91074_ == null) {
                return;
            }
            if ("shake".equals(pkt.effect)) {
                ClientEffects.startShake(pkt.duration, pkt.intensity, pkt.speed);
            }
            if ("flash".equals(pkt.effect)) {
                ClientEffects.startFlash(pkt.duration, pkt.intensity);
            }
            if ("pulse".equals(pkt.effect)) {
                ClientEffects.startPulse(pkt.duration, pkt.intensity, pkt.speed);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

