/*
 * Decompiled with CFR 0.152.
 */
package com.example.screeneffects;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import net.minecraftforge.server.ServerLifecycleHooks;

@Mod(value="screeneffects")
public class ScreenEffectsMod {
    public static final String MODID = "screeneffects";
    private static final String PROTOCOL = "1";
    public static final SimpleChannel CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("screeneffects", "main"), () -> "1", "1"::equals, "1"::equals);
    private static int packetIndex = 0;
    private static final DeferredRegister<SoundEvent> SOUND_EVENTS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.SOUND_EVENTS, (String)"screeneffects");
    public static final RegistryObject<SoundEvent> KWRS_START_SOUND = SOUND_EVENTS.register("kwrs_start", () -> SoundEvent.m_262824_((ResourceLocation)new ResourceLocation(MODID, "kwrs_start")));
    private static final List<String> KWRS_MESSAGES = List.of("[KWRS] \u041d\u0430\u0433\u0440\u0443\u0437\u043a\u0430 \u043f\u0440\u0435\u0432\u044b\u0448\u0430\u0435\u0442 \u0430\u0434\u0430\u043f\u0442\u0430\u0446\u0438\u043e\u043d\u043d\u044b\u0439 \u043f\u043e\u0440\u043e\u0433.", "[KWRS] \u041b\u0438\u0447\u043d\u043e\u0441\u0442\u043d\u0430\u044f \u0441\u0442\u0440\u0443\u043a\u0442\u0443\u0440\u0430 \u0434\u0435\u0441\u0442\u0430\u0431\u0438\u043b\u0438\u0437\u0438\u0440\u043e\u0432\u0430\u043d\u0430.", "[KWRS] \u0423\u0440\u043e\u0432\u0435\u043d\u044c \u0434\u043e\u0432\u0435\u0440\u0438\u044f: \u0440\u0430\u0437\u0440\u0443\u0448\u0435\u043d.", "[KWRS] \u042d\u043d\u0435\u0440\u0433\u0438\u0447\u0435\u0441\u043a\u0438\u0439 \u0440\u0435\u0441\u0443\u0440\u0441 \u043f\u0441\u0438\u0445\u0438\u043a\u0438 - 5%.", "[KWRS] \u041d\u0430\u0440\u0443\u0448\u0435\u043d\u0438\u0435 \u0446\u0438\u0440\u043a\u0430\u0434\u043d\u044b\u0445 \u0440\u0438\u0442\u043c\u043e\u0432: \u0431\u0435\u0441\u0441\u043e\u043d\u043d\u0438\u0446\u0430.", "[KWRS] \u0421\u043e\u0446\u0438\u0430\u043b\u044c\u043d\u0430\u044f \u0438\u0437\u043e\u043b\u044f\u0446\u0438\u044f \u0443\u0441\u0438\u043b\u0438\u0432\u0430\u0435\u0442\u0441\u044f.", "[KWRS] \u041a\u043e\u0433\u043d\u0438\u0442\u0438\u0432\u043d\u0430\u044f \u0432\u0435\u0440\u0430 - \u043e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442.", "[KWRS] \u0422\u043e\u043b\u0435\u0440\u0430\u043d\u0442\u043d\u043e\u0441\u0442\u044c \u043a \u0441\u0442\u0440\u0435\u0441\u0441\u0443: \u0441\u043b\u043e\u043c\u0430\u043d\u0430.", "[KWRS] \u042d\u043a\u0437\u0438\u0441\u0442\u0435\u043d\u0446\u0438\u0430\u043b\u044c\u043d\u044b\u0439 \u0441\u043c\u044b\u0441\u043b \u0443\u0442\u0435\u0440\u044f\u043d.", "[KWRS] \u041e\u043f\u0442\u0438\u0447\u0435\u0441\u043a\u0430\u044f \u043f\u0440\u043e\u0435\u043a\u0446\u0438\u044f: \u043e\u0431\u043d\u0443\u043b\u0435\u043d\u0430.", "[KWRS] \u0421\u0430\u043c\u043e\u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u044f \u043d\u0430\u0440\u0443\u0448\u0435\u043d\u0430.", "[KWRS] \u042d\u043c\u043e\u0446\u0438\u043e\u043d\u0430\u043b\u044c\u043d\u044b\u0439 \u0441\u043f\u0435\u043a\u0442\u0440: \u043f\u0443\u0441\u0442\u043e\u0442\u0430.", "[KWRS] \u0411\u0438\u043e\u043b\u043e\u0433\u0438\u0447\u0435\u0441\u043a\u0438\u0439 \u0441\u0438\u0433\u043d\u0430\u043b \u0436\u0438\u0437\u043d\u0438: \u0441\u043b\u0430\u0431\u044b\u0439, \u043d\u043e \u0444\u0438\u043a\u0441\u0438\u0440\u0443\u0435\u0442\u0441\u044f.", "[KWRS] \u041e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0438\u0435 \u0434\u0430\u043d\u043d\u044b\u0445 \u043f\u043e Kira_Gens...", "[KWRS] \u0412\u041d\u0415\u0417\u0410\u041f\u041d\u042b\u0419 \u0412\u042b\u0411\u0420\u041e\u0421 \u0410\u0414\u0420\u0415\u041d\u0410\u041b\u0418\u041d\u0410: +247%", "[KWRS] \u0423\u0420\u041e\u0412\u0415\u041d\u042c \u041a\u041e\u0420\u0422\u0418\u0417\u041e\u041b\u0410: \u041f\u0420\u0415\u0412\u042b\u0428\u0415\u041d\u0418\u0415 \u041a\u0420\u0418\u0422\u0418\u0427\u0415\u0421\u041a\u041e\u0419 \u041d\u041e\u0420\u041c\u042b.", "[KWRS] \u0427\u0410\u0421\u0422\u041e\u0422\u0410 \u0421\u0415\u0420\u0414\u0415\u0427\u041d\u042b\u0425 \u0421\u041e\u041a\u0420\u0410\u0429\u0415\u041d\u0418\u0419: 186 \u0423\u0414/\u041c\u0418\u041d.", "[KWRS] \u041f\u0421\u0418\u0425\u041e\u041b\u041e\u0413\u0418\u0427\u0415\u0421\u041a\u0410\u042f \u0424\u041e\u0420\u041c\u0410:", "\u042f\u0420\u041e\u0421\u0422\u042c \u041a\u0410\u041a \u0424\u041e\u0420\u041c\u0410 \u0417\u0410\u0429\u0418\u0422\u042b.");
    private static int messageIndex = -1;
    private static int messageDelay = 0;
    private static final int MESSAGE_INTERVAL = 44;
    private static final int SPECIAL_INTERVAL_AFTER_INDEX_12 = 60;

    public ScreenEffectsMod() {
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        SOUND_EVENTS.register(modBus);
        modBus.addListener(this::setup);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void setup(FMLCommonSetupEvent ev) {
        CHANNEL.registerMessage(packetIndex++, EffectPacket.class, EffectPacket::encode, EffectPacket::decode, EffectPacket::handle, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
    }

    @SubscribeEvent
    public void onRegisterCommands(RegisterCommandsEvent event) {
        LiteralArgumentBuilder root = (LiteralArgumentBuilder)Commands.m_82127_((String)"fx").requires(src -> src.m_6761_(2));
        root.then(Commands.m_82127_((String)"kwrs_sequence").executes(ctx -> {
            this.startKWRSSequence();
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)"KWRS sequence started"), true);
            return 1;
        }));
        event.getDispatcher().register(root);
    }

    private void startKWRSSequence() {
        messageIndex = 0;
        messageDelay = 0;
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (messageIndex < 0) {
            return;
        }
        if (messageDelay > 0) {
            --messageDelay;
            return;
        }
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server == null) {
            return;
        }
        if (messageIndex >= 0 && messageIndex < KWRS_MESSAGES.size()) {
            this.sendKwrsMessage(server, messageIndex);
            messageDelay = 44;
            if (messageIndex == 12) {
                messageDelay = 60;
            }
            if (messageIndex >= KWRS_MESSAGES.size() - 2) {
                messageDelay = 39;
            }
            ++messageIndex;
        } else {
            messageIndex = -1;
            messageDelay = 0;
        }
    }

    private void sendKwrsMessage(MinecraftServer server, int index) {
        for (ServerPlayer p : server.m_6846_().m_11314_()) {
            p.m_213846_((Component)Component.m_237113_((String)KWRS_MESSAGES.get(index)));
        }
        server.m_129783_().m_8615_(server.m_129783_().m_46468_() + 13000L);
        if (index == 0) {
            int firstDuration = 920;
            float firstIntensity = 0.2f;
            float firstSpeed = 1.0f;
            for (ServerPlayer p : server.m_6846_().m_11314_()) {
                try {
                    server.m_129783_().m_5594_(null, p.m_20183_(), (SoundEvent)KWRS_START_SOUND.get(), SoundSource.MASTER, 1.0f, 1.0f);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                CHANNEL.send(PacketDistributor.PLAYER.with(() -> p), (Object)new EffectPacket("shake", firstDuration, firstIntensity, firstSpeed));
            }
        }
        if (index == 14) {
            int strongDuration = 200;
            float strongIntensity = 6.0f;
            float strongSpeed = 2.0f;
            for (ServerPlayer p : server.m_6846_().m_11314_()) {
                CHANNEL.send(PacketDistributor.PLAYER.with(() -> p), (Object)new EffectPacket("shake", strongDuration, strongIntensity, strongSpeed));
                CHANNEL.send(PacketDistributor.PLAYER.with(() -> p), (Object)new EffectPacket("flash", 20, 1.0f, 1.0f));
                try {
                    server.m_129783_().m_5594_(null, p.m_20183_(), SoundEvents.f_11913_, SoundSource.MASTER, 1.0f, 1.0f);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (p.m_7500_() || p.m_5833_()) continue;
                Vec3 look = p.m_20154_();
                double lx = look.f_82479_;
                double lz = look.f_82481_;
                double lenH = Math.sqrt(lx * lx + lz * lz);
                Vec3 backward = lenH > 1.0E-6 ? new Vec3(-lx / lenH, 0.0, -lz / lenH).m_82490_(2.5) : new Vec3(0.0, 0.0, -2.5);
                Vec3 knock = new Vec3(backward.f_82479_ * 0.6, 1.2, backward.f_82481_ * 0.6);
                p.m_20256_(p.m_20184_().m_82549_(knock));
                p.f_19864_ = true;
            }
        }
        if (index == KWRS_MESSAGES.size() - 1) {
            int warnTicks = 100;
            for (ServerPlayer plr : server.m_6846_().m_11314_()) {
                CHANNEL.send(PacketDistributor.PLAYER.with(() -> plr), (Object)new EffectPacket("warn", warnTicks, 1.0f, 1.0f));
            }
        }
    }

    public static class EffectPacket {
        public final String type;
        public final int duration;
        public final float intensity;
        public final float speed;

        public EffectPacket(String type, int duration, float intensity, float speed) {
            this.type = type;
            this.duration = duration;
            this.intensity = intensity;
            this.speed = speed;
        }

        public static void encode(EffectPacket pkt, FriendlyByteBuf buf) {
            buf.m_130070_(pkt.type);
            buf.writeInt(pkt.duration);
            buf.writeFloat(pkt.intensity);
            buf.writeFloat(pkt.speed);
        }

        public static EffectPacket decode(FriendlyByteBuf buf) {
            String t = buf.m_130136_(Short.MAX_VALUE);
            int d = buf.readInt();
            float i = buf.readFloat();
            float s = buf.readFloat();
            return new EffectPacket(t, d, i, s);
        }

        public static void handle(EffectPacket pkt, Supplier<NetworkEvent.Context> ctxSupplier) {
            NetworkEvent.Context ctx = ctxSupplier.get();
            ctx.enqueueWork(() -> {
                if (FMLEnvironment.dist == Dist.CLIENT) {
                    Minecraft.m_91087_().execute(() -> {
                        switch (pkt.type) {
                            case "shake": {
                                ClientEffects.startShake(pkt.duration, pkt.intensity, pkt.speed);
                                break;
                            }
                            case "flash": {
                                ClientEffects.startFlash(pkt.duration, pkt.intensity);
                                break;
                            }
                            case "pulse": {
                                ClientEffects.startPulse(pkt.duration, pkt.intensity, pkt.speed);
                                break;
                            }
                            case "warn": {
                                ClientEffects.startWarn(pkt.duration);
                            }
                        }
                    });
                }
            });
            ctx.setPacketHandled(true);
        }
    }

    @Mod.EventBusSubscriber(modid="screeneffects", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class ClientForgeHandlers {
        @SubscribeEvent
        public static void clientTick(TickEvent.ClientTickEvent ev) {
            if (ev.phase == TickEvent.Phase.END) {
                ClientEffects.tick();
            }
        }

        @SubscribeEvent
        public static void onCamera(ViewportEvent.ComputeCameraAngles ev) {
            ClientEffects.applyCameraShake(ev);
        }
    }

    @Mod.EventBusSubscriber(modid="screeneffects", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
    public static class ClientModSetup {
        @SubscribeEvent
        public static void registerOverlay(RegisterGuiOverlaysEvent evt) {
            evt.registerAboveAll("screenfx", (forgeGui, guiGraphics, partialTicks, width, height) -> ClientEffects.renderOverlay(guiGraphics, partialTicks, width, height));
        }
    }

    public static class ClientEffects {
        private static final List<ClientActive> active = new ArrayList<ClientActive>();
        private static final Random rnd = new Random();
        private static int warnTicks = 0;
        private static String warnMessage = null;

        public static void startShake(int duration, float intensity, float speed) {
            active.add(new ClientActive("shake", duration, intensity, speed));
        }

        public static void startFlash(int duration, float intensity) {
            active.add(new ClientActive("flash", duration, intensity, 1.0f));
        }

        public static void startPulse(int duration, float intensity, float speed) {
            active.add(new ClientActive("pulse", duration, intensity, speed));
        }

        public static void startWarn(int duration) {
            warnMessage = "\u0411\u0415\u0413\u0418\u0422\u0415";
            warnTicks = Math.max(0, duration);
        }

        public static void tick() {
            Iterator<ClientActive> it = active.iterator();
            while (it.hasNext()) {
                ClientActive a = it.next();
                --a.ticksLeft;
                if (a.ticksLeft > 0) continue;
                it.remove();
            }
            if (warnTicks > 0) {
                --warnTicks;
            }
        }

        public static void renderOverlay(GuiGraphics gui, float partialTicks, int width, int height) {
            int alpha = 0;
            for (ClientActive a : active) {
                if (!"flash".equals(a.type)) continue;
                float prog = 1.0f - (float)a.ticksLeft / (float)Math.max(1, a.totalTicks);
                int aVal = (int)((1.0f - Math.abs(prog - 0.5f) * 2.0f) * 255.0f * a.intensity);
                alpha = Math.max(alpha, Math.max(0, Math.min(255, aVal)));
            }
            if (alpha > 0) {
                int color = alpha << 24 | 0xFFFFFF;
                gui.m_280509_(0, 0, width, height, color);
            }
            if (warnTicks > 0 && warnMessage != null && warnTicks % 2 == 0) {
                int color = -65536;
                int strWidth = Minecraft.m_91087_().f_91062_.m_92895_(warnMessage);
                int x = (width - strWidth) / 2;
                int y = height / 2 - 20;
                gui.m_280056_(Minecraft.m_91087_().f_91062_, warnMessage, x, y, color, true);
            }
        }

        public static void applyCameraShake(ViewportEvent.ComputeCameraAngles ev) {
            float totalYaw = 0.0f;
            float totalPitch = 0.0f;
            for (ClientActive a : active) {
                if (!"shake".equals(a.type)) continue;
                float lifeFactor = (float)a.ticksLeft / (float)Math.max(1, a.totalTicks);
                float base = a.intensity * 3.5f * a.speed * lifeFactor;
                totalYaw += (rnd.nextFloat() - 0.5f) * base * 2.0f;
                totalPitch += (rnd.nextFloat() - 0.5f) * base * 2.0f;
            }
            if (Math.abs(totalYaw) > 1.0E-4f || Math.abs(totalPitch) > 1.0E-4f) {
                ev.setYaw(ev.getYaw() + totalYaw);
                ev.setPitch(ev.getPitch() + totalPitch);
            }
        }

        private static class ClientActive {
            final String type;
            int ticksLeft;
            final int totalTicks;
            final float intensity;
            final float speed;

            ClientActive(String type, int duration, float intensity, float speed) {
                this.type = type;
                this.ticksLeft = this.totalTicks = Math.max(1, duration);
                this.intensity = Math.max(0.01f, intensity);
                this.speed = Math.max(0.01f, speed);
            }
        }
    }
}

