/*
 * Decompiled with CFR 0.152.
 */
package club.arson.impulse.dockerbroker;

import club.arson.impulse.api.config.ServerConfig;
import club.arson.impulse.api.server.Broker;
import club.arson.impulse.api.server.Status;
import club.arson.impulse.dockerbroker.DockerBroker;
import club.arson.impulse.dockerbroker.DockerServerConfig;
import club.arson.impulse.dockerbroker.DockerTlsConfig;
import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.command.PullImageResultCallback;
import com.github.dockerjava.api.exception.NotFoundException;
import com.github.dockerjava.api.exception.NotModifiedException;
import com.github.dockerjava.api.model.Bind;
import com.github.dockerjava.api.model.DockerObject;
import com.github.dockerjava.api.model.ExposedPort;
import com.github.dockerjava.api.model.HostConfig;
import com.github.dockerjava.api.model.PortBinding;
import com.github.dockerjava.api.model.Ports;
import com.github.dockerjava.api.model.PullResponseItem;
import com.github.dockerjava.api.model.ResponseItem;
import com.github.dockerjava.api.model.RestartPolicy;
import com.github.dockerjava.api.model.Volume;
import com.github.dockerjava.core.DefaultDockerClientConfig;
import com.github.dockerjava.core.DockerClientImpl;
import com.github.dockerjava.httpclient5.ApacheDockerHttpClient;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.UnrecoverableKeyException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.SSLContext;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Deferred;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.ssl.SSLContexts;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0002DEB\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u0003H\u0002J$\u0010\u001a\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u00140\u00132\u0006\u0010\u001b\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u001d\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u001d\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u001d\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\u0006\u0010\u001b\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b!\u0010\u001fJ\u001d\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u00142\u0006\u0010\u001b\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b$\u0010\u001fJ\u001f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\b\b\u0002\u0010&\u001a\u00020'H\u0002\u00a2\u0006\u0004\b(\u0010)J\u0015\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002\u00a2\u0006\u0004\b+\u0010,J\u0015\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002\u00a2\u0006\u0004\b.\u0010,J\u0015\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002\u00a2\u0006\u0004\b0\u0010,J\u0015\u00101\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002\u00a2\u0006\u0004\b2\u0010,J\n\u00103\u001a\u0004\u0018\u00010\fH\u0002J\b\u00104\u001a\u000205H\u0016J\b\u00106\u001a\u00020'H\u0016J\u0015\u00107\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0016\u00a2\u0006\u0004\b8\u0010,J\u0015\u00109\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0016\u00a2\u0006\u0004\b:\u0010,J\u0015\u0010;\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0016\u00a2\u0006\u0004\b<\u0010,J\u0015\u0010=\u001a\b\u0012\u0004\u0012\u00020>0\u0014H\u0016\u00a2\u0006\u0004\b?\u0010,J\u001f\u0010@\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010A0\u00142\u0006\u0010\u0019\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\bB\u0010CR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0012\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u0014\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006F"}, d2={"Lclub/arson/impulse/dockerbroker/DockerBroker;", "Lclub/arson/impulse/api/server/Broker;", "serverConfig", "Lclub/arson/impulse/api/config/ServerConfig;", "logger", "Lorg/slf4j/Logger;", "<init>", "(Lclub/arson/impulse/api/config/ServerConfig;Lorg/slf4j/Logger;)V", "startupTimeout", "", "stopTimeout", "name", "", "client", "Lcom/github/dockerjava/api/DockerClient;", "dockerConfig", "Lclub/arson/impulse/dockerbroker/DockerServerConfig;", "dockerHost", "pullImageTask", "Lkotlinx/coroutines/Deferred;", "Lkotlin/Result;", "", "scope", "Lkotlinx/coroutines/CoroutineScope;", "configureDockerClient", "config", "tryPullImageIfMissing", "image", "pullImageIfNotPresent", "taggedImage", "pullImageIfNotPresent-IoAF18A", "(Ljava/lang/String;)Ljava/lang/Object;", "pullImage", "pullImage-IoAF18A", "inspectImage", "Lcom/github/dockerjava/api/command/InspectImageResponse;", "inspectImage-IoAF18A", "createContainer", "autoStart", "", "createContainer-IoAF18A", "(Z)Ljava/lang/Object;", "startContainer", "startContainer-d1pmJ48", "()Ljava/lang/Object;", "stopContainer", "stopContainer-d1pmJ48", "awaitContainerStart", "awaitContainerStart-d1pmJ48", "awaitContainerStop", "awaitContainerStop-d1pmJ48", "getContainerStatus", "getStatus", "Lclub/arson/impulse/api/server/Status;", "isRunning", "startServer", "startServer-d1pmJ48", "stopServer", "stopServer-d1pmJ48", "removeServer", "removeServer-d1pmJ48", "address", "Ljava/net/InetSocketAddress;", "address-d1pmJ48", "reconcile", "Ljava/lang/Runnable;", "reconcile-IoAF18A", "(Lclub/arson/impulse/api/config/ServerConfig;)Ljava/lang/Object;", "SSLHelper", "ProgressCallback", "docker-broker"})
@SourceDebugExtension(value={"SMAP\nDockerBroker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DockerBroker.kt\nclub/arson/impulse/dockerbroker/DockerBroker\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,469:1\n1#2:470\n1863#3,2:471\n1557#3:473\n1628#3,3:474\n1557#3:485\n1628#3,3:486\n1557#3:496\n1628#3,3:497\n1557#3:505\n1628#3,3:506\n126#4:477\n153#4,3:478\n126#4:481\n153#4,3:482\n126#4:489\n153#4,2:490\n155#4:500\n11158#5:492\n11493#5,3:493\n11158#5:501\n11493#5,3:502\n*S KotlinDebug\n*F\n+ 1 DockerBroker.kt\nclub/arson/impulse/dockerbroker/DockerBroker\n*L\n221#1:471,2\n229#1:473\n229#1:474,3\n435#1:485\n435#1:486,3\n441#1:496\n441#1:497,3\n446#1:505\n446#1:506,3\n239#1:477\n239#1:478,3\n431#1:481\n431#1:482,3\n439#1:489\n439#1:490,2\n439#1:500\n440#1:492\n440#1:493,3\n445#1:501\n445#1:502,3\n*E\n"})
public final class DockerBroker
implements Broker {
    @Nullable
    private final Logger logger;
    private long startupTimeout;
    private long stopTimeout;
    @NotNull
    private final String name;
    private DockerClient client;
    private DockerServerConfig dockerConfig;
    private String dockerHost;
    @Nullable
    private Deferred<Result<Unit>> pullImageTask;
    @NotNull
    private final CoroutineScope scope;

    public DockerBroker(@NotNull ServerConfig serverConfig, @Nullable Logger logger) {
        Intrinsics.checkNotNullParameter(serverConfig, "serverConfig");
        this.logger = logger;
        this.name = serverConfig.getName();
        this.scope = CoroutineScopeKt.CoroutineScope(Dispatchers.getIO());
        this.startupTimeout = serverConfig.getLifecycleSettings().getTimeouts().getStartup();
        this.stopTimeout = serverConfig.getLifecycleSettings().getTimeouts().getShutdown();
        this.configureDockerClient(serverConfig);
    }

    public /* synthetic */ DockerBroker(ServerConfig serverConfig, Logger logger, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            logger = null;
        }
        this(serverConfig, logger);
    }

    private final void configureDockerClient(ServerConfig config) {
        DockerServerConfig dockerConfig;
        Object object = config.getConfig();
        DockerServerConfig dockerServerConfig = dockerConfig = object instanceof DockerServerConfig ? (DockerServerConfig)object : null;
        if (dockerConfig == null) {
            Logger logger = this.logger;
            if (logger != null) {
                logger.error("Configuration missing for docker broker " + config.getName());
            }
            throw new Exception("Unable to create docker broker");
        }
        this.dockerConfig = dockerConfig;
        this.dockerHost = dockerConfig.getHostPath();
        DefaultDockerClientConfig.Builder builder = DefaultDockerClientConfig.createDefaultConfigBuilder();
        String string = this.dockerHost;
        if (string == null) {
            Intrinsics.throwUninitializedPropertyAccessException("dockerHost");
            string = null;
        }
        DefaultDockerClientConfig.Builder clientConfigBuilder = builder.withDockerHost(string).withCustomSslConfig(() -> DockerBroker.configureDockerClient$lambda$0(dockerConfig, this));
        if (dockerConfig.getTlsConfig().getEnabled()) {
            clientConfigBuilder.withDockerTlsVerify(dockerConfig.getTlsConfig().getTlsVerify());
        }
        DefaultDockerClientConfig clientConfig = clientConfigBuilder.build();
        ApacheDockerHttpClient httpClient = new ApacheDockerHttpClient.Builder().sslConfig(clientConfig.getSSLConfig()).dockerHost(clientConfig.getDockerHost()).maxConnections(100).connectionTimeout(Duration.ofSeconds(30L)).responseTimeout(Duration.ofSeconds(45L)).build();
        this.client = DockerClientImpl.getInstance(clientConfig, httpClient);
        this.startupTimeout = config.getLifecycleSettings().getTimeouts().getStartup();
        this.stopTimeout = config.getLifecycleSettings().getTimeouts().getShutdown();
        if (this.pullImageTask != null) {
            Deferred<Result<Unit>> deferred = this.pullImageTask;
            if (deferred != null) {
                Job.DefaultImpls.cancel$default((Job)deferred, null, 1, null);
            }
        }
        this.pullImageTask = this.tryPullImageIfMissing(dockerConfig.getImage(), this.scope);
    }

    private final Deferred<Result<Unit>> tryPullImageIfMissing(String image, CoroutineScope scope) {
        Object taggedImage = StringsKt.contains$default((CharSequence)image, ":", false, 2, null) ? image : image + ":latest";
        return BuildersKt.async$default(scope, null, null, new Function2<CoroutineScope, Continuation<? super Result<? extends Unit>>, Object>(this, (String)taggedImage, null){
            int label;
            final /* synthetic */ DockerBroker this$0;
            final /* synthetic */ String $taggedImage;
            {
                this.this$0 = $receiver;
                this.$taggedImage = $taggedImage;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object object) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure(object);
                        DockerServerConfig dockerServerConfig = DockerBroker.access$getDockerConfig$p(this.this$0);
                        if (dockerServerConfig == null) {
                            Intrinsics.throwUninitializedPropertyAccessException("dockerConfig");
                            dockerServerConfig = null;
                        }
                        return Result.box-impl(switch (tryPullImageIfMissing.WhenMappings.$EnumSwitchMapping$0[dockerServerConfig.getImagePullPolicy().ordinal()]) {
                            case 1 -> {
                                Logger v1 = DockerBroker.access$getLogger$p(this.this$0);
                                if (v1 != null) {
                                    v1.info("Docker Broker: Pulling image " + this.$taggedImage);
                                }
                                yield DockerBroker.access$pullImage-IoAF18A(this.this$0, this.$taggedImage);
                            }
                            case 2 -> DockerBroker.access$pullImageIfNotPresent-IoAF18A(this.this$0, this.$taggedImage);
                            case 3 -> {
                                Logger v3 = DockerBroker.access$getLogger$p(this.this$0);
                                if (v3 != null) {
                                    v3.info("Docker Broker: Skipping image pull for " + this.$taggedImage);
                                }
                                yield Result.constructor-impl(Unit.INSTANCE);
                            }
                            default -> throw new NoWhenBranchMatchedException();
                        });
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Result<Unit>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 3, null);
    }

    private final Object pullImageIfNotPresent-IoAF18A(String taggedImage) {
        Object object;
        Object inspectionResult = this.inspectImage-IoAF18A(taggedImage);
        if (Result.isSuccess-impl(inspectionResult)) {
            Logger logger = this.logger;
            if (logger != null) {
                logger.debug("Docker Broker: image " + taggedImage + " exists");
            }
            object = Result.constructor-impl(Unit.INSTANCE);
        } else {
            Logger logger = this.logger;
            if (logger != null) {
                logger.info("Docker Broker: image " + taggedImage + " does not exist, pulling (This may take a while)...");
            }
            object = this.pullImage-IoAF18A(taggedImage);
        }
        return object;
    }

    private final Object pullImage-IoAF18A(String image) {
        Object object;
        Object $this$pullImage_IoAF18A_u24lambda_u241;
        Object object2 = this;
        try {
            $this$pullImage_IoAF18A_u24lambda_u241 = object2;
            boolean bl = false;
            DockerClient dockerClient = ((DockerBroker)$this$pullImage_IoAF18A_u24lambda_u241).client;
            if (dockerClient == null) {
                Intrinsics.throwUninitializedPropertyAccessException("client");
                dockerClient = null;
            }
            $this$pullImage_IoAF18A_u24lambda_u241 = Result.constructor-impl((ResultCallback.Adapter)((ProgressCallback)dockerClient.pullImageCmd(image).exec((ResultCallback)new ProgressCallback(((DockerBroker)$this$pullImage_IoAF18A_u24lambda_u241).logger))).awaitCompletion());
        }
        catch (Throwable bl) {
            $this$pullImage_IoAF18A_u24lambda_u241 = Result.constructor-impl(ResultKt.createFailure(bl));
        }
        object2 = $this$pullImage_IoAF18A_u24lambda_u241;
        Throwable throwable = Result.exceptionOrNull-impl(object2);
        if (throwable == null) {
            ResultCallback.Adapter it = (ResultCallback.Adapter)object2;
            boolean bl = false;
            Logger logger = this.logger;
            if (logger != null) {
                logger.info("Docker Broker: image " + image + " pulled successfully");
            }
            object = Result.constructor-impl(Unit.INSTANCE);
        } else {
            Throwable exception = throwable;
            boolean bl = false;
            Logger logger = this.logger;
            if (logger != null) {
                logger.info("Docker Broker: image " + image + " failed to pull: " + exception.getMessage());
            }
            object = Result.constructor-impl(ResultKt.createFailure(exception));
        }
        return object;
    }

    private final Object inspectImage-IoAF18A(String image) {
        Object object;
        DockerBroker dockerBroker = this;
        try {
            DockerBroker $this$inspectImage_IoAF18A_u24lambda_u244 = dockerBroker;
            boolean bl = false;
            DockerClient dockerClient = $this$inspectImage_IoAF18A_u24lambda_u244.client;
            if (dockerClient == null) {
                Intrinsics.throwUninitializedPropertyAccessException("client");
                dockerClient = null;
            }
            object = Result.constructor-impl(dockerClient.inspectImageCmd(image).exec());
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl(ResultKt.createFailure(throwable));
        }
        return object;
    }

    private final Object createContainer-IoAF18A(boolean autoStart) {
        Object it;
        Collection collection;
        Object item$iv$iv;
        Map<String, String> $this$mapTo$iv$iv;
        Map<String, String> $this$map$iv;
        String mount;
        Object object;
        Object element$iv2;
        if (this.pullImageTask != null) {
            Object object2 = ((Result)BuildersKt.runBlocking$default(null, new Function2<CoroutineScope, Continuation<? super Result<? extends Unit>>, Object>(this, null){
                int label;
                final /* synthetic */ DockerBroker this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure(object);
                            Deferred deferred = DockerBroker.access$getPullImageTask$p(this.this$0);
                            Intrinsics.checkNotNull(deferred);
                            this.label = 1;
                            Object object3 = deferred.await(this);
                            if (object3 != object2) return object3;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure($result);
                            Object object3 = $result;
                            return object3;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)((Object)new /* invalid duplicate definition of identical inner class */);
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Result<Unit>> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }, 1, null)).unbox-impl();
            Throwable throwable = Result.exceptionOrNull-impl(object2);
            if (throwable != null) {
                Throwable throwable2;
                Throwable it2 = throwable2 = throwable;
                boolean bl = false;
                return Result.constructor-impl(ResultKt.createFailure(it2));
            }
        }
        ArrayList<Bind> binds = new ArrayList<Bind>();
        DockerServerConfig dockerServerConfig = this.dockerConfig;
        if (dockerServerConfig == null) {
            Intrinsics.throwUninitializedPropertyAccessException("dockerConfig");
            dockerServerConfig = null;
        }
        Iterable $this$forEach$iv = dockerServerConfig.getVolumes();
        boolean $i$f$forEach22 = false;
        for (Object element$iv2 : $this$forEach$iv) {
            String it3 = (String)element$iv2;
            boolean bl = false;
            object = new String[]{":"};
            List list = StringsKt.split$default((CharSequence)it3, (String[])object, false, 0, 6, null);
            String hostPath = (String)list.get(0);
            mount = (String)list.get(1);
            binds.add(new Bind(hostPath, new Volume(mount)));
        }
        HostConfig hostConfig = HostConfig.newHostConfig().withRestartPolicy(RestartPolicy.unlessStoppedRestart());
        DockerServerConfig dockerServerConfig2 = this.dockerConfig;
        if (dockerServerConfig2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException("dockerConfig");
            dockerServerConfig2 = null;
        }
        Iterable $i$f$forEach22 = dockerServerConfig2.getPortBindings();
        Object object3 = hostConfig;
        boolean $i$f$map = false;
        element$iv2 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        object = $this$mapTo$iv$iv.iterator();
        while (object.hasNext()) {
            item$iv$iv = object.next();
            mount = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(PortBinding.parse((String)it));
        }
        HostConfig hostConfig2 = ((HostConfig)object3).withPortBindings((List)destination$iv$iv).withBinds((List<Bind>)binds);
        try {
            DockerServerConfig dockerServerConfig3;
            DockerClient dockerClient = this.client;
            if (dockerClient == null) {
                Intrinsics.throwUninitializedPropertyAccessException("client");
                dockerClient = null;
            }
            if ((dockerServerConfig3 = this.dockerConfig) == null) {
                Intrinsics.throwUninitializedPropertyAccessException("dockerConfig");
                dockerServerConfig3 = null;
            }
            CreateContainerCmd createContainerCmd = dockerClient.createContainerCmd(dockerServerConfig3.getImage()).withName(this.name).withHostConfig(hostConfig2).withTty(true).withStdinOpen(true);
            DockerServerConfig dockerServerConfig4 = this.dockerConfig;
            if (dockerServerConfig4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException("dockerConfig");
                dockerServerConfig4 = null;
            }
            $this$map$iv = dockerServerConfig4.getEnv();
            object3 = createContainerCmd;
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList($this$map$iv.size());
            $i$f$mapTo = false;
            object = $this$mapTo$iv$iv.entrySet().iterator();
            while (object.hasNext()) {
                it = item$iv$iv = (Map.Entry)object.next();
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getKey() + "=" + it.getValue());
            }
            object3.withEnv((List)destination$iv$iv).exec();
        }
        catch (Exception e) {
            return Result.constructor-impl(ResultKt.createFailure(e));
        }
        return autoStart ? this.startContainer-d1pmJ48() : Result.constructor-impl(Unit.INSTANCE);
    }

    static /* synthetic */ Object createContainer-IoAF18A$default(DockerBroker dockerBroker, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            DockerServerConfig dockerServerConfig = dockerBroker.dockerConfig;
            if (dockerServerConfig == null) {
                Intrinsics.throwUninitializedPropertyAccessException("dockerConfig");
                dockerServerConfig = null;
            }
            bl = dockerServerConfig.getAutoStartOnCreate();
        }
        return dockerBroker.createContainer-IoAF18A(bl);
    }

    private final Object startContainer-d1pmJ48() {
        try {
            DockerClient dockerClient = this.client;
            if (dockerClient == null) {
                Intrinsics.throwUninitializedPropertyAccessException("client");
                dockerClient = null;
            }
            dockerClient.startContainerCmd(this.name).exec();
        }
        catch (Exception e) {
            return Result.constructor-impl(ResultKt.createFailure(e));
        }
        return this.awaitContainerStart-d1pmJ48();
    }

    private final Object stopContainer-d1pmJ48() {
        Object object;
        Object $this$stopContainer_d1pmJ48_u24lambda_u249;
        Object object2 = this;
        try {
            $this$stopContainer_d1pmJ48_u24lambda_u249 = object2;
            boolean bl = false;
            DockerClient dockerClient = ((DockerBroker)$this$stopContainer_d1pmJ48_u24lambda_u249).client;
            if (dockerClient == null) {
                Intrinsics.throwUninitializedPropertyAccessException("client");
                dockerClient = null;
            }
            $this$stopContainer_d1pmJ48_u24lambda_u249 = Result.constructor-impl(dockerClient.stopContainerCmd(((DockerBroker)$this$stopContainer_d1pmJ48_u24lambda_u249).name).exec());
        }
        catch (Throwable bl) {
            $this$stopContainer_d1pmJ48_u24lambda_u249 = Result.constructor-impl(ResultKt.createFailure(bl));
        }
        object2 = $this$stopContainer_d1pmJ48_u24lambda_u249;
        Throwable throwable = Result.exceptionOrNull-impl(object2);
        if (throwable == null) {
            Void it = (Void)object2;
            boolean bl = false;
            object = this.awaitContainerStop-d1pmJ48();
        } else {
            Throwable exception = throwable;
            boolean bl = false;
            Throwable throwable2 = exception;
            object = throwable2 instanceof NotModifiedException ? Result.constructor-impl(Unit.INSTANCE) : (throwable2 instanceof NotFoundException ? Result.constructor-impl(Unit.INSTANCE) : Result.constructor-impl(ResultKt.createFailure(exception)));
        }
        return object;
    }

    private final Object awaitContainerStart-d1pmJ48() {
        long startTime = System.currentTimeMillis();
        boolean isRunning = false;
        while (!isRunning && System.currentTimeMillis() - startTime * (long)1000 < this.startupTimeout) {
            String status = this.getContainerStatus();
            if (Intrinsics.areEqual(status, "running")) {
                isRunning = true;
            } else if (Intrinsics.areEqual(status, "exited")) {
                return Result.constructor-impl(ResultKt.createFailure(new Throwable("Server " + this.name + " exited unexpectedly")));
            }
            Thread.sleep(500L);
        }
        return isRunning ? Result.constructor-impl(Unit.INSTANCE) : Result.constructor-impl(ResultKt.createFailure(new Throwable("Server " + this.name + " failed to start (timeout)")));
    }

    private final Object awaitContainerStop-d1pmJ48() {
        long startTime = System.currentTimeMillis();
        boolean isStopped = false;
        while (!isStopped && System.currentTimeMillis() - startTime * (long)1000 < this.stopTimeout) {
            String status = this.getContainerStatus();
            if (Intrinsics.areEqual(status, "exited") || Intrinsics.areEqual(status, "dead") || status == null) {
                isStopped = true;
            }
            Thread.sleep(500L);
        }
        return isStopped ? Result.constructor-impl(Unit.INSTANCE) : Result.constructor-impl(ResultKt.createFailure(new Throwable("Server " + this.name + " failed to stop (timeout)")));
    }

    private final String getContainerStatus() {
        String string;
        try {
            DockerClient dockerClient = this.client;
            if (dockerClient == null) {
                Intrinsics.throwUninitializedPropertyAccessException("client");
                dockerClient = null;
            }
            string = dockerClient.inspectContainerCmd(this.name).exec().getState().getStatus();
        }
        catch (NotFoundException e) {
            string = null;
        }
        return string;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @NotNull
    public Status getStatus() {
        block17: {
            block15: {
                block16: {
                    v0 = var1_1 = this.getContainerStatus();
                    if (v0 == null) break block15;
                    switch (v0.hashCode()) {
                        case 1550783935: {
                            if (var1_1.equals("running")) break;
                            ** break;
                        }
                        case -1775170701: {
                            if (!var1_1.equals("restarting")) {
                                ** break;
                            }
                            break block16;
                        }
                        case -995321554: {
                            if (!var1_1.equals("paused")) {
                                ** break;
                            }
                            break block16;
                        }
                        case 1028554472: {
                            if (!var1_1.equals("created")) {
                                ** break;
                            }
                            break block16;
                        }
                        case -1289357763: {
                            if (!var1_1.equals("exited")) {
                                ** break;
                            }
                            break block16;
                        }
                        case 3079268: {
                            if (!var1_1.equals("dead")) {
                                ** break;
                            }
                            break block16;
                        }
                        case -512818111: {
                            if (!var1_1.equals("removing")) {
                                ** break;
                            }
                            break block16;
                        }
                    }
                    v1 = Status.RUNNING;
                    break block17;
                }
                v1 = Status.STOPPED;
                break block17;
            }
            v1 = Status.REMOVED;
            break block17;
lbl39:
            // 8 sources

            v1 = Status.UNKNOWN;
        }
        return v1;
    }

    @Override
    public boolean isRunning() {
        return this.getStatus() == Status.RUNNING;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @NotNull
    public Object startServer-d1pmJ48() {
        block20: {
            block15: {
                block18: {
                    block19: {
                        block17: {
                            block16: {
                                v0 = var1_1 = this.getContainerStatus();
                                if (v0 == null) break block15;
                                switch (v0.hashCode()) {
                                    case 1550783935: {
                                        if (var1_1.equals("running")) break;
                                        ** break;
                                    }
                                    case -1775170701: {
                                        if (!var1_1.equals("restarting")) {
                                            ** break;
                                        }
                                        break block16;
                                    }
                                    case -995321554: {
                                        if (!var1_1.equals("paused")) {
                                            ** break;
                                        }
                                        break block17;
                                    }
                                    case 1028554472: {
                                        if (!var1_1.equals("created")) {
                                            ** break;
                                        }
                                        break block17;
                                    }
                                    case -1289357763: {
                                        if (!var1_1.equals("exited")) {
                                            ** break;
                                        }
                                        break block17;
                                    }
                                    case 3079268: {
                                        if (!var1_1.equals("dead")) {
                                            ** break;
                                        }
                                        break block18;
                                    }
                                    case -512818111: {
                                        if (!var1_1.equals("removing")) {
                                            ** break;
                                        }
                                        break block19;
                                    }
                                }
                                v1 = Result.constructor-impl(Unit.INSTANCE);
                                break block20;
                            }
                            v1 = this.awaitContainerStart-d1pmJ48();
                            break block20;
                        }
                        v1 = this.startContainer-d1pmJ48();
                        break block20;
                    }
                    it = this.awaitContainerStop-d1pmJ48();
                    $i$a$-let-DockerBroker$startServer$1 = false;
                    v1 = Result.isSuccess-impl(it) ? this.startContainer-d1pmJ48() : it;
                    break block20;
                }
                it = this.removeServer-d1pmJ48();
                $i$a$-let-DockerBroker$startServer$2 = false;
                v1 = Result.isSuccess-impl(it) ? this.createContainer-IoAF18A(true) : var2_3;
                break block20;
            }
            v1 = this.createContainer-IoAF18A(true);
            break block20;
lbl53:
            // 8 sources

            v1 = Result.constructor-impl(ResultKt.createFailure(new Throwable("Server " + this.name + " is in unknown state, aborting!")));
        }
        return v1;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @NotNull
    public Object stopServer-d1pmJ48() {
        block18: {
            block14: {
                block16: {
                    block17: {
                        block15: {
                            v0 = var1_1 = this.getContainerStatus();
                            if (v0 == null) break block14;
                            switch (v0.hashCode()) {
                                case 1550783935: {
                                    if (var1_1.equals("running")) break;
                                    ** break;
                                }
                                case -1775170701: {
                                    if (var1_1.equals("restarting")) break;
                                    ** break;
                                }
                                case -995321554: {
                                    if (!var1_1.equals("paused")) {
                                        ** break;
                                    }
                                    break block15;
                                }
                                case 1028554472: {
                                    if (!var1_1.equals("created")) {
                                        ** break;
                                    }
                                    break block15;
                                }
                                case -1289357763: {
                                    if (!var1_1.equals("exited")) {
                                        ** break;
                                    }
                                    break block15;
                                }
                                case 3079268: {
                                    if (!var1_1.equals("dead")) {
                                        ** break;
                                    }
                                    break block16;
                                }
                                case -512818111: {
                                    if (!var1_1.equals("removing")) {
                                        ** break;
                                    }
                                    break block17;
                                }
                            }
                            v1 = this.stopContainer-d1pmJ48();
                            break block18;
                        }
                        v1 = Result.constructor-impl(Unit.INSTANCE);
                        break block18;
                    }
                    v1 = this.awaitContainerStop-d1pmJ48();
                    break block18;
                }
                v1 = this.removeServer-d1pmJ48();
                break block18;
            }
            v1 = Result.constructor-impl(Unit.INSTANCE);
            break block18;
lbl44:
            // 8 sources

            v1 = Result.constructor-impl(ResultKt.createFailure(new Throwable("Server " + this.name + " is in unknown state, aborting!")));
        }
        return v1;
    }

    @Override
    @NotNull
    public Object removeServer-d1pmJ48() {
        Object object = this.stopContainer-d1pmJ48();
        if (Result.isSuccess-impl(object)) {
            Object $this$removeServer_d1pmJ48_u24lambda_u2417_u24lambda_u2414;
            Unit it = (Unit)object;
            boolean bl = false;
            Object object2 = this;
            try {
                $this$removeServer_d1pmJ48_u24lambda_u2417_u24lambda_u2414 = object2;
                boolean bl2 = false;
                DockerClient dockerClient = ((DockerBroker)$this$removeServer_d1pmJ48_u24lambda_u2417_u24lambda_u2414).client;
                if (dockerClient == null) {
                    Intrinsics.throwUninitializedPropertyAccessException("client");
                    dockerClient = null;
                }
                $this$removeServer_d1pmJ48_u24lambda_u2417_u24lambda_u2414 = Result.constructor-impl(dockerClient.removeContainerCmd(((DockerBroker)$this$removeServer_d1pmJ48_u24lambda_u2417_u24lambda_u2414).name).exec());
            }
            catch (Throwable bl2) {
                $this$removeServer_d1pmJ48_u24lambda_u2417_u24lambda_u2414 = Result.constructor-impl(ResultKt.createFailure(bl2));
            }
            object2 = $this$removeServer_d1pmJ48_u24lambda_u2417_u24lambda_u2414;
            if (Result.isSuccess-impl(object2)) {
                Void it2 = (Void)object2;
                boolean bl3 = false;
                return Result.constructor-impl(Unit.INSTANCE);
            }
            Throwable throwable = Result.exceptionOrNull-impl(object2);
            if (throwable != null) {
                Throwable throwable2;
                Throwable exception = throwable2 = throwable;
                boolean bl4 = false;
                if (exception instanceof NotFoundException) {
                    return Result.constructor-impl(Unit.INSTANCE);
                }
                return Result.constructor-impl(ResultKt.createFailure(exception));
            }
        }
        Throwable throwable = Result.exceptionOrNull-impl(object);
        if (throwable != null) {
            Throwable throwable3;
            Throwable it = throwable3 = throwable;
            boolean bl = false;
            return Result.constructor-impl(ResultKt.createFailure(it));
        }
        return object;
    }

    @Override
    @NotNull
    public Object address-d1pmJ48() {
        Object object;
        DockerServerConfig dockerServerConfig = this.dockerConfig;
        if (dockerServerConfig == null) {
            Intrinsics.throwUninitializedPropertyAccessException("dockerConfig");
            dockerServerConfig = null;
        }
        String string = dockerServerConfig.getAddress();
        if (string != null) {
            Object object2;
            String address = string;
            boolean bl = false;
            String[] stringArray = new String[]{":"};
            List list = StringsKt.split$default((CharSequence)address, stringArray, false, 2, 2, null);
            String host = (String)list.get(0);
            String portStr = (String)list.get(1);
            try {
                object2 = Result.constructor-impl(InetSocketAddress.createUnresolved(host, Integer.parseInt(portStr)));
            }
            catch (NumberFormatException e) {
                object2 = Result.constructor-impl(ResultKt.createFailure(new IllegalArgumentException("Invalid port number: " + portStr, e)));
            }
            object = object2;
        } else {
            object = Result.constructor-impl(ResultKt.createFailure(new IllegalArgumentException("Server address is not set")));
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Object reconcile-IoAF18A(@NotNull ServerConfig config) {
        Object response;
        block25: {
            Throwable throwable;
            Object object;
            block22: {
                boolean volumesChanged;
                Collection collection;
                Iterable $this$mapTo$iv$iv;
                List list;
                Object object2;
                List list2;
                Object[] binding;
                Map.Entry it;
                Collection destination$iv$iv;
                Object $this$map$iv;
                Object liveEnv;
                Object object3;
                Set currentEnv;
                Iterator<Object> it2;
                Collection collection2;
                boolean pullPolicyChanged;
                boolean imageChanged;
                boolean tlsConfigChanged;
                boolean hostChanged;
                DockerServerConfig dockerConfig;
                InspectContainerResponse inspection;
                block24: {
                    Set set;
                    block23: {
                        void $this$mapTo$iv$iv2;
                        Object $this$reconcile_IoAF18A_u24lambda_u2420;
                        Intrinsics.checkNotNullParameter(config, "config");
                        if (!Intrinsics.areEqual(config.getType(), "docker")) {
                            return Result.constructor-impl(ResultKt.createFailure(new IllegalArgumentException("Invalid configuration type: " + config.getType())));
                        }
                        response = null;
                        response = Result.constructor-impl(null);
                        object = this;
                        try {
                            $this$reconcile_IoAF18A_u24lambda_u2420 = object;
                            boolean bl = false;
                            DockerClient dockerClient = ((DockerBroker)$this$reconcile_IoAF18A_u24lambda_u2420).client;
                            if (dockerClient == null) {
                                Intrinsics.throwUninitializedPropertyAccessException("client");
                                dockerClient = null;
                            }
                            $this$reconcile_IoAF18A_u24lambda_u2420 = Result.constructor-impl(dockerClient.inspectContainerCmd(((DockerBroker)$this$reconcile_IoAF18A_u24lambda_u2420).name).exec());
                        }
                        catch (Throwable bl) {
                            $this$reconcile_IoAF18A_u24lambda_u2420 = Result.constructor-impl(ResultKt.createFailure(bl));
                        }
                        object = $this$reconcile_IoAF18A_u24lambda_u2420;
                        if (!Result.isSuccess-impl(object)) break block22;
                        inspection = (InspectContainerResponse)object;
                        boolean bl = false;
                        Object object4 = config.getConfig();
                        DockerServerConfig dockerServerConfig = dockerConfig = object4 instanceof DockerServerConfig ? (DockerServerConfig)object4 : null;
                        String string = dockerServerConfig != null ? dockerServerConfig.getHostPath() : null;
                        String string2 = this.dockerHost;
                        if (string2 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException("dockerHost");
                            string2 = null;
                        }
                        hostChanged = !Intrinsics.areEqual(string, string2);
                        DockerServerConfig dockerServerConfig2 = dockerConfig;
                        DockerTlsConfig dockerTlsConfig = dockerServerConfig2 != null ? dockerServerConfig2.getTlsConfig() : null;
                        DockerServerConfig dockerServerConfig3 = this.dockerConfig;
                        if (dockerServerConfig3 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException("dockerConfig");
                            dockerServerConfig3 = null;
                        }
                        tlsConfigChanged = !Intrinsics.areEqual(dockerTlsConfig, dockerServerConfig3.getTlsConfig());
                        DockerServerConfig dockerServerConfig4 = dockerConfig;
                        imageChanged = !Intrinsics.areEqual(inspection.getConfig().getImage(), dockerServerConfig4 != null ? dockerServerConfig4.getImage() : null);
                        DockerServerConfig dockerServerConfig5 = this.dockerConfig;
                        if (dockerServerConfig5 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException("dockerConfig");
                            dockerServerConfig5 = null;
                        }
                        DockerServerConfig dockerServerConfig6 = dockerConfig;
                        pullPolicyChanged = dockerServerConfig5.getImagePullPolicy() != (dockerServerConfig6 != null ? dockerServerConfig6.getImagePullPolicy() : null);
                        set = dockerConfig;
                        if (set == null || (set = ((DockerServerConfig)((Object)set)).getEnv()) == null) break block23;
                        Set $this$map$iv2 = set;
                        boolean $i$f$map = false;
                        Set set2 = $this$map$iv2;
                        Collection destination$iv$iv2 = new ArrayList($this$map$iv2.size());
                        boolean $i$f$mapTo = false;
                        Iterator iterator2 = $this$mapTo$iv$iv2.entrySet().iterator();
                        while (iterator2.hasNext()) {
                            Map.Entry item$iv$iv;
                            Map.Entry entry = item$iv$iv = iterator2.next();
                            collection2 = destination$iv$iv2;
                            boolean bl2 = false;
                            collection2.add(it2.getKey() + "=" + it2.getValue());
                        }
                        set = CollectionsKt.toSet((List)destination$iv$iv2);
                        if (set != null) break block24;
                    }
                    set = currentEnv = SetsKt.emptySet();
                }
                if ((object3 = inspection.getConfig().getEnv()) == null || (object3 = ArraysKt.toSet(object3)) == null) {
                    object3 = SetsKt.emptySet();
                }
                boolean envChanged = !(liveEnv = object3).containsAll(currentEnv);
                Object object5 = dockerConfig;
                if (object5 != null && (object5 = ((DockerServerConfig)object5).getPortBindings()) != null) {
                    void $this$mapTo$iv$iv3;
                    $this$map$iv = (Iterable)object5;
                    boolean $i$f$map = false;
                    Iterable $i$f$mapTo = $this$map$iv;
                    destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                    boolean $i$f$mapTo2 = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv3) {
                        String string = (String)item$iv$iv;
                        collection2 = destination$iv$iv;
                        boolean bl = false;
                        binding = PortBinding.parse((String)((Object)it));
                        collection2.add(new Pair<String, String>(binding.getBinding().getHostPortSpec(), String.valueOf(binding.getExposedPort().getPort())));
                    }
                    list2 = (List)destination$iv$iv;
                } else {
                    list2 = null;
                }
                List desiredPortConfig = list2;
                Map<ExposedPort, Ports.Binding[]> map2 = inspection.getHostConfig().getPortBindings().getBindings();
                Intrinsics.checkNotNullExpressionValue(map2, "getBindings(...)");
                $this$map$iv = map2;
                boolean $i$f$map = false;
                Object $this$mapTo$iv$iv3 = $this$map$iv;
                destination$iv$iv = new ArrayList($this$map$iv.size());
                boolean $i$f$mapTo22 = false;
                it2 = $this$mapTo$iv$iv3.entrySet().iterator();
                while (it2.hasNext()) {
                    Iterable $this$mapTo$iv$iv4;
                    Iterable $this$map$iv3;
                    Map.Entry item$iv$iv;
                    it = item$iv$iv = (Map.Entry)it2.next();
                    collection2 = destination$iv$iv;
                    int n = 0;
                    String string = String.valueOf(((ExposedPort)it.getKey()).getPort());
                    Object v = it.getValue();
                    Intrinsics.checkNotNullExpressionValue(v, "<get-value>(...)");
                    binding = (Object[])v;
                    object2 = string;
                    boolean $i$f$map2 = false;
                    list = $this$map$iv3;
                    Collection destination$iv$iv3 = new ArrayList(((void)$this$map$iv3).length);
                    boolean $i$f$mapTo = false;
                    for (String item$iv$iv2 : $this$mapTo$iv$iv4) {
                        void binding2;
                        Ports.Binding binding3 = (Ports.Binding)((Object)item$iv$iv2);
                        Collection collection3 = destination$iv$iv3;
                        boolean bl = false;
                        collection3.add(binding2.getHostPortSpec());
                    }
                    List list3 = (List)destination$iv$iv3;
                    String string3 = object2;
                    Pair<String, List> p = new Pair<String, List>(string3, list3);
                    $this$map$iv3 = p.getSecond();
                    $i$f$map2 = false;
                    $this$mapTo$iv$iv4 = $this$map$iv3;
                    destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv3, 10));
                    $i$f$mapTo = false;
                    for (Object item$iv$iv3 : $this$mapTo$iv$iv4) {
                        void value;
                        String item$iv$iv2;
                        item$iv$iv2 = (String)item$iv$iv3;
                        Collection collection4 = destination$iv$iv3;
                        boolean bl = false;
                        collection4.add(TuplesKt.to(value, p.getFirst()));
                    }
                    collection2.add((List)destination$iv$iv3);
                }
                List livePortConfig = CollectionsKt.flatten((List)destination$iv$iv);
                List list4 = desiredPortConfig;
                boolean portsChanged = !livePortConfig.containsAll(list4 != null ? (Collection)list4 : (Collection)CollectionsKt.emptyList());
                Bind[] bindArray = inspection.getHostConfig().getBinds();
                Intrinsics.checkNotNullExpressionValue(bindArray, "getBinds(...)");
                Object[] $this$map$iv4 = bindArray;
                boolean $i$f$map3 = false;
                Object[] $i$f$mapTo22 = $this$map$iv4;
                Collection destination$iv$iv4 = new ArrayList($this$map$iv4.length);
                boolean $i$f$mapTo3 = false;
                for (void item$iv$iv : $this$mapTo$iv$iv) {
                    void it3;
                    object2 = (Bind)item$iv$iv;
                    collection2 = destination$iv$iv4;
                    boolean bl = false;
                    collection2.add(new Pair<String, String>(it3.getPath(), it3.getVolume().getPath()));
                }
                Collection collection5 = (List)destination$iv$iv4;
                Object object6 = dockerConfig;
                if (object6 != null && (object6 = ((DockerServerConfig)object6).getVolumes()) != null) {
                    void $this$mapTo$iv$iv5;
                    void $this$map$iv5;
                    $this$mapTo$iv$iv = (Iterable)object6;
                    collection2 = collection5;
                    boolean $i$f$map4 = false;
                    void $i$f$mapTo3 = $this$map$iv5;
                    Collection destination$iv$iv5 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv5, 10));
                    boolean $i$f$mapTo4 = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv5) {
                        void it4;
                        String bl = (String)item$iv$iv;
                        Collection collection6 = destination$iv$iv5;
                        boolean bl3 = false;
                        String[] $i$f$map5 = new String[]{":"};
                        list = StringsKt.split$default((CharSequence)it4, $i$f$map5, false, 0, 6, null);
                        String hostPath = (String)list.get(0);
                        String mount = (String)list.get(1);
                        collection6.add(new Pair<String, String>(hostPath, mount));
                    }
                    collection5 = collection2;
                    collection = (List)destination$iv$iv5;
                } else {
                    collection = CollectionsKt.emptyList();
                }
                boolean bl = volumesChanged = !collection5.containsAll(collection);
                response = imageChanged || pullPolicyChanged || portsChanged || volumesChanged || hostChanged || tlsConfigChanged || envChanged ? Result.constructor-impl(() -> DockerBroker.reconcile_IoAF18A$lambda$30$lambda$28(this, config, inspection)) : Result.constructor-impl(() -> DockerBroker.reconcile_IoAF18A$lambda$30$lambda$29(this, config));
            }
            Throwable throwable2 = Result.exceptionOrNull-impl(object);
            if (throwable2 == null) break block25;
            Throwable it = throwable = throwable2;
            boolean bl = false;
            response = Result.constructor-impl(null);
        }
        return response;
    }

    private static final SSLContext configureDockerClient$lambda$0(DockerServerConfig $dockerConfig, DockerBroker this$0) {
        return new SSLHelper($dockerConfig, this$0.logger).getSSLContext();
    }

    private static final void reconcile_IoAF18A$lambda$30$lambda$28(DockerBroker this$0, ServerConfig $config, InspectContainerResponse $inspection) {
        this$0.removeServer-d1pmJ48();
        this$0.configureDockerClient($config);
        this$0.stopTimeout = $config.getLifecycleSettings().getTimeouts().getShutdown();
        this$0.startupTimeout = $config.getLifecycleSettings().getTimeouts().getStartup();
        this$0.createContainer-IoAF18A(Intrinsics.areEqual($inspection.getState().getStatus(), "running"));
    }

    private static final void reconcile_IoAF18A$lambda$30$lambda$29(DockerBroker this$0, ServerConfig $config) {
        Object object = $config.getConfig();
        Intrinsics.checkNotNull(object, "null cannot be cast to non-null type club.arson.impulse.dockerbroker.DockerServerConfig");
        this$0.dockerConfig = (DockerServerConfig)object;
    }

    public static final /* synthetic */ DockerServerConfig access$getDockerConfig$p(DockerBroker $this) {
        return $this.dockerConfig;
    }

    public static final /* synthetic */ Logger access$getLogger$p(DockerBroker $this) {
        return $this.logger;
    }

    public static final /* synthetic */ Object access$pullImage-IoAF18A(DockerBroker $this, String image) {
        return $this.pullImage-IoAF18A(image);
    }

    public static final /* synthetic */ Object access$pullImageIfNotPresent-IoAF18A(DockerBroker $this, String taggedImage) {
        return $this.pullImageIfNotPresent-IoAF18A(taggedImage);
    }

    public static final /* synthetic */ Deferred access$getPullImageTask$p(DockerBroker $this) {
        return $this.pullImageTask;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0013\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lclub/arson/impulse/dockerbroker/DockerBroker$ProgressCallback;", "Lcom/github/dockerjava/api/command/PullImageResultCallback;", "logger", "Lorg/slf4j/Logger;", "<init>", "(Lorg/slf4j/Logger;)V", "onNext", "", "item", "Lcom/github/dockerjava/api/model/PullResponseItem;", "docker-broker"})
    public static final class ProgressCallback
    extends PullImageResultCallback {
        @Nullable
        private final Logger logger;

        public ProgressCallback(@Nullable Logger logger) {
            this.logger = logger;
        }

        public /* synthetic */ ProgressCallback(Logger logger, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                logger = null;
            }
            this(logger);
        }

        @Override
        public void onNext(@Nullable PullResponseItem item) {
            block0: {
                DockerObject dockerObject;
                DockerObject dockerObject2;
                super.onNext(item);
                Logger logger = this.logger;
                if (logger == null) break block0;
                PullResponseItem pullResponseItem = item;
                logger.debug("Docker Broker: Pulling image: " + (pullResponseItem != null ? pullResponseItem.getStatus() : null) + " " + ((dockerObject2 = item) != null && (dockerObject2 = ((ResponseItem)dockerObject2).getProgressDetail()) != null ? ((ResponseItem.ProgressDetail)dockerObject2).getCurrent() : null) + "/" + ((dockerObject = item) != null && (dockerObject = ((ResponseItem)dockerObject).getProgressDetail()) != null ? ((ResponseItem.ProgressDetail)dockerObject).getTotal() : null));
            }
        }

        public ProgressCallback() {
            this(null, 1, null);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0013\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lclub/arson/impulse/dockerbroker/DockerBroker$SSLHelper;", "", "dockerConfig", "Lclub/arson/impulse/dockerbroker/DockerServerConfig;", "logger", "Lorg/slf4j/Logger;", "<init>", "(Lclub/arson/impulse/dockerbroker/DockerServerConfig;Lorg/slf4j/Logger;)V", "getKeyStore", "Lkotlin/Result;", "Ljava/security/KeyStore;", "getKeyStore-d1pmJ48", "()Ljava/lang/Object;", "getSSLContext", "Ljavax/net/ssl/SSLContext;", "docker-broker"})
    @SourceDebugExtension(value={"SMAP\nDockerBroker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DockerBroker.kt\nclub/arson/impulse/dockerbroker/DockerBroker$SSLHelper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,469:1\n1#2:470\n*E\n"})
    public static final class SSLHelper {
        @NotNull
        private final DockerServerConfig dockerConfig;
        @Nullable
        private final Logger logger;

        public SSLHelper(@NotNull DockerServerConfig dockerConfig, @Nullable Logger logger) {
            Intrinsics.checkNotNullParameter(dockerConfig, "dockerConfig");
            this.dockerConfig = dockerConfig;
            this.logger = logger;
        }

        public /* synthetic */ SSLHelper(DockerServerConfig dockerServerConfig, Logger logger, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                logger = null;
            }
            this(dockerServerConfig, logger);
        }

        @NotNull
        public final Object getKeyStore-d1pmJ48() {
            Object object;
            Object $this$getKeyStore_d1pmJ48_u24lambda_u241;
            Object object2;
            KeyStore ks;
            block24: {
                block23: {
                    ks = KeyStore.getInstance("PKCS12");
                    object2 = this.dockerConfig.getTlsConfig().getKeystorePassword();
                    if (object2 == null) break block23;
                    char[] cArray = ((String)object2).toCharArray();
                    Intrinsics.checkNotNullExpressionValue(cArray, "toCharArray(...)");
                    object2 = cArray;
                    if (cArray != null) break block24;
                }
                object2 = new char[0];
            }
            Object keystorePw = object2;
            Object object3 = this;
            try {
                boolean bl;
                Path path;
                Path path2;
                $this$getKeyStore_d1pmJ48_u24lambda_u241 = object3;
                boolean bl2 = false;
                String string = ((SSLHelper)$this$getKeyStore_d1pmJ48_u24lambda_u241).dockerConfig.getTlsConfig().getKeystorePath();
                if (string != null) {
                    String it = string;
                    boolean bl3 = false;
                    Path path3 = Paths.get(it, new String[0]);
                    path2 = path3;
                    Intrinsics.checkNotNullExpressionValue(path3, "get(...)");
                } else {
                    path2 = null;
                }
                Path path4 = path = path2;
                if (path4 != null) {
                    LinkOption[] linkOptionArray = new LinkOption[]{};
                    bl = Files.exists(path4, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
                } else {
                    bl = false;
                }
                if (!bl) {
                    throw new FileNotFoundException("Could not find keystore at path: " + path);
                }
                OpenOption[] openOptionArray = new OpenOption[]{};
                InputStream inputStream2 = Files.newInputStream(path, Arrays.copyOf(openOptionArray, openOptionArray.length));
                Intrinsics.checkNotNullExpressionValue(inputStream2, "newInputStream(...)");
                ks.load(inputStream2, (char[])keystorePw);
                $this$getKeyStore_d1pmJ48_u24lambda_u241 = Result.constructor-impl(Unit.INSTANCE);
            }
            catch (Throwable bl2) {
                $this$getKeyStore_d1pmJ48_u24lambda_u241 = Result.constructor-impl(ResultKt.createFailure(bl2));
            }
            object3 = $this$getKeyStore_d1pmJ48_u24lambda_u241;
            Throwable throwable = Result.exceptionOrNull-impl(object3);
            if (throwable == null) {
                Unit it = (Unit)object3;
                boolean bl = false;
                object = Result.constructor-impl(ks);
            } else {
                Throwable exception = throwable;
                boolean bl = false;
                Throwable throwable2 = exception;
                if (throwable2 instanceof FileNotFoundException) {
                    Logger logger = this.logger;
                    if (logger != null) {
                        logger.error("Keystore file not found: " + exception.getMessage());
                    }
                } else if (throwable2 instanceof KeyStoreException) {
                    Logger logger = this.logger;
                    if (logger != null) {
                        logger.error("Failed to load keystore, make sure it is PKCS12: " + exception.getMessage());
                    }
                } else if (throwable2 instanceof UnrecoverableKeyException) {
                    Logger logger = this.logger;
                    if (logger != null) {
                        logger.error("Failed to load keystore, make sure the password is correct: " + exception.getMessage());
                    }
                } else {
                    Logger logger = this.logger;
                    if (logger != null) {
                        logger.error("Failed to load keystore with unknown error: " + exception.getMessage());
                    }
                }
                object = Result.constructor-impl(ResultKt.createFailure(exception));
            }
            return object;
        }

        @NotNull
        public final SSLContext getSSLContext() {
            Object object;
            KeyStore keyStore;
            block7: {
                DockerTlsConfig tlsConfig;
                block6: {
                    tlsConfig = this.dockerConfig.getTlsConfig();
                    if (!tlsConfig.getEnabled()) {
                        SSLContext sSLContext = SSLContexts.createDefault();
                        Intrinsics.checkNotNullExpressionValue(sSLContext, "createDefault(...)");
                        return sSLContext;
                    }
                    Object object2 = this.getKeyStore-d1pmJ48();
                    ResultKt.throwOnFailure(object2);
                    keyStore = (KeyStore)object2;
                    object = tlsConfig.getClientKeyPassword();
                    if (object == null) break block6;
                    char[] cArray = ((String)object).toCharArray();
                    Intrinsics.checkNotNullExpressionValue(cArray, "toCharArray(...)");
                    object = cArray;
                    if (cArray != null) break block7;
                }
                String string = tlsConfig.getKeystorePassword();
                if (string != null) {
                    char[] cArray = string.toCharArray();
                    object = cArray;
                    Intrinsics.checkNotNullExpressionValue(cArray, "toCharArray(...)");
                } else {
                    object = new char[0];
                }
            }
            Object keyPass = object;
            SSLContext sSLContext = SSLContexts.custom().loadKeyMaterial(keyStore, (char[])keyPass).loadTrustMaterial(keyStore, new TrustSelfSignedStrategy()).build();
            Intrinsics.checkNotNullExpressionValue(sSLContext, "build(...)");
            return sSLContext;
        }
    }
}

