/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.api.command;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.dockerjava.api.command.GraphDriver;
import com.github.dockerjava.api.command.HealthState;
import com.github.dockerjava.api.model.ContainerConfig;
import com.github.dockerjava.api.model.DockerObject;
import com.github.dockerjava.api.model.HostConfig;
import com.github.dockerjava.api.model.NetworkSettings;
import com.github.dockerjava.api.model.Volume;
import com.github.dockerjava.api.model.VolumeBind;
import com.github.dockerjava.api.model.VolumeBinds;
import com.github.dockerjava.api.model.VolumeRW;
import com.github.dockerjava.api.model.VolumesRW;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;

public class InspectContainerResponse
extends DockerObject {
    @JsonProperty(value="Args")
    private String[] args;
    @JsonProperty(value="Config")
    private ContainerConfig config;
    @JsonProperty(value="Created")
    private String created;
    @JsonProperty(value="Driver")
    private String driver;
    @JsonProperty(value="ExecDriver")
    private String execDriver;
    @JsonProperty(value="HostConfig")
    private HostConfig hostConfig;
    @JsonProperty(value="HostnamePath")
    private String hostnamePath;
    @JsonProperty(value="HostsPath")
    private String hostsPath;
    @JsonProperty(value="LogPath")
    private String logPath;
    @JsonProperty(value="Id")
    private String id;
    @JsonProperty(value="SizeRootFs")
    private Integer sizeRootFs;
    @JsonProperty(value="SizeRw")
    private Integer sizeRw;
    @JsonProperty(value="Image")
    private String imageId;
    @JsonProperty(value="MountLabel")
    private String mountLabel;
    @JsonProperty(value="Name")
    private String name;
    @JsonProperty(value="RestartCount")
    private Integer restartCount;
    @JsonProperty(value="NetworkSettings")
    private NetworkSettings networkSettings;
    @JsonProperty(value="Path")
    private String path;
    @JsonProperty(value="ProcessLabel")
    private String processLabel;
    @JsonProperty(value="ResolvConfPath")
    private String resolvConfPath;
    @JsonProperty(value="ExecIDs")
    private List<String> execIds;
    @JsonProperty(value="State")
    private ContainerState state;
    @JsonProperty(value="Volumes")
    private VolumeBinds volumes;
    @JsonProperty(value="VolumesRW")
    private VolumesRW volumesRW;
    @JsonProperty(value="Node")
    private Node node;
    @JsonProperty(value="Mounts")
    private List<Mount> mounts;
    @JsonProperty(value="GraphDriver")
    private GraphDriver graphDriver;
    @JsonProperty(value="Platform")
    private String platform;

    public String getId() {
        return this.id;
    }

    public Integer getSizeRootFs() {
        return this.sizeRootFs;
    }

    public Integer getSizeRw() {
        return this.sizeRw;
    }

    public String getCreated() {
        return this.created;
    }

    public String getPath() {
        return this.path;
    }

    public String getProcessLabel() {
        return this.processLabel;
    }

    public String[] getArgs() {
        return this.args;
    }

    public ContainerConfig getConfig() {
        return this.config;
    }

    public ContainerState getState() {
        return this.state;
    }

    public String getImageId() {
        return this.imageId;
    }

    public NetworkSettings getNetworkSettings() {
        return this.networkSettings;
    }

    public String getResolvConfPath() {
        return this.resolvConfPath;
    }

    @JsonIgnore
    public VolumeBind[] getVolumes() {
        return this.volumes == null ? null : this.volumes.getBinds();
    }

    @JsonIgnore
    @Deprecated
    @CheckForNull
    public VolumeRW[] getVolumesRW() {
        return this.volumesRW == null ? null : this.volumesRW.getVolumesRW();
    }

    public String getHostnamePath() {
        return this.hostnamePath;
    }

    public String getHostsPath() {
        return this.hostsPath;
    }

    @CheckForNull
    public String getLogPath() {
        return this.logPath;
    }

    public String getName() {
        return this.name;
    }

    public Integer getRestartCount() {
        return this.restartCount;
    }

    public String getDriver() {
        return this.driver;
    }

    public HostConfig getHostConfig() {
        return this.hostConfig;
    }

    public String getExecDriver() {
        return this.execDriver;
    }

    public String getMountLabel() {
        return this.mountLabel;
    }

    @CheckForNull
    public List<Mount> getMounts() {
        return this.mounts;
    }

    public List<String> getExecIds() {
        return this.execIds;
    }

    public Node getNode() {
        return this.node;
    }

    @CheckForNull
    public GraphDriver getGraphDriver() {
        return this.graphDriver;
    }

    @CheckForNull
    public String getPlatform() {
        return this.platform;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InspectContainerResponse)) {
            return false;
        }
        InspectContainerResponse other = (InspectContainerResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$sizeRootFs = this.getSizeRootFs();
        Integer other$sizeRootFs = other.getSizeRootFs();
        if (this$sizeRootFs == null ? other$sizeRootFs != null : !((Object)this$sizeRootFs).equals(other$sizeRootFs)) {
            return false;
        }
        Integer this$sizeRw = this.getSizeRw();
        Integer other$sizeRw = other.getSizeRw();
        if (this$sizeRw == null ? other$sizeRw != null : !((Object)this$sizeRw).equals(other$sizeRw)) {
            return false;
        }
        Integer this$restartCount = this.getRestartCount();
        Integer other$restartCount = other.getRestartCount();
        if (this$restartCount == null ? other$restartCount != null : !((Object)this$restartCount).equals(other$restartCount)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getArgs(), other.getArgs())) {
            return false;
        }
        ContainerConfig this$config = this.getConfig();
        ContainerConfig other$config = other.getConfig();
        if (this$config == null ? other$config != null : !((Object)this$config).equals(other$config)) {
            return false;
        }
        String this$created = this.getCreated();
        String other$created = other.getCreated();
        if (this$created == null ? other$created != null : !this$created.equals(other$created)) {
            return false;
        }
        String this$driver = this.getDriver();
        String other$driver = other.getDriver();
        if (this$driver == null ? other$driver != null : !this$driver.equals(other$driver)) {
            return false;
        }
        String this$execDriver = this.getExecDriver();
        String other$execDriver = other.getExecDriver();
        if (this$execDriver == null ? other$execDriver != null : !this$execDriver.equals(other$execDriver)) {
            return false;
        }
        HostConfig this$hostConfig = this.getHostConfig();
        HostConfig other$hostConfig = other.getHostConfig();
        if (this$hostConfig == null ? other$hostConfig != null : !((Object)this$hostConfig).equals(other$hostConfig)) {
            return false;
        }
        String this$hostnamePath = this.getHostnamePath();
        String other$hostnamePath = other.getHostnamePath();
        if (this$hostnamePath == null ? other$hostnamePath != null : !this$hostnamePath.equals(other$hostnamePath)) {
            return false;
        }
        String this$hostsPath = this.getHostsPath();
        String other$hostsPath = other.getHostsPath();
        if (this$hostsPath == null ? other$hostsPath != null : !this$hostsPath.equals(other$hostsPath)) {
            return false;
        }
        String this$logPath = this.getLogPath();
        String other$logPath = other.getLogPath();
        if (this$logPath == null ? other$logPath != null : !this$logPath.equals(other$logPath)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$imageId = this.getImageId();
        String other$imageId = other.getImageId();
        if (this$imageId == null ? other$imageId != null : !this$imageId.equals(other$imageId)) {
            return false;
        }
        String this$mountLabel = this.getMountLabel();
        String other$mountLabel = other.getMountLabel();
        if (this$mountLabel == null ? other$mountLabel != null : !this$mountLabel.equals(other$mountLabel)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        NetworkSettings this$networkSettings = this.getNetworkSettings();
        NetworkSettings other$networkSettings = other.getNetworkSettings();
        if (this$networkSettings == null ? other$networkSettings != null : !((Object)this$networkSettings).equals(other$networkSettings)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        String this$processLabel = this.getProcessLabel();
        String other$processLabel = other.getProcessLabel();
        if (this$processLabel == null ? other$processLabel != null : !this$processLabel.equals(other$processLabel)) {
            return false;
        }
        String this$resolvConfPath = this.getResolvConfPath();
        String other$resolvConfPath = other.getResolvConfPath();
        if (this$resolvConfPath == null ? other$resolvConfPath != null : !this$resolvConfPath.equals(other$resolvConfPath)) {
            return false;
        }
        List<String> this$execIds = this.getExecIds();
        List<String> other$execIds = other.getExecIds();
        if (this$execIds == null ? other$execIds != null : !((Object)this$execIds).equals(other$execIds)) {
            return false;
        }
        ContainerState this$state = this.getState();
        ContainerState other$state = other.getState();
        if (this$state == null ? other$state != null : !((Object)this$state).equals(other$state)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getVolumes(), other.getVolumes())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getVolumesRW(), other.getVolumesRW())) {
            return false;
        }
        Node this$node = this.getNode();
        Node other$node = other.getNode();
        if (this$node == null ? other$node != null : !((Object)this$node).equals(other$node)) {
            return false;
        }
        List<Mount> this$mounts = this.getMounts();
        List<Mount> other$mounts = other.getMounts();
        if (this$mounts == null ? other$mounts != null : !((Object)this$mounts).equals(other$mounts)) {
            return false;
        }
        GraphDriver this$graphDriver = this.getGraphDriver();
        GraphDriver other$graphDriver = other.getGraphDriver();
        if (this$graphDriver == null ? other$graphDriver != null : !((Object)this$graphDriver).equals(other$graphDriver)) {
            return false;
        }
        String this$platform = this.getPlatform();
        String other$platform = other.getPlatform();
        return !(this$platform == null ? other$platform != null : !this$platform.equals(other$platform));
    }

    protected boolean canEqual(Object other) {
        return other instanceof InspectContainerResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $sizeRootFs = this.getSizeRootFs();
        result = result * 59 + ($sizeRootFs == null ? 43 : ((Object)$sizeRootFs).hashCode());
        Integer $sizeRw = this.getSizeRw();
        result = result * 59 + ($sizeRw == null ? 43 : ((Object)$sizeRw).hashCode());
        Integer $restartCount = this.getRestartCount();
        result = result * 59 + ($restartCount == null ? 43 : ((Object)$restartCount).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getArgs());
        ContainerConfig $config = this.getConfig();
        result = result * 59 + ($config == null ? 43 : ((Object)$config).hashCode());
        String $created = this.getCreated();
        result = result * 59 + ($created == null ? 43 : $created.hashCode());
        String $driver = this.getDriver();
        result = result * 59 + ($driver == null ? 43 : $driver.hashCode());
        String $execDriver = this.getExecDriver();
        result = result * 59 + ($execDriver == null ? 43 : $execDriver.hashCode());
        HostConfig $hostConfig = this.getHostConfig();
        result = result * 59 + ($hostConfig == null ? 43 : ((Object)$hostConfig).hashCode());
        String $hostnamePath = this.getHostnamePath();
        result = result * 59 + ($hostnamePath == null ? 43 : $hostnamePath.hashCode());
        String $hostsPath = this.getHostsPath();
        result = result * 59 + ($hostsPath == null ? 43 : $hostsPath.hashCode());
        String $logPath = this.getLogPath();
        result = result * 59 + ($logPath == null ? 43 : $logPath.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $imageId = this.getImageId();
        result = result * 59 + ($imageId == null ? 43 : $imageId.hashCode());
        String $mountLabel = this.getMountLabel();
        result = result * 59 + ($mountLabel == null ? 43 : $mountLabel.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        NetworkSettings $networkSettings = this.getNetworkSettings();
        result = result * 59 + ($networkSettings == null ? 43 : ((Object)$networkSettings).hashCode());
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        String $processLabel = this.getProcessLabel();
        result = result * 59 + ($processLabel == null ? 43 : $processLabel.hashCode());
        String $resolvConfPath = this.getResolvConfPath();
        result = result * 59 + ($resolvConfPath == null ? 43 : $resolvConfPath.hashCode());
        List<String> $execIds = this.getExecIds();
        result = result * 59 + ($execIds == null ? 43 : ((Object)$execIds).hashCode());
        ContainerState $state = this.getState();
        result = result * 59 + ($state == null ? 43 : ((Object)$state).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getVolumes());
        result = result * 59 + Arrays.deepHashCode(this.getVolumesRW());
        Node $node = this.getNode();
        result = result * 59 + ($node == null ? 43 : ((Object)$node).hashCode());
        List<Mount> $mounts = this.getMounts();
        result = result * 59 + ($mounts == null ? 43 : ((Object)$mounts).hashCode());
        GraphDriver $graphDriver = this.getGraphDriver();
        result = result * 59 + ($graphDriver == null ? 43 : ((Object)$graphDriver).hashCode());
        String $platform = this.getPlatform();
        result = result * 59 + ($platform == null ? 43 : $platform.hashCode());
        return result;
    }

    public String toString() {
        return "InspectContainerResponse(args=" + Arrays.deepToString(this.getArgs()) + ", config=" + this.getConfig() + ", created=" + this.getCreated() + ", driver=" + this.getDriver() + ", execDriver=" + this.getExecDriver() + ", hostConfig=" + this.getHostConfig() + ", hostnamePath=" + this.getHostnamePath() + ", hostsPath=" + this.getHostsPath() + ", logPath=" + this.getLogPath() + ", id=" + this.getId() + ", sizeRootFs=" + this.getSizeRootFs() + ", sizeRw=" + this.getSizeRw() + ", imageId=" + this.getImageId() + ", mountLabel=" + this.getMountLabel() + ", name=" + this.getName() + ", restartCount=" + this.getRestartCount() + ", networkSettings=" + this.getNetworkSettings() + ", path=" + this.getPath() + ", processLabel=" + this.getProcessLabel() + ", resolvConfPath=" + this.getResolvConfPath() + ", execIds=" + this.getExecIds() + ", state=" + this.getState() + ", volumes=" + Arrays.deepToString(this.getVolumes()) + ", volumesRW=" + Arrays.deepToString(this.getVolumesRW()) + ", node=" + this.getNode() + ", mounts=" + this.getMounts() + ", graphDriver=" + this.getGraphDriver() + ", platform=" + this.getPlatform() + ")";
    }

    public class Node
    extends DockerObject {
        @JsonProperty(value="ID")
        private String id;
        @JsonProperty(value="IP")
        private String ip;
        @JsonProperty(value="Addr")
        private String addr;
        @JsonProperty(value="Name")
        private String name;
        @JsonProperty(value="Cpus")
        private Integer cpus;
        @JsonProperty(value="Memory")
        private Long memory;
        @JsonProperty(value="Labels")
        private Map<String, String> labels;

        public String getId() {
            return this.id;
        }

        public String getIp() {
            return this.ip;
        }

        public String getAddr() {
            return this.addr;
        }

        public String getName() {
            return this.name;
        }

        public Integer getCpus() {
            return this.cpus;
        }

        public Long getMemory() {
            return this.memory;
        }

        public Map<String, String> getLabels() {
            return this.labels;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Node)) {
                return false;
            }
            Node other = (Node)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$cpus = this.getCpus();
            Integer other$cpus = other.getCpus();
            if (this$cpus == null ? other$cpus != null : !((Object)this$cpus).equals(other$cpus)) {
                return false;
            }
            Long this$memory = this.getMemory();
            Long other$memory = other.getMemory();
            if (this$memory == null ? other$memory != null : !((Object)this$memory).equals(other$memory)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            String this$ip = this.getIp();
            String other$ip = other.getIp();
            if (this$ip == null ? other$ip != null : !this$ip.equals(other$ip)) {
                return false;
            }
            String this$addr = this.getAddr();
            String other$addr = other.getAddr();
            if (this$addr == null ? other$addr != null : !this$addr.equals(other$addr)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            Map<String, String> this$labels = this.getLabels();
            Map<String, String> other$labels = other.getLabels();
            return !(this$labels == null ? other$labels != null : !((Object)this$labels).equals(other$labels));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Node;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $cpus = this.getCpus();
            result = result * 59 + ($cpus == null ? 43 : ((Object)$cpus).hashCode());
            Long $memory = this.getMemory();
            result = result * 59 + ($memory == null ? 43 : ((Object)$memory).hashCode());
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            String $ip = this.getIp();
            result = result * 59 + ($ip == null ? 43 : $ip.hashCode());
            String $addr = this.getAddr();
            result = result * 59 + ($addr == null ? 43 : $addr.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            Map<String, String> $labels = this.getLabels();
            result = result * 59 + ($labels == null ? 43 : ((Object)$labels).hashCode());
            return result;
        }

        public String toString() {
            return "InspectContainerResponse.Node(id=" + this.getId() + ", ip=" + this.getIp() + ", addr=" + this.getAddr() + ", name=" + this.getName() + ", cpus=" + this.getCpus() + ", memory=" + this.getMemory() + ", labels=" + this.getLabels() + ")";
        }
    }

    public static class Mount
    extends DockerObject {
        @CheckForNull
        @JsonProperty(value="Name")
        private String name;
        @CheckForNull
        @JsonProperty(value="Source")
        private String source;
        @CheckForNull
        @JsonProperty(value="Destination")
        private Volume destination;
        @CheckForNull
        @JsonProperty(value="Driver")
        private String driver;
        @CheckForNull
        @JsonProperty(value="Mode")
        private String mode;
        @CheckForNull
        @JsonProperty(value="RW")
        private Boolean rw;

        @CheckForNull
        public String getName() {
            return this.name;
        }

        @CheckForNull
        public String getSource() {
            return this.source;
        }

        @CheckForNull
        public Volume getDestination() {
            return this.destination;
        }

        @CheckForNull
        public String getDriver() {
            return this.driver;
        }

        @CheckForNull
        public String getMode() {
            return this.mode;
        }

        @CheckForNull
        public Boolean getRW() {
            return this.rw;
        }

        public Mount withDestination(Volume destination) {
            this.destination = destination;
            return this;
        }

        public Mount withDriver(String driver) {
            this.driver = driver;
            return this;
        }

        public Mount withMode(String mode) {
            this.mode = mode;
            return this;
        }

        public Mount withName(String name) {
            this.name = name;
            return this;
        }

        public Mount withRw(Boolean rw) {
            this.rw = rw;
            return this;
        }

        public Mount withSource(String source2) {
            this.source = source2;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Mount)) {
                return false;
            }
            Mount other = (Mount)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$rw = this.getRW();
            Boolean other$rw = other.getRW();
            if (this$rw == null ? other$rw != null : !((Object)this$rw).equals(other$rw)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$source = this.getSource();
            String other$source = other.getSource();
            if (this$source == null ? other$source != null : !this$source.equals(other$source)) {
                return false;
            }
            Volume this$destination = this.getDestination();
            Volume other$destination = other.getDestination();
            if (this$destination == null ? other$destination != null : !((Object)this$destination).equals(other$destination)) {
                return false;
            }
            String this$driver = this.getDriver();
            String other$driver = other.getDriver();
            if (this$driver == null ? other$driver != null : !this$driver.equals(other$driver)) {
                return false;
            }
            String this$mode = this.getMode();
            String other$mode = other.getMode();
            return !(this$mode == null ? other$mode != null : !this$mode.equals(other$mode));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Mount;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $rw = this.getRW();
            result = result * 59 + ($rw == null ? 43 : ((Object)$rw).hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $source = this.getSource();
            result = result * 59 + ($source == null ? 43 : $source.hashCode());
            Volume $destination = this.getDestination();
            result = result * 59 + ($destination == null ? 43 : ((Object)$destination).hashCode());
            String $driver = this.getDriver();
            result = result * 59 + ($driver == null ? 43 : $driver.hashCode());
            String $mode = this.getMode();
            result = result * 59 + ($mode == null ? 43 : $mode.hashCode());
            return result;
        }

        public String toString() {
            return "InspectContainerResponse.Mount(name=" + this.getName() + ", source=" + this.getSource() + ", destination=" + this.getDestination() + ", driver=" + this.getDriver() + ", mode=" + this.getMode() + ", rw=" + this.getRW() + ")";
        }
    }

    public class ContainerState
    extends DockerObject {
        @CheckForNull
        @JsonProperty(value="Status")
        private String status;
        @CheckForNull
        @JsonProperty(value="Running")
        private Boolean running;
        @CheckForNull
        @JsonProperty(value="Paused")
        private Boolean paused;
        @CheckForNull
        @JsonProperty(value="Restarting")
        private Boolean restarting;
        @CheckForNull
        @JsonProperty(value="OOMKilled")
        private Boolean oomKilled;
        @CheckForNull
        @JsonProperty(value="Dead")
        private Boolean dead;
        @CheckForNull
        @JsonProperty(value="Pid")
        private Long pid;
        @CheckForNull
        @JsonProperty(value="ExitCode")
        private Long exitCode;
        @CheckForNull
        @JsonProperty(value="Error")
        private String error;
        @CheckForNull
        @JsonProperty(value="StartedAt")
        private String startedAt;
        @CheckForNull
        @JsonProperty(value="FinishedAt")
        private String finishedAt;
        @JsonProperty(value="Health")
        private HealthState health;

        @CheckForNull
        public String getStatus() {
            return this.status;
        }

        @CheckForNull
        public Boolean getRunning() {
            return this.running;
        }

        @CheckForNull
        public Boolean getPaused() {
            return this.paused;
        }

        @CheckForNull
        public Boolean getRestarting() {
            return this.restarting;
        }

        @CheckForNull
        public Boolean getOOMKilled() {
            return this.oomKilled;
        }

        @CheckForNull
        public Boolean getDead() {
            return this.dead;
        }

        @Deprecated
        @CheckForNull
        public Integer getPid() {
            return this.pid != null ? Integer.valueOf(this.pid.intValue()) : null;
        }

        @CheckForNull
        public Long getPidLong() {
            return this.pid;
        }

        @Deprecated
        @CheckForNull
        public Integer getExitCode() {
            return this.exitCode != null ? Integer.valueOf(this.exitCode.intValue()) : null;
        }

        @CheckForNull
        public Long getExitCodeLong() {
            return this.exitCode;
        }

        @CheckForNull
        public String getError() {
            return this.error;
        }

        @CheckForNull
        public String getStartedAt() {
            return this.startedAt;
        }

        @CheckForNull
        public String getFinishedAt() {
            return this.finishedAt;
        }

        public HealthState getHealth() {
            return this.health;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ContainerState)) {
                return false;
            }
            ContainerState other = (ContainerState)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$running = this.getRunning();
            Boolean other$running = other.getRunning();
            if (this$running == null ? other$running != null : !((Object)this$running).equals(other$running)) {
                return false;
            }
            Boolean this$paused = this.getPaused();
            Boolean other$paused = other.getPaused();
            if (this$paused == null ? other$paused != null : !((Object)this$paused).equals(other$paused)) {
                return false;
            }
            Boolean this$restarting = this.getRestarting();
            Boolean other$restarting = other.getRestarting();
            if (this$restarting == null ? other$restarting != null : !((Object)this$restarting).equals(other$restarting)) {
                return false;
            }
            Boolean this$oomKilled = this.getOOMKilled();
            Boolean other$oomKilled = other.getOOMKilled();
            if (this$oomKilled == null ? other$oomKilled != null : !((Object)this$oomKilled).equals(other$oomKilled)) {
                return false;
            }
            Boolean this$dead = this.getDead();
            Boolean other$dead = other.getDead();
            if (this$dead == null ? other$dead != null : !((Object)this$dead).equals(other$dead)) {
                return false;
            }
            Integer this$pid = this.getPid();
            Integer other$pid = other.getPid();
            if (this$pid == null ? other$pid != null : !((Object)this$pid).equals(other$pid)) {
                return false;
            }
            Integer this$exitCode = this.getExitCode();
            Integer other$exitCode = other.getExitCode();
            if (this$exitCode == null ? other$exitCode != null : !((Object)this$exitCode).equals(other$exitCode)) {
                return false;
            }
            String this$status = this.getStatus();
            String other$status = other.getStatus();
            if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
                return false;
            }
            String this$error = this.getError();
            String other$error = other.getError();
            if (this$error == null ? other$error != null : !this$error.equals(other$error)) {
                return false;
            }
            String this$startedAt = this.getStartedAt();
            String other$startedAt = other.getStartedAt();
            if (this$startedAt == null ? other$startedAt != null : !this$startedAt.equals(other$startedAt)) {
                return false;
            }
            String this$finishedAt = this.getFinishedAt();
            String other$finishedAt = other.getFinishedAt();
            if (this$finishedAt == null ? other$finishedAt != null : !this$finishedAt.equals(other$finishedAt)) {
                return false;
            }
            HealthState this$health = this.getHealth();
            HealthState other$health = other.getHealth();
            return !(this$health == null ? other$health != null : !((Object)this$health).equals(other$health));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ContainerState;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $running = this.getRunning();
            result = result * 59 + ($running == null ? 43 : ((Object)$running).hashCode());
            Boolean $paused = this.getPaused();
            result = result * 59 + ($paused == null ? 43 : ((Object)$paused).hashCode());
            Boolean $restarting = this.getRestarting();
            result = result * 59 + ($restarting == null ? 43 : ((Object)$restarting).hashCode());
            Boolean $oomKilled = this.getOOMKilled();
            result = result * 59 + ($oomKilled == null ? 43 : ((Object)$oomKilled).hashCode());
            Boolean $dead = this.getDead();
            result = result * 59 + ($dead == null ? 43 : ((Object)$dead).hashCode());
            Integer $pid = this.getPid();
            result = result * 59 + ($pid == null ? 43 : ((Object)$pid).hashCode());
            Integer $exitCode = this.getExitCode();
            result = result * 59 + ($exitCode == null ? 43 : ((Object)$exitCode).hashCode());
            String $status = this.getStatus();
            result = result * 59 + ($status == null ? 43 : $status.hashCode());
            String $error = this.getError();
            result = result * 59 + ($error == null ? 43 : $error.hashCode());
            String $startedAt = this.getStartedAt();
            result = result * 59 + ($startedAt == null ? 43 : $startedAt.hashCode());
            String $finishedAt = this.getFinishedAt();
            result = result * 59 + ($finishedAt == null ? 43 : $finishedAt.hashCode());
            HealthState $health = this.getHealth();
            result = result * 59 + ($health == null ? 43 : ((Object)$health).hashCode());
            return result;
        }

        public String toString() {
            return "InspectContainerResponse.ContainerState(status=" + this.getStatus() + ", running=" + this.getRunning() + ", paused=" + this.getPaused() + ", restarting=" + this.getRestarting() + ", oomKilled=" + this.getOOMKilled() + ", dead=" + this.getDead() + ", pid=" + this.getPid() + ", exitCode=" + this.getExitCode() + ", error=" + this.getError() + ", startedAt=" + this.getStartedAt() + ", finishedAt=" + this.getFinishedAt() + ", health=" + this.getHealth() + ")";
        }
    }
}

