/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.core.exec;

import com.fasterxml.jackson.core.type.TypeReference;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.BuildImageCmd;
import com.github.dockerjava.api.model.AuthConfigurations;
import com.github.dockerjava.api.model.BuildResponseItem;
import com.github.dockerjava.core.DockerClientConfig;
import com.github.dockerjava.core.InvocationBuilder;
import com.github.dockerjava.core.MediaType;
import com.github.dockerjava.core.WebTarget;
import com.github.dockerjava.core.exec.AbstrAsyncDockerCmdExec;
import com.github.dockerjava.core.util.CacheFromEncoder;
import javax.annotation.CheckForNull;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuildImageCmdExec
extends AbstrAsyncDockerCmdExec<BuildImageCmd, BuildResponseItem>
implements BuildImageCmd.Exec {
    private static final Logger LOGGER = LoggerFactory.getLogger(BuildImageCmdExec.class);

    public BuildImageCmdExec(WebTarget baseResource, DockerClientConfig dockerClientConfig) {
        super(baseResource, dockerClientConfig);
    }

    private InvocationBuilder resourceWithOptionalAuthConfig(BuildImageCmd command2, InvocationBuilder request) {
        AuthConfigurations authConfigs = BuildImageCmdExec.firstNonNull(command2.getBuildAuthConfigs(), this.getBuildAuthConfigs());
        if (authConfigs != null && !authConfigs.getConfigs().isEmpty()) {
            request = request.header("X-Registry-Config", this.registryConfigs(authConfigs));
        }
        return request;
    }

    @CheckForNull
    private static AuthConfigurations firstNonNull(@CheckForNull AuthConfigurations fromCommand, @CheckForNull AuthConfigurations fromConfig) {
        if (fromCommand != null) {
            return fromCommand;
        }
        if (fromConfig != null) {
            return fromConfig;
        }
        return null;
    }

    @Override
    protected Void execute0(BuildImageCmd command2, ResultCallback<BuildResponseItem> resultCallback) {
        WebTarget webTarget = this.getBaseResource().path("/build");
        String dockerFilePath = command2.getPathToDockerfile();
        if (dockerFilePath != null && command2.getRemote() == null && !"Dockerfile".equals(dockerFilePath)) {
            webTarget = webTarget.queryParam("dockerfile", dockerFilePath);
        }
        if (command2.getTags() != null && !command2.getTags().isEmpty()) {
            webTarget = webTarget.queryParamsSet("t", command2.getTags());
        } else if (StringUtils.isNotBlank(command2.getTag())) {
            webTarget = webTarget.queryParam("t", command2.getTag());
        }
        if (command2.getCacheFrom() != null && !command2.getCacheFrom().isEmpty()) {
            webTarget = webTarget.queryParam("cachefrom", CacheFromEncoder.jsonEncode(command2.getCacheFrom()));
        }
        if (command2.getRemote() != null) {
            webTarget = webTarget.queryParam("remote", command2.getRemote().toString());
        }
        webTarget = this.booleanQueryParam(webTarget, "q", command2.isQuiet());
        webTarget = this.booleanQueryParam(webTarget, "nocache", command2.hasNoCacheEnabled());
        webTarget = this.booleanQueryParam(webTarget, "pull", command2.hasPullEnabled());
        webTarget = this.booleanQueryParam(webTarget, "rm", command2.hasRemoveEnabled());
        webTarget = this.booleanQueryParam(webTarget, "forcerm", command2.isForcerm());
        if (command2.hasRemoveEnabled() == null || !command2.hasRemoveEnabled().booleanValue()) {
            webTarget = webTarget.queryParam("rm", "false");
        }
        if (command2.getMemory() != null) {
            webTarget = webTarget.queryParam("memory", command2.getMemory());
        }
        if (command2.getMemswap() != null) {
            webTarget = webTarget.queryParam("memswap", command2.getMemswap());
        }
        if (command2.getCpushares() != null) {
            webTarget = webTarget.queryParam("cpushares", command2.getCpushares());
        }
        if (command2.getCpusetcpus() != null) {
            webTarget = webTarget.queryParam("cpusetcpus", command2.getCpusetcpus());
        }
        if (command2.getBuildArgs() != null) {
            webTarget = webTarget.queryParamsJsonMap("buildargs", command2.getBuildArgs());
        }
        if (command2.getShmsize() != null) {
            webTarget = webTarget.queryParam("shmsize", command2.getShmsize());
        }
        if (command2.getLabels() != null) {
            webTarget = webTarget.queryParamsJsonMap("labels", command2.getLabels());
        }
        if (command2.getNetworkMode() != null) {
            webTarget = webTarget.queryParam("networkmode", command2.getNetworkMode());
        }
        if (command2.getPlatform() != null) {
            webTarget = webTarget.queryParam("platform", command2.getPlatform());
        }
        if (command2.getTarget() != null) {
            webTarget = webTarget.queryParam("target", command2.getTarget());
        }
        if (command2.getExtraHosts() != null) {
            webTarget = webTarget.queryParamsSet("extrahosts", command2.getExtraHosts());
        }
        LOGGER.trace("POST: {}", (Object)webTarget);
        InvocationBuilder builder = this.resourceWithOptionalAuthConfig(command2, webTarget.request()).accept(MediaType.APPLICATION_JSON).header("Content-Type", "application/tar").header("encoding", "gzip");
        builder.post(new TypeReference<BuildResponseItem>(){}, resultCallback, command2.getTarInputStream());
        return null;
    }
}

