/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.core.exec;

import com.fasterxml.jackson.core.type.TypeReference;
import com.github.dockerjava.api.command.ListContainersCmd;
import com.github.dockerjava.api.model.Container;
import com.github.dockerjava.core.DockerClientConfig;
import com.github.dockerjava.core.MediaType;
import com.github.dockerjava.core.WebTarget;
import com.github.dockerjava.core.exec.AbstrSyncDockerCmdExec;
import com.github.dockerjava.core.util.FiltersEncoder;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListContainersCmdExec
extends AbstrSyncDockerCmdExec<ListContainersCmd, List<Container>>
implements ListContainersCmd.Exec {
    private static final Logger LOGGER = LoggerFactory.getLogger(ListContainersCmdExec.class);

    public ListContainersCmdExec(WebTarget baseResource, DockerClientConfig dockerClientConfig) {
        super(baseResource, dockerClientConfig);
    }

    @Override
    protected List<Container> execute(ListContainersCmd command2) {
        WebTarget webTarget = this.getBaseResource().path("/containers/json").queryParam("since", command2.getSinceId()).queryParam("before", command2.getBeforeId());
        webTarget = this.booleanQueryParam(webTarget, "all", command2.hasShowAllEnabled());
        webTarget = this.booleanQueryParam(webTarget, "size", command2.hasShowSizeEnabled());
        if (command2.getLimit() != null && command2.getLimit() >= 0) {
            webTarget = webTarget.queryParam("limit", String.valueOf(command2.getLimit()));
        }
        if (command2.getFilters() != null && !command2.getFilters().isEmpty()) {
            webTarget = webTarget.queryParam("filters", FiltersEncoder.jsonEncode(command2.getFilters()));
        }
        LOGGER.trace("GET: {}", (Object)webTarget);
        List<Container> containers = webTarget.request().accept(MediaType.APPLICATION_JSON).get(new TypeReference<List<Container>>(){});
        LOGGER.trace("Response: {}", (Object)containers);
        return containers;
    }
}

