/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.core.exec;

import com.fasterxml.jackson.core.type.TypeReference;
import com.github.dockerjava.api.command.ListSecretsCmd;
import com.github.dockerjava.api.model.Secret;
import com.github.dockerjava.core.DockerClientConfig;
import com.github.dockerjava.core.MediaType;
import com.github.dockerjava.core.WebTarget;
import com.github.dockerjava.core.exec.AbstrSyncDockerCmdExec;
import com.github.dockerjava.core.util.FiltersEncoder;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListSecretsCmdExec
extends AbstrSyncDockerCmdExec<ListSecretsCmd, List<Secret>>
implements ListSecretsCmd.Exec {
    private static final Logger LOGGER = LoggerFactory.getLogger(ListSecretsCmdExec.class);

    public ListSecretsCmdExec(WebTarget baseResource, DockerClientConfig dockerClientConfig) {
        super(baseResource, dockerClientConfig);
    }

    @Override
    protected List<Secret> execute(ListSecretsCmd command2) {
        WebTarget webTarget = this.getBaseResource().path("/secrets");
        if (command2.getFilters() != null && !command2.getFilters().isEmpty()) {
            webTarget = webTarget.queryParam("filters", FiltersEncoder.jsonEncode(command2.getFilters()));
        }
        LOGGER.trace("GET: {}", (Object)webTarget);
        List<Secret> secrets = webTarget.request().accept(MediaType.APPLICATION_JSON).get(new TypeReference<List<Secret>>(){});
        LOGGER.trace("Response: {}", (Object)secrets);
        return secrets;
    }
}

