/*
 * Decompiled with CFR 0.152.
 */
package com.github.dockerjava.core.exec;

import com.fasterxml.jackson.core.type.TypeReference;
import com.github.dockerjava.api.command.ListTasksCmd;
import com.github.dockerjava.api.model.Task;
import com.github.dockerjava.core.DockerClientConfig;
import com.github.dockerjava.core.MediaType;
import com.github.dockerjava.core.WebTarget;
import com.github.dockerjava.core.exec.AbstrSyncDockerCmdExec;
import com.github.dockerjava.core.util.FiltersEncoder;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListTasksCmdExec
extends AbstrSyncDockerCmdExec<ListTasksCmd, List<Task>>
implements ListTasksCmd.Exec {
    private static final Logger LOGGER = LoggerFactory.getLogger(ListTasksCmdExec.class);

    public ListTasksCmdExec(WebTarget baseResource, DockerClientConfig dockerClientConfig) {
        super(baseResource, dockerClientConfig);
    }

    @Override
    protected List<Task> execute(ListTasksCmd command2) {
        WebTarget webTarget = this.getBaseResource().path("/tasks");
        if (command2.getFilters() != null && !command2.getFilters().isEmpty()) {
            webTarget = webTarget.queryParam("filters", FiltersEncoder.jsonEncode(command2.getFilters()));
        }
        LOGGER.trace("GET: {}", (Object)webTarget);
        List<Task> tasks = webTarget.request().accept(MediaType.APPLICATION_JSON).get(new TypeReference<List<Task>>(){});
        LOGGER.trace("Response: {}", (Object)tasks);
        return tasks;
    }
}

