/*
 * Decompiled with CFR 0.152.
 */
package it.krzeminski.snakeyaml.engine.kmp.api;

import java.io.Closeable;
import java.util.Comparator;
import java.util.List;
import kotlin.ExceptionsKt;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.Buffer;
import okio.BufferedSource;
import okio.ByteString;
import okio.Okio;
import okio.Options;
import okio.Source;
import okio.Timeout;
import okio.TypedOptions;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u0000 \u001b2\u00020\u0001:\u0003\u0019\u001a\u001bB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0004\u0010\u0006J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000eH\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\r\u0010\u0016\u001a\u00020\u0017H\u0000\u00a2\u0006\u0002\b\u0018R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lit/krzeminski/snakeyaml/engine/kmp/api/YamlUnicodeReader;", "Lokio/Source;", "source", "Lokio/BufferedSource;", "<init>", "(Lokio/BufferedSource;)V", "(Lokio/Source;)V", "encoding", "Lit/krzeminski/snakeyaml/engine/kmp/api/YamlUnicodeReader$CharEncoding;", "getEncoding", "()Lit/krzeminski/snakeyaml/engine/kmp/api/YamlUnicodeReader$CharEncoding;", "codepointReader", "Lit/krzeminski/snakeyaml/engine/kmp/api/YamlUnicodeReader$CodepointReader;", "read", "", "sink", "Lokio/Buffer;", "byteCount", "close", "", "timeout", "Lokio/Timeout;", "readString", "", "readString$snakeyaml_engine_kmp", "CodepointReader", "CharEncoding", "Companion", "snakeyaml-engine-kmp"})
@SourceDebugExtension(value={"SMAP\nYamlUnicodeReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 YamlUnicodeReader.kt\nit/krzeminski/snakeyaml/engine/kmp/api/YamlUnicodeReader\n+ 2 Okio.kt\nokio/Okio__OkioKt\n*L\n1#1,141:1\n66#2:142\n52#2,22:143\n*S KotlinDebug\n*F\n+ 1 YamlUnicodeReader.kt\nit/krzeminski/snakeyaml/engine/kmp/api/YamlUnicodeReader\n*L\n80#1:142\n80#1:143,22\n*E\n"})
public final class YamlUnicodeReader
implements Source {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BufferedSource source;
    @NotNull
    private final CharEncoding encoding;
    @Nullable
    private final CodepointReader codepointReader;

    public YamlUnicodeReader(@NotNull BufferedSource source2) {
        CodepointReader codepointReader;
        Intrinsics.checkNotNullParameter(source2, "source");
        this.source = source2;
        CharEncoding charEncoding = CharEncoding.Companion.detectCharEncoding$snakeyaml_engine_kmp(this.source);
        if (charEncoding == null) {
            charEncoding = CharEncoding.UTF_8;
        }
        this.encoding = charEncoding;
        switch (WhenMappings.$EnumSwitchMapping$0[this.encoding.ordinal()]) {
            case 1: {
                codepointReader = null;
                break;
            }
            case 2: {
                codepointReader = CodepointReader.Companion.getUTF_16BE();
                break;
            }
            case 3: {
                codepointReader = CodepointReader.Companion.getUTF_16LE();
                break;
            }
            case 4: {
                codepointReader = CodepointReader.Companion.getUTF_32BE();
                break;
            }
            case 5: {
                codepointReader = CodepointReader.Companion.getUTF_32LE();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        this.codepointReader = codepointReader;
    }

    public YamlUnicodeReader(@NotNull Source source2) {
        Intrinsics.checkNotNullParameter(source2, "source");
        this(Okio.buffer(source2));
    }

    @NotNull
    public final CharEncoding getEncoding() {
        return this.encoding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public long read(@NotNull Buffer sink2, long byteCount) {
        Intrinsics.checkNotNullParameter(sink2, "sink");
        if (this.codepointReader != null) {
            Object var10_17;
            Buffer buffer2333333332;
            Throwable thrown$iv;
            Closeable $this$use$iv;
            block18: {
                $this$use$iv = new Buffer();
                boolean $i$f$use = false;
                thrown$iv = null;
                buffer2333333332 = (Buffer)$this$use$iv;
                boolean bl = false;
                while (this.source.request(this.encoding.getCharSize$snakeyaml_engine_kmp()) && buffer2333333332.size() < byteCount) {
                    int codepoint = this.codepointReader.readCodepoint(this.source);
                    buffer2333333332.writeUtf8CodePoint(codepoint);
                }
                if (buffer2333333332.size() > 0L) break block18;
                long l = -1L;
                try {
                    $this$use$iv.close();
                }
                catch (Throwable buffer2333333332) {
                    // empty catch block
                }
                return l;
            }
            Buffer.copyTo$default(buffer2333333332, sink2, 0L, 2, null);
            long l = buffer2333333332.size();
            try {
                $this$use$iv.close();
            }
            catch (Throwable buffer233333332) {
                // empty catch block
            }
            return l;
            catch (Throwable t$iv) {
                try {
                    thrown$iv = t$iv;
                    var10_17 = null;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    block20: {
                        try {
                            $this$use$iv.close();
                        }
                        catch (Throwable t$iv2) {
                            if (thrown$iv == null) {
                                thrown$iv = t$iv2;
                                break block20;
                            }
                            ExceptionsKt.addSuppressed(thrown$iv, t$iv2);
                        }
                    }
                }
            }
            Object result$iv = var10_17;
            Throwable throwable = thrown$iv;
            if (throwable != null) {
                throw throwable;
            }
            throw new KotlinNothingValueException();
        }
        return this.source.read(sink2, byteCount);
    }

    @Override
    public void close() {
        this.source.close();
    }

    @Override
    @NotNull
    public Timeout timeout() {
        return this.source.timeout();
    }

    @NotNull
    public final String readString$snakeyaml_engine_kmp() {
        return Okio.buffer(this).readUtf8();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0002\b\f\b\u0086\u0081\u0002\u0018\u0000 \u00142\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0014B\u0019\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0019\b\u0012\u0012\u0006\u0010\u0002\u001a\u00020\b\u0012\u0006\u0010\u0004\u001a\u00020\t\u00a2\u0006\u0004\b\u0006\u0010\nR\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013\u00a8\u0006\u0015"}, d2={"Lit/krzeminski/snakeyaml/engine/kmp/api/YamlUnicodeReader$CharEncoding;", "", "bom", "Lokio/ByteString;", "charSize", "", "<init>", "(Ljava/lang/String;ILokio/ByteString;J)V", "", "", "(Ljava/lang/String;ILjava/lang/String;I)V", "getBom$snakeyaml_engine_kmp", "()Lokio/ByteString;", "getCharSize$snakeyaml_engine_kmp", "()J", "UTF_8", "UTF_16BE", "UTF_16LE", "UTF_32BE", "UTF_32LE", "Companion", "snakeyaml-engine-kmp"})
    public static final class CharEncoding
    extends Enum<CharEncoding> {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private final ByteString bom;
        private final long charSize;
        public static final /* enum */ CharEncoding UTF_8;
        public static final /* enum */ CharEncoding UTF_16BE;
        public static final /* enum */ CharEncoding UTF_16LE;
        public static final /* enum */ CharEncoding UTF_32BE;
        public static final /* enum */ CharEncoding UTF_32LE;
        private static final /* synthetic */ CharEncoding[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private CharEncoding(ByteString bom, long charSize) {
            this.bom = bom;
            this.charSize = charSize;
        }

        @NotNull
        public final ByteString getBom$snakeyaml_engine_kmp() {
            return this.bom;
        }

        public final long getCharSize$snakeyaml_engine_kmp() {
            return this.charSize;
        }

        private CharEncoding(String bom, int charSize) {
            this(ByteString.Companion.decodeHex(bom), (long)charSize);
        }

        public static CharEncoding[] values() {
            return (CharEncoding[])$VALUES.clone();
        }

        public static CharEncoding valueOf(String value) {
            return Enum.valueOf(CharEncoding.class, value);
        }

        @NotNull
        public static EnumEntries<CharEncoding> getEntries() {
            return $ENTRIES;
        }

        static {
            UTF_8 = new CharEncoding("efbbbf", 2);
            UTF_16BE = new CharEncoding("feff", 2);
            UTF_16LE = new CharEncoding("fffe", 2);
            UTF_32BE = new CharEncoding("0000feff", 4);
            UTF_32LE = new CharEncoding("fffe0000", 4);
            $VALUES = charEncodingArray = new CharEncoding[]{CharEncoding.UTF_8, CharEncoding.UTF_16BE, CharEncoding.UTF_16LE, CharEncoding.UTF_32BE, CharEncoding.UTF_32LE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005*\u00020\u0006H\u0000\u00a2\u0006\u0002\b\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lit/krzeminski/snakeyaml/engine/kmp/api/YamlUnicodeReader$CharEncoding$Companion;", "", "<init>", "()V", "detectCharEncoding", "Lit/krzeminski/snakeyaml/engine/kmp/api/YamlUnicodeReader$CharEncoding;", "Lokio/BufferedSource;", "detectCharEncoding$snakeyaml_engine_kmp", "UnicodeBomOptions", "Lokio/TypedOptions;", "getUnicodeBomOptions", "()Lokio/TypedOptions;", "snakeyaml-engine-kmp"})
        @SourceDebugExtension(value={"SMAP\nYamlUnicodeReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 YamlUnicodeReader.kt\nit/krzeminski/snakeyaml/engine/kmp/api/YamlUnicodeReader$CharEncoding$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 TypedOptions.kt\nokio/TypedOptions$Companion\n*L\n1#1,141:1\n1062#2:142\n46#3,3:143\n*S KotlinDebug\n*F\n+ 1 YamlUnicodeReader.kt\nit/krzeminski/snakeyaml/engine/kmp/api/YamlUnicodeReader$CharEncoding$Companion\n*L\n132#1:142\n134#1:143,3\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            @Nullable
            public final CharEncoding detectCharEncoding$snakeyaml_engine_kmp(@NotNull BufferedSource $this$detectCharEncoding) {
                Intrinsics.checkNotNullParameter($this$detectCharEncoding, "<this>");
                return $this$detectCharEncoding.select(this.getUnicodeBomOptions());
            }

            /*
             * WARNING - void declaration
             */
            private final TypedOptions<CharEncoding> getUnicodeBomOptions() {
                Iterable $this$sortedByDescending$iv = CharEncoding.getEntries();
                boolean $i$f$sortedByDescending = false;
                List sortedEntries = CollectionsKt.sortedWith($this$sortedByDescending$iv, new Comparator(){

                    public final int compare(T a, T b) {
                        CharEncoding it = (CharEncoding)((Object)b);
                        boolean bl = false;
                        Comparable comparable = Integer.valueOf(it.getBom$snakeyaml_engine_kmp().size());
                        it = (CharEncoding)((Object)a);
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues(comparable2, it.getBom$snakeyaml_engine_kmp().size());
                    }
                });
                TypedOptions.Companion this_$iv = TypedOptions.Companion;
                boolean $i$f$of = false;
                List list$iv = CollectionsKt.toList(sortedEntries);
                int n = 0;
                int n2 = list$iv.size();
                ByteString[] byteStringArray = new ByteString[n2];
                Options.Companion companion = Options.Companion;
                while (n < n2) {
                    void p0;
                    ByteString byteString;
                    int n3 = n++;
                    CharEncoding charEncoding = (CharEncoding)((Object)list$iv.get(n3));
                    int n4 = n3;
                    ByteString[] byteStringArray2 = byteStringArray;
                    boolean bl = false;
                    byteStringArray2[n4] = byteString = p0.getBom$snakeyaml_engine_kmp();
                }
                Options options$iv = companion.of(byteStringArray);
                return new TypedOptions<CharEncoding>(list$iv, options$iv);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00e2\u0080\u0001\u0018\u0000 \u00062\u00020\u0001:\u0001\u0006J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0007"}, d2={"Lit/krzeminski/snakeyaml/engine/kmp/api/YamlUnicodeReader$CodepointReader;", "", "readCodepoint", "", "source", "Lokio/BufferedSource;", "Companion", "snakeyaml-engine-kmp"})
    private static interface CodepointReader {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        public int readCodepoint(@NotNull BufferedSource var1);

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u0011\u0010\f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007\u00a8\u0006\u000e"}, d2={"Lit/krzeminski/snakeyaml/engine/kmp/api/YamlUnicodeReader$CodepointReader$Companion;", "", "<init>", "()V", "UTF_16BE", "Lit/krzeminski/snakeyaml/engine/kmp/api/YamlUnicodeReader$CodepointReader;", "getUTF_16BE", "()Lit/krzeminski/snakeyaml/engine/kmp/api/YamlUnicodeReader$CodepointReader;", "UTF_16LE", "getUTF_16LE", "UTF_32BE", "getUTF_32BE", "UTF_32LE", "getUTF_32LE", "snakeyaml-engine-kmp"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;
            @NotNull
            private static final CodepointReader UTF_16BE;
            @NotNull
            private static final CodepointReader UTF_16LE;
            @NotNull
            private static final CodepointReader UTF_32BE;
            @NotNull
            private static final CodepointReader UTF_32LE;

            private Companion() {
            }

            @NotNull
            public final CodepointReader getUTF_16BE() {
                return UTF_16BE;
            }

            @NotNull
            public final CodepointReader getUTF_16LE() {
                return UTF_16LE;
            }

            @NotNull
            public final CodepointReader getUTF_32BE() {
                return UTF_32BE;
            }

            @NotNull
            public final CodepointReader getUTF_32LE() {
                return UTF_32LE;
            }

            private static final int UTF_16BE$lambda$0(BufferedSource source2) {
                Intrinsics.checkNotNullParameter(source2, "source");
                return source2.readShort();
            }

            private static final int UTF_16LE$lambda$1(BufferedSource source2) {
                Intrinsics.checkNotNullParameter(source2, "source");
                return source2.readShortLe();
            }

            private static final int UTF_32BE$lambda$2(BufferedSource source2) {
                Intrinsics.checkNotNullParameter(source2, "source");
                return source2.readInt();
            }

            private static final int UTF_32LE$lambda$3(BufferedSource source2) {
                Intrinsics.checkNotNullParameter(source2, "source");
                return source2.readIntLe();
            }

            static {
                $$INSTANCE = new Companion();
                UTF_16BE = Companion::UTF_16BE$lambda$0;
                UTF_16LE = Companion::UTF_16LE$lambda$1;
                UTF_32BE = Companion::UTF_32BE$lambda$2;
                UTF_32LE = Companion::UTF_32LE$lambda$3;
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0004"}, d2={"Lit/krzeminski/snakeyaml/engine/kmp/api/YamlUnicodeReader$Companion;", "", "<init>", "()V", "snakeyaml-engine-kmp"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CharEncoding.values().length];
            try {
                nArray[CharEncoding.UTF_8.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CharEncoding.UTF_16BE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CharEncoding.UTF_16LE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CharEncoding.UTF_32BE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CharEncoding.UTF_32LE.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

