/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.nio.command;

import org.apache.hc.core5.annotation.Internal;
import org.apache.hc.core5.http.ConnectionClosedException;
import org.apache.hc.core5.http.nio.AsyncClientExchangeHandler;
import org.apache.hc.core5.http.nio.command.RequestExecutionCommand;
import org.apache.hc.core5.reactor.Command;
import org.apache.hc.core5.reactor.IOSession;
import org.apache.hc.core5.util.Args;

@Internal
public final class CommandSupport {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void failCommands(IOSession ioSession, Exception ex) {
        Command command2;
        Args.notNull(ioSession, "I/O session");
        while ((command2 = ioSession.poll()) != null) {
            if (command2 instanceof RequestExecutionCommand) {
                AsyncClientExchangeHandler exchangeHandler = ((RequestExecutionCommand)command2).getExchangeHandler();
                try {
                    exchangeHandler.failed(ex);
                    continue;
                }
                finally {
                    exchangeHandler.releaseResources();
                    continue;
                }
            }
            command2.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cancelCommands(IOSession ioSession) {
        Command command2;
        Args.notNull(ioSession, "I/O session");
        while ((command2 = ioSession.poll()) != null) {
            if (command2 instanceof RequestExecutionCommand) {
                AsyncClientExchangeHandler exchangeHandler = ((RequestExecutionCommand)command2).getExchangeHandler();
                try {
                    if (!ioSession.isOpen()) {
                        exchangeHandler.failed(new ConnectionClosedException());
                        continue;
                    }
                    exchangeHandler.cancel();
                    continue;
                }
                finally {
                    exchangeHandler.releaseResources();
                    continue;
                }
            }
            command2.cancel();
        }
    }
}

