/*
 * Decompiled with CFR 0.152.
 */
package net.additions.archipelagoadditions.event.loot;

import com.google.gson.JsonObject;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.additions.archipelagoadditions.config.ArchipelagoAdditionsCommonConfigs;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class EggCrateFromChestAdditionModifier
extends LootModifier {
    private final Item addition;

    protected EggCrateFromChestAdditionModifier(LootItemCondition[] conditionsIn, Item addition) {
        super(conditionsIn);
        this.addition = addition;
    }

    @Nonnull
    protected List<ItemStack> doApply(List<ItemStack> generatedLoot, LootContext context) {
        if (!((Boolean)ArchipelagoAdditionsCommonConfigs.DISABLE_DRAGON_EGG_CRATE_GAMEPLAY.get()).booleanValue()) {
            generatedLoot.add(new ItemStack((ItemLike)this.addition, ((Integer)ArchipelagoAdditionsCommonConfigs.DRAGON_EGG_CRATE_GAMEPLAY_QUANTITY.get()).intValue()));
        }
        return generatedLoot;
    }

    public static class Serializer
    extends GlobalLootModifierSerializer<EggCrateFromChestAdditionModifier> {
        public EggCrateFromChestAdditionModifier read(ResourceLocation name, JsonObject object, LootItemCondition[] conditionsIn) {
            Item addition = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(GsonHelper.m_13906_((JsonObject)object, (String)"addition")));
            return new EggCrateFromChestAdditionModifier(conditionsIn, addition);
        }

        public JsonObject write(EggCrateFromChestAdditionModifier instance) {
            JsonObject json = this.makeConditions(instance.conditions);
            json.addProperty("addition", Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)instance.addition)).toString());
            return json;
        }
    }
}

