/*
 * Decompiled with CFR 0.152.
 */
package net.additions.archipelagoadditions.item.custom;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import net.additions.archipelagoadditions.item.ModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import org.jetbrains.annotations.Nullable;

public class InfernoItem
extends Item {
    public InfernoItem(Item.Properties properties) {
        super(properties);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        if (slot == EquipmentSlot.MAINHAND) {
            CompoundTag tag = stack.m_41784_();
            boolean isOn = tag.m_128471_("Extended");
            builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", isOn ? -2.4 : -3.0, AttributeModifier.Operation.ADDITION));
            builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", isOn ? 6.0 : 0.0, AttributeModifier.Operation.ADDITION));
        }
        return builder.build();
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        pTooltipComponents.add((Component)new TranslatableComponent("tooltip.archipelagoadditions.inferno.tooltip"));
        pTooltipComponents.add((Component)new TranslatableComponent("tooltip.archipelagoadditions.dragon_aggro.tooltip"));
    }

    public static boolean isBroken(ItemStack stack) {
        return stack.m_41784_().m_128471_("Empty");
    }

    private static void setBroken(ItemStack stack, boolean v) {
        stack.m_41784_().m_128379_("Empty", v);
    }

    public static boolean isOn(ItemStack stack) {
        return stack.m_41782_() && stack.m_41783_().m_128471_("Extended");
    }

    private static void damageOrMarkBroken(ItemStack stack, LivingEntity user, EquipmentSlot slot, int amount) {
        int max = stack.m_41776_();
        int cur = stack.m_41773_();
        int next = cur + amount;
        if (next >= max) {
            stack.m_41721_(max);
            InfernoItem.setBroken(stack, true);
            user.m_21166_(slot);
        } else {
            stack.m_41721_(next);
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (InfernoItem.isBroken(stack)) {
            return InteractionResultHolder.m_19092_((Object)stack, (boolean)level.m_5776_());
        }
        boolean wasOn = stack.m_41784_().m_128471_("Extended");
        stack.m_41783_().m_128379_("Extended", !wasOn);
        if (!level.f_46443_) {
            float pitch = 0.9f + level.f_46441_.nextFloat() * 0.2f;
            level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11942_, SoundSource.PLAYERS, 1.0f, pitch);
        }
        return InteractionResultHolder.m_19092_((Object)stack, (boolean)level.m_5776_());
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (!InfernoItem.isBroken(stack) && InfernoItem.isOn(stack)) {
            target.m_20254_(5);
        }
        EquipmentSlot slot = attacker.m_21205_() == stack ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND;
        InfernoItem.damageOrMarkBroken(stack, attacker, slot, 1);
        return true;
    }

    public float m_8102_(ItemStack pStack, BlockState pState) {
        if (pState.m_60713_(Blocks.f_50033_)) {
            return 15.0f;
        }
        Material material = pState.m_60767_();
        return material != Material.f_76300_ && material != Material.f_76302_ && !pState.m_204336_(BlockTags.f_13035_) && material != Material.f_76285_ ? 1.0f : 1.5f;
    }

    public boolean m_6832_(ItemStack toRepair, ItemStack repair) {
        boolean valid = repair.m_150930_((Item)ModItems.DRAGON_BLADE_CANISTER.get());
        if (valid && toRepair.m_41782_()) {
            toRepair.m_41783_().m_128379_("Empty", false);
            toRepair.m_41783_().m_128379_("Extended", false);
        }
        return valid;
    }

    public boolean m_8096_(BlockState pBlock) {
        return pBlock.m_60713_(Blocks.f_50033_);
    }

    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        return ToolActions.DEFAULT_SWORD_ACTIONS.contains(toolAction);
    }

    public int m_6473_() {
        return 1;
    }

    public boolean m_6813_(ItemStack stack, Level level, BlockState state, BlockPos pos, LivingEntity miner) {
        if (!level.f_46443_ && state.m_60800_((BlockGetter)level, pos) != 0.0f) {
            EquipmentSlot slot = miner.m_21205_() == stack ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND;
            InfernoItem.damageOrMarkBroken(stack, miner, slot, 1);
        }
        return super.m_6813_(stack, level, state, pos, miner);
    }
}

