package net.craftish37.commonboat;

import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import org.lwjgl.glfw.GLFW;

public class CommonBoat implements ClientModInitializer {
    private static class_304 masterToggleKey;
    private static class_304 slipperinessToggleKey;
    private static class_304 velocityToggleKey;
    private static class_304 stepHeightToggleKey;
    private static class_304 airDragToggleKey;
    private static class_304 easterEggsToggleKey;
    private static class_304 handbrakeToggleKey;
    private static class_304 flappyBirdToggleKey;
    private static class_304 flappyBirdPitchToggleKey;
    private static class_304 leFischeAuChocolatToggleKey;
    private static class_304 registerToggleKey(String key) {
        return KeyBindingHelper.registerKeyBinding(new class_304(
                key,
                class_3675.class_307.field_1668,
                GLFW.GLFW_KEY_UNKNOWN,
                "category.commonboat"
        ));
    }
    private void performToggle(class_310 client, CommonBoatConfig cfg, String configKey, boolean newState) {
        cfg.save();
        if (client.field_1724 != null) {
            String statusKey = newState ? "text.commonboat.status.enabled" : "text.commonboat.status.disabled";
            class_2561 configName = class_2561.method_43471("text.commonboat.config." + configKey);
            class_2561 message = configName.method_27661().method_27693(": ").method_10852(class_2561.method_43471(statusKey));

            client.field_1724.method_7353(message, true);
        }
    }
    @Override
    public void onInitializeClient() {
        WorldRenderEvents.LAST.register(context -> EasterEggFishHighlighter.onWorldRender(context.matrixStack()));
        Sounds.registerSounds();
        ConfigAccess.get();
        EasterEggFishHighlighter.startUpdater();
        masterToggleKey = KeyBindingHelper.registerKeyBinding(new class_304(
                "key.commonboat.toggle",
                class_3675.class_307.field_1668,
                GLFW.GLFW_KEY_G,
                "category.commonboat"
        ));
        slipperinessToggleKey = registerToggleKey("text.commonboat.config.enable_slipperiness");
        velocityToggleKey = registerToggleKey("text.commonboat.config.enable_velocity");
        stepHeightToggleKey = registerToggleKey("text.commonboat.config.enable_step_height");
        airDragToggleKey = registerToggleKey("text.commonboat.config.remove_air_drag");
        easterEggsToggleKey = registerToggleKey("text.commonboat.config.enable_easter_eggs");
        handbrakeToggleKey = registerToggleKey("text.commonboat.config.enable_handbrake");
        flappyBirdToggleKey = registerToggleKey("text.commonboat.config.enable_flappybird");
        flappyBirdPitchToggleKey = registerToggleKey("text.commonboat.config.enable_flappybird_pitch_control");
        leFischeAuChocolatToggleKey = registerToggleKey("text.commonboat.config.enable_lefischeauchocolat");
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            CommonBoatConfig cfg = ConfigAccess.get();
            while (masterToggleKey.method_1436()) {
                boolean wasEnabled = cfg.enabled;
                cfg.enabled = !cfg.enabled;
                performToggle(client, cfg, "enable_mod", cfg.enabled);
                if (wasEnabled && cfg.easterEggsEnabled && cfg.handbrakeEnabled) {
                    client.field_1724.method_56078(Sounds.EASTER_EGG_DISABLE_SOUND);
                }
            }
            if (slipperinessToggleKey.method_1436()) {
                cfg.slipperinessEnabled = !cfg.slipperinessEnabled;
                performToggle(client, cfg, "enable_slipperiness", cfg.slipperinessEnabled);
            }
            if (velocityToggleKey.method_1436()) {
                cfg.velocityMultiplierEnabled = !cfg.velocityMultiplierEnabled;
                performToggle(client, cfg, "enable_velocity", cfg.velocityMultiplierEnabled);
            }
            if (stepHeightToggleKey.method_1436()) {
                cfg.boatStepHeightEnabled = !cfg.boatStepHeightEnabled;
                performToggle(client, cfg, "enable_step_height", cfg.boatStepHeightEnabled);
            }
            if (airDragToggleKey.method_1436()) {
                cfg.removeAirDrag = !cfg.removeAirDrag;
                performToggle(client, cfg, "remove_air_drag", cfg.removeAirDrag);
            }
            if (easterEggsToggleKey.method_1436()) {
                cfg.easterEggsEnabled = !cfg.easterEggsEnabled;
                performToggle(client, cfg, "enable_easter_eggs", cfg.easterEggsEnabled);
            }
            if (cfg.easterEggsEnabled) {
                if (handbrakeToggleKey.method_1436()) {
                    cfg.handbrakeEnabled = !cfg.handbrakeEnabled;
                    performToggle(client, cfg, "enable_handbrake", cfg.handbrakeEnabled);
                }
                if (flappyBirdToggleKey.method_1436()) {
                    cfg.flappyBirdEnabled = !cfg.flappyBirdEnabled;
                    performToggle(client, cfg, "enable_flappybird", cfg.flappyBirdEnabled);
                }
                if (flappyBirdPitchToggleKey.method_1436()) {
                    cfg.flappyBirdPitchControl = !cfg.flappyBirdPitchControl;
                    performToggle(client, cfg, "enable_flappybird_pitch_control", cfg.flappyBirdPitchControl);
                }
                if (leFischeAuChocolatToggleKey.method_1436()) {
                    cfg.leFischeAuChocolatEnabled = !cfg.leFischeAuChocolatEnabled;
                    performToggle(client, cfg, "enable_lefischeauchocolat", cfg.leFischeAuChocolatEnabled);
                }
            }
        });
    }
}