package net.craftish37.commonboat.mixin;

import net.craftish37.commonboat.ConfigAccess;
import net.minecraft.class_10255;
import net.minecraft.class_243;
import net.craftish37.commonboat.CommonBoatConfig;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_10255.class)
public abstract class AbstractBoatEntityTickMixin {
    @Inject(method = "tick", at = @At("TAIL"))
    private void applySpeedCap(CallbackInfo ci) {
        class_10255 boat = (class_10255) (Object) this;
        CommonBoatConfig cfg = ConfigAccess.get();
        if (cfg.enabled && cfg.maxSpeed != -1.0) {
            double internalMaxSpeed = cfg.maxSpeed / 20.0;
            class_243 currentVelocity = boat.method_18798();
            double horizontalSpeed = currentVelocity.method_37267();
            if (horizontalSpeed > internalMaxSpeed) {
                double scale = internalMaxSpeed / horizontalSpeed;
                boat.method_18799(new class_243(currentVelocity.field_1352 * scale, currentVelocity.field_1351, currentVelocity.field_1350 * scale)
                );
            }
        }
    }
}