package net.craftish37.commonboat.mixin;

import net.craftish37.commonboat.ConfigAccess;
import net.minecraft.class_10255;
import net.minecraft.class_10255.class_1691;
import net.minecraft.class_243;
import net.craftish37.commonboat.CommonBoatConfig;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_10255.class)
public abstract class AbstractBoatEntityAirDragMixin {
    @Unique
    private class_243 commonboat$savedVelocity = class_243.field_1353;
    @Shadow private class_1691 location;
    @Shadow private float yawVelocity;
    @Shadow private boolean pressingLeft;
    @Shadow private boolean pressingRight;
    @Shadow private boolean pressingForward;
    @Shadow private boolean pressingBack;
    @Inject(method = "updatePaddles", at = @At("HEAD"))
    private void preventPaddling(CallbackInfo ci) {
        CommonBoatConfig cfg = ConfigAccess.get();
        if (cfg.enabled && cfg.easterEggsEnabled && cfg.elytraBoatEnabled) {
            net.minecraft.class_310 client = net.minecraft.class_310.method_1551();
            class_10255 self = (class_10255) (Object) this;
            if (client.field_1724 != null && client.field_1724.method_5854() == self && client.field_1690.field_1903.method_1434()) {
                this.pressingLeft = false;
                this.pressingRight = false;
            }
        }
    }
    @Inject(method = "updateVelocity", at = @At("HEAD"), cancellable = true)
    private void saveVelocity(CallbackInfo ci) {
        class_10255 self = (class_10255) (Object) this;
        this.commonboat$savedVelocity = self.method_18798();
        CommonBoatConfig cfg = ConfigAccess.get();
        if (cfg.enabled && cfg.easterEggsEnabled && cfg.elytraBoatEnabled) {
            net.minecraft.class_310 client = net.minecraft.class_310.method_1551();
            if (client.field_1724 != null && client.field_1724.method_5854() == self && client.field_1690.field_1903.method_1434()) {
                this.yawVelocity = 0.0F;
                this.pressingLeft = false;
                this.pressingRight = false;
                if (!self.method_24828()) {
                    ci.cancel();
                }
            }
        }
    }
    @Inject(method = "updateVelocity", at = @At("TAIL"))
    private void applyCustomPhysics(CallbackInfo ci) {
        CommonBoatConfig cfg = ConfigAccess.get();
        class_10255 self = (class_10255) (Object) this;
        if (!cfg.enabled) {
            return;
        }
        if (cfg.easterEggsEnabled && cfg.elytraBoatEnabled) {
            return;
        }
        class_243 currentVelocity = self.method_18798();
        double savedSpeed = this.commonboat$savedVelocity.method_37267();
        class_243 savedHorizontalVector = new class_243(this.commonboat$savedVelocity.field_1352, 0, this.commonboat$savedVelocity.field_1350);
        if (this.location == class_1691.field_7720 && cfg.removeAirDrag) {
            if (currentVelocity.field_1351 > 0) {
                class_243 horizontalFacing = class_243.method_1030(0.0F, self.method_36454());
                class_243 newHorizontalVelocity = horizontalFacing.method_1021(savedSpeed);
                self.method_18799(new class_243(newHorizontalVelocity.field_1352, currentVelocity.field_1351, newHorizontalVelocity.field_1350));
            } else {
                self.method_18799(new class_243(savedHorizontalVector.field_1352, currentVelocity.field_1351, savedHorizontalVector.field_1350));
            }
        } else if (this.location == class_1691.field_7718 && cfg.velocityMultiplierEnabled) {
            boolean isPaddling = this.pressingForward || this.pressingBack;
            boolean isTurning = this.pressingLeft || this.pressingRight || this.yawVelocity != 0.0F;
            if (!isPaddling && !isTurning) {
                self.method_18799(new class_243(savedHorizontalVector.field_1352, currentVelocity.field_1351, savedHorizontalVector.field_1350));
            }
        }
    }
}