package net.craftish37.commonboat.mixin;

import net.craftish37.commonboat.ConfigAccess;
import net.minecraft.class_10255;
import net.minecraft.class_10255.class_1691;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_746;
import net.craftish37.commonboat.CommonBoatConfig;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_746.class)
public class BoatJumpMixin {
    @Shadow @Final protected class_310 client;
    @Unique
    private double commonboat$lastJumpPeakY = 0.0;
    @Unique
    private float commonboat$elytraCurrentSpeed = 0.0F;
    @Unique
    private void commonboat$handleElytraBoat(class_746 player, class_10255 boat, CommonBoatConfig cfg) {
        boat.method_36456(player.method_36454());
        boat.method_36457(player.method_36455());
        float currentActualSpeed = (float) boat.method_18798().method_1033();
        if (currentActualSpeed < this.commonboat$elytraCurrentSpeed - 0.05F) {
            this.commonboat$elytraCurrentSpeed = currentActualSpeed;
        }
        ((AbstractBoatEntityAccessor) boat).setPressingLeft(false);
        ((AbstractBoatEntityAccessor) boat).setPressingRight(false);

        class_243 lookDirection = player.method_5720();
        float acceleration = 0.04F;
        float deceleration = 0.02F;
        boolean pressingForward = client.field_1690.field_1894.method_1434();
        boolean pressingBack = client.field_1690.field_1881.method_1434();
        if (pressingForward) {
            this.commonboat$elytraCurrentSpeed += acceleration;
        } else if (pressingBack) {
            this.commonboat$elytraCurrentSpeed -= deceleration;
        } else {
        }
        if (cfg.maxSpeed != -1.0) {
            float maxSpeedCap = (float) (cfg.maxSpeed / 20.0);
            this.commonboat$elytraCurrentSpeed = class_3532.method_15363(this.commonboat$elytraCurrentSpeed, (float) (-maxSpeedCap * 0.5), maxSpeedCap);
        }
        if (Math.abs(this.commonboat$elytraCurrentSpeed) < 0.005F) {
            this.commonboat$elytraCurrentSpeed = 0.0F;
        }
        class_243 newVelocity = lookDirection.method_1021(this.commonboat$elytraCurrentSpeed);
        boat.method_18799(newVelocity);

        this.commonboat$lastJumpPeakY = boat.method_23318();
    }
    @Inject(method = "tick", at = @At("HEAD"))
    private void onTick(CallbackInfo ci) {
        class_746 player = (class_746) (Object) this;
        CommonBoatConfig cfg = ConfigAccess.get();
        if (cfg.enabled && cfg.easterEggsEnabled && player.method_5854() instanceof class_10255 boat) {

            boolean isElytraBoatActive = cfg.elytraBoatEnabled && this.client.field_1690.field_1903.method_1434();

            if (isElytraBoatActive) {
                this.commonboat$handleElytraBoat(player, boat, cfg);
                return;
            } else {
                if (cfg.elytraBoatEnabled) {
                    this.commonboat$elytraCurrentSpeed = (float) (this.commonboat$elytraCurrentSpeed * 0.9);
                    if (Math.abs(this.commonboat$elytraCurrentSpeed) < 0.005F) {
                        this.commonboat$elytraCurrentSpeed = 0.0F;
                    }
                    float currentActualSpeed = (float) boat.method_18798().method_1033();
                    if (currentActualSpeed < this.commonboat$elytraCurrentSpeed - 0.05F) {
                        this.commonboat$elytraCurrentSpeed = currentActualSpeed;
                    }
                }
            }
        }
        if (cfg.enabled && cfg.easterEggsEnabled && cfg.flappyBirdEnabled) {
            if (player.method_5854() instanceof class_10255 boat) {
                boolean canInitiateJump = boat.method_18798().field_1351 <= 0.01;
                double gravity = 0.04D;
                if (boat.method_18798().field_1351 > 0) {
                    commonboat$lastJumpPeakY = boat.method_23318();
                } else if (boat.method_24828() || ((AbstractBoatEntityAccessor) boat).getLocationField() == class_1691.field_7718) {
                    commonboat$lastJumpPeakY = boat.method_23318();
                }
                if (this.client.field_1690.field_1903.method_1434()) {
                    class_1691 currentLocation = ((AbstractBoatEntityAccessor) boat).getLocationField();
                    boolean onSurface = boat.method_24828() || currentLocation == class_1691.field_7718;
                    if (onSurface && canInitiateJump) {
                        double jumpVelocity = boat.method_18798().method_37267() * 1;
                        if (cfg.maxJumpHeight != -1.0) {
                            double maxVerticalVelocity = Math.sqrt(2 * gravity * cfg.maxJumpHeight);
                            if (jumpVelocity > maxVerticalVelocity) {
                                jumpVelocity = maxVerticalVelocity;
                            }
                        }
                        if (jumpVelocity > 0) {
                            boat.method_5762(0.0, jumpVelocity, 0.0);
                            commonboat$lastJumpPeakY = boat.method_23318();
                        }
                    } else if (!onSurface) {
                        double jumpHeight = 1.0;
                        if (cfg.flappyBirdPitchControl) {
                            float pitch = player.method_36455();
                            double fallHeight = commonboat$lastJumpPeakY - boat.method_23318();
                            if (fallHeight < 0.0) fallHeight = 0.0;
                            if (pitch >= 0) {
                                double pitchPercent = pitch / 90.0;
                                jumpHeight = (1.0 - pitchPercent) * fallHeight;
                            } else {
                                double pitchPercent = pitch / -90.0;
                                jumpHeight = (pitchPercent * (5.0 - fallHeight)) + fallHeight;
                            }
                        }

                        double airJumpVelocity = Math.sqrt(2 * gravity * jumpHeight);
                        class_243 currentVel = boat.method_18798();
                        if (currentVel.field_1351 <= 0.0 && airJumpVelocity > 0) {
                            boat.method_18800(currentVel.field_1352, airJumpVelocity, currentVel.field_1350);
                        }
                    }
                }
            }
        }
    }
}