package net.craftish37.commonboat;

import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.minecraft.class_2561;
import net.minecraft.class_304;
import net.minecraft.class_3675;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import org.lwjgl.glfw.GLFW;

public class CommonBoat implements ClientModInitializer {
    private static class_304 toggleKey;
    @Override
    public void onInitializeClient() {
        WorldRenderEvents.AFTER_ENTITIES.register(context -> EasterEggFishHighlighter.onWorldRender(context.matrixStack()));
        Sounds.registerSounds();
        ConfigAccess.get();
        toggleKey = KeyBindingHelper.registerKeyBinding(new class_304(
                "key.commonboat.toggle",
                class_3675.class_307.field_1668,
                GLFW.GLFW_KEY_G,
                "category.commonboat"
        ));
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            while (toggleKey.method_1436()) {
                CommonBoatConfig cfg = ConfigAccess.get();
                boolean wasEnabled = cfg.enabled;
                cfg.enabled = !cfg.enabled;
                cfg.save();
                if (client.field_1724 != null) {
                    if (wasEnabled && cfg.easterEggsEnabled && cfg.handbrakeEnabled) {
                        client.field_1724.method_56078(Sounds.EASTER_EGG_DISABLE_SOUND);
                    }
                    String messageKey = cfg.enabled ? "text.commonboat.status.enabled" : "text.commonboat.status.disabled";
                    client.field_1724.method_7353(class_2561.method_43471(messageKey), true);
                }
            }
        });
    }
}