package net.craftish37.commonboat;

import net.craftish37.commonboat.mixin.TropicalFishEntityAccessor;
import net.minecraft.class_1297;
import net.minecraft.class_1474;
import net.minecraft.class_1921;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.client.render.*;
import org.joml.Matrix4f;
import java.util.Set;

public class EasterEggFishHighlighter {
    private static final class_310 client = class_310.method_1551();
    private static final Set<Integer> UNIQUE_VARIANT_IDS = Set.of(
            65536,      // Clownfish
            459008,     // Triggerfish
            917504,     // Tomato Clownfish
            918273,     // Red Snapper
            918529,     // Red Cichlid
            16778497,   // Ornate Butterflyfish
            50660352,   // Queen Angelfish
            50726144,   // Cotton Candy Betta
            67108865,   // Threadfin
            67110144,   // Goatfish
            67371009,   // Yellow Tang
            67699456,   // Yellowtail Parrotfish
            67764993,   // Dottyback
            101253888,  // Parrotfish
            117441025,  // Moorish Idol
            117441793,  // Butterflyfish
            117506305,  // Anemone
            117899265,  // Black Tang
            118161664,  // Cichlid
            185008129,  // Blue Tang
            234882305,  // Emperor Red Snapper
            235340288   // Red Lipped Blenny
    );
    public static void onWorldRender(class_4587 matrices) {
        var cfg = ConfigAccess.get();
        if (!cfg.enabled || !cfg.easterEggsEnabled || !cfg.leFischeAuChocolatEnabled) return;
        if (client.field_1687 == null || client.field_1724 == null) return;
        class_243 cameraPos = client.field_1773.method_19418().method_19326();
        class_4597.class_4598 provider = client.method_22940().method_23000();
        class_4588 consumer = provider.getBuffer(class_1921.method_49043(1));
        for (class_1297 entity : client.field_1687.method_8335(client.field_1724, client.field_1724.method_5829().method_1014(48))) {
            if (!(entity instanceof class_1474 fish)) continue;
            int variant = fish.method_5841().method_12789(TropicalFishEntityAccessor.getVariantTrackedData());
            if (UNIQUE_VARIANT_IDS.contains(variant)) continue;
            drawBoxOutline(matrices, consumer, cameraPos, fish.method_5829());
        }
        provider.method_22993();
    }
    private static void drawBoxOutline(class_4587 matrices, class_4588 consumer, class_243 cameraPos, class_238 box) {
        Matrix4f matrix = matrices.method_23760().method_23761();

        double minX = box.field_1323 - cameraPos.field_1352;
        double minY = box.field_1322 - cameraPos.field_1351;
        double minZ = box.field_1321 - cameraPos.field_1350;
        double maxX = box.field_1320 - cameraPos.field_1352;
        double maxY = box.field_1325 - cameraPos.field_1351;
        double maxZ = box.field_1324 - cameraPos.field_1350;

        line(consumer, matrix, minX, minY, minZ, maxX, minY, minZ);
        line(consumer, matrix, maxX, minY, minZ, maxX, minY, maxZ);
        line(consumer, matrix, maxX, minY, maxZ, minX, minY, maxZ);
        line(consumer, matrix, minX, minY, maxZ, minX, minY, minZ);

        line(consumer, matrix, minX, maxY, minZ, maxX, maxY, minZ);
        line(consumer, matrix, maxX, maxY, minZ, maxX, maxY, maxZ);
        line(consumer, matrix, maxX, maxY, maxZ, minX, maxY, maxZ);
        line(consumer, matrix, minX, maxY, maxZ, minX, maxY, minZ);

        line(consumer, matrix, minX, minY, minZ, minX, maxY, minZ);
        line(consumer, matrix, maxX, minY, minZ, maxX, maxY, minZ);
        line(consumer, matrix, maxX, minY, maxZ, maxX, maxY, maxZ);
        line(consumer, matrix, minX, minY, maxZ, minX, maxY, maxZ);
    }
    private static void line(class_4588 consumer, Matrix4f matrix, double x1, double y1, double z1, double x2, double y2, double z2) {
        consumer.method_22918(matrix, (float) x1, (float) y1, (float) z1).method_22915(1.0F, 1.0F, 1.0F, 1.0F);
        consumer.method_22918(matrix, (float) x2, (float) y2, (float) z2).method_22915(1.0F, 1.0F, 1.0F, 1.0F);
    }
}