package net.craftish37.commonboat.mixin;

import net.craftish37.commonboat.ConfigAccess;
import net.minecraft.class_10255;
import net.minecraft.class_243;
import net.craftish37.commonboat.CommonBoatConfig;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_10255.class)
public abstract class AbstractBoatEntityAirDragMixin {
    @Inject(method = "updateVelocity", at = @At("TAIL"))
    private void removeAirDrag(CallbackInfo ci) {
        class_10255 boat = (class_10255) (Object) this;
        CommonBoatConfig cfg = ConfigAccess.get();
        boolean isInAir = !boat.method_24828() && !boat.method_5869();
        if (cfg.enabled && cfg.removeAirDrag && isInAir) {
            class_243 currentVelocity = boat.method_18798();
            boat.method_18799(currentVelocity.method_1021(1.0 / 0.99F));
        }
    }
}