package net.craftish37.commonboat.mixin;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import net.craftish37.commonboat.ConfigAccess;
import net.minecraft.class_10255;
import net.minecraft.class_3532;
import net.craftish37.commonboat.CommonBoatConfig;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(class_10255.class)
public class AbstractBoatEntityMixin {
    @ModifyReturnValue(method = "getNearbySlipperiness", at = @At("RETURN"))
    private float modifySlipperiness(float original) {
        CommonBoatConfig cfg = ConfigAccess.get();
        if (!cfg.enabled || !cfg.slipperinessEnabled) return original;
        double minSlip = cfg.slipperiness;
        return class_3532.method_15363(original, (float) minSlip, 1.0F);
    }
}


