package net.craftish37.commonboat.mixin;

import net.craftish37.commonboat.ConfigAccess;
import net.minecraft.class_10255;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_746;
import net.craftish37.commonboat.CommonBoatConfig;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_746.class)
public class BoatJumpMixin {

    @Shadow @Final protected class_310 client;

    @Inject(method = "tick", at = @At("HEAD"))
    private void onTick(CallbackInfo ci) {
        class_746 player = (class_746) (Object) this;
        CommonBoatConfig cfg = ConfigAccess.get();

        if (cfg.enabled && cfg.easterEggsEnabled && cfg.flappyBirdEnabled) {
            if (player.method_5854() instanceof class_10255 boat) {
                boolean canJump = boat.method_18798().field_1351 <= 0.05;

                if (canJump && this.client.field_1690.field_1903.method_1434()) {
                    class_243 velocity = boat.method_18798();
                    double horizontalSpeed = velocity.method_37267();
                    double jumpVelocity = horizontalSpeed * 1;
                    if (jumpVelocity > 0) {
                        boat.method_5762(0.0, jumpVelocity, 0.0);
                    }
                }
            }
        }
    }
}