package net.craftish37.commonboat.mixin;

import net.craftish37.commonboat.ConfigAccess;
import net.minecraft.class_10255;
import net.minecraft.class_10255.class_1691;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_746;
import net.craftish37.commonboat.CommonBoatConfig;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_746.class)
public class BoatJumpMixin {
    @Shadow @Final protected class_310 client;
    @Inject(method = "tick", at = @At("HEAD"))
    private void onTick(CallbackInfo ci) {
        class_746 player = (class_746) (Object) this;
        CommonBoatConfig cfg = ConfigAccess.get();
        if (cfg.enabled && cfg.easterEggsEnabled && cfg.flappyBirdEnabled) {
            if (player.method_5854() instanceof class_10255 boat) {
                boolean canInitiateJump = boat.method_18798().field_1351 <= 0.01;
                double gravity = 0.04D;
                if (this.client.field_1690.field_1903.method_1434()) {
                    class_1691 currentLocation = ((AbstractBoatEntityAccessor) boat).getLocationField();
                    boolean onSurface = boat.method_24828() || currentLocation == class_1691.field_7718;
                    if (onSurface && canInitiateJump) {
                        double jumpVelocity = boat.method_18798().method_37267() * 1;
                        if (cfg.maxJumpHeight != -1.0) {
                            double maxVerticalVelocity = Math.sqrt(2 * gravity * cfg.maxJumpHeight);
                            if (jumpVelocity > maxVerticalVelocity) {
                                jumpVelocity = maxVerticalVelocity;
                            }
                        }
                        if (jumpVelocity > 0) {
                            boat.method_5762(0.0, jumpVelocity, 0.0);
                        }
                    } else if (!onSurface) {
                        double airJumpVelocity = Math.sqrt(2 * gravity * 1.0);
                        class_243 currentVel = boat.method_18798();
                        if (currentVel.field_1351 <= 0.0 && airJumpVelocity > 0) {
                            boat.method_18800(currentVel.field_1352, airJumpVelocity, currentVel.field_1350);
                        }
                    }
                }
            }
        }
    }
}