/*
 * Decompiled with CFR 0.152.
 */
package io.github.lumine1909.customworldheight;

import io.github.lumine1909.customworldheight.WorldListener;
import io.github.lumine1909.customworldheight.config.LevelConfig;
import io.github.lumine1909.customworldheight.data.DataHandler;
import io.github.lumine1909.customworldheight.data.DataHandler_1_20_5;
import io.github.lumine1909.customworldheight.data.DataHandler_1_21;
import io.github.lumine1909.customworldheight.data.DataHandler_1_21_3;
import io.github.lumine1909.customworldheight.data.DataHandler_1_21_6;
import io.github.lumine1909.customworldheight.metrics.Metrics;
import java.io.File;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.server.ServerLoadEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class CustomWorldHeight
extends JavaPlugin
implements Listener {
    public static CustomWorldHeight plugin;
    public static DataHandler dataHandler;

    public static int obtainVersion() {
        try {
            String[] versions = Bukkit.getMinecraftVersion().split("\\.");
            if (versions.length == 2) {
                return Integer.parseInt(versions[1]) * 100;
            }
            if (versions.length == 3) {
                return Integer.parseInt(versions[1]) * 100 + Integer.parseInt(versions[2]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return -1;
    }

    public void onLoad() {
        plugin = this;
        File config = new File(this.getDataFolder(), "config.yml");
        if (!config.exists()) {
            this.getSLF4JLogger().warn("This is the first time you start this plugin. Please restart the server after finish your config!");
            this.saveDefaultConfig();
            Bukkit.getPluginManager().disablePlugin((Plugin)this);
        }
    }

    public void onEnable() {
        int version = CustomWorldHeight.obtainVersion();
        if (version >= 2106) {
            dataHandler = new DataHandler_1_21_6();
        } else if (version >= 2103) {
            dataHandler = new DataHandler_1_21_3();
        } else if (version >= 2100) {
            dataHandler = new DataHandler_1_21();
        } else if (version >= 2005) {
            dataHandler = new DataHandler_1_20_5();
        } else {
            throw new RuntimeException("Unsupported version: " + version);
        }
        LevelConfig.readData(this.getConfig());
        Bukkit.getPluginManager().registerEvents((Listener)new WorldListener(), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this);
        new Metrics((Plugin)this, 26056);
    }

    @EventHandler
    public void onReload(ServerLoadEvent event) {
        if (event.getType() == ServerLoadEvent.LoadType.RELOAD) {
            this.getSLF4JLogger().error("This plugin does not support reload! Use at your own risk!");
        }
    }
}

