/*
 * Decompiled with CFR 0.152.
 */
package io.github.lumine1909.customworldheight.config;

import java.util.HashMap;
import java.util.Map;

public enum BaseDimension {
    OVERWORLD("overworld"),
    NETHER("the_nether"),
    END("the_end"),
    CAVES("overworld_caves"),
    CUSTOM("custom");

    private static final Map<String, BaseDimension> byName;
    private final String name;

    private BaseDimension(String name) {
        this.name = name;
    }

    public static BaseDimension getByName(String name) {
        return byName.getOrDefault(name, CUSTOM);
    }

    public String getName() {
        return this.name;
    }

    static {
        byName = new HashMap<String, BaseDimension>();
        for (BaseDimension dimension : BaseDimension.values()) {
            byName.put(dimension.name, dimension);
        }
    }
}

