/*
 * Decompiled with CFR 0.152.
 */
package io.github.lumine1909.customworldheight.config;

import io.github.lumine1909.customworldheight.CustomWorldHeight;
import io.github.lumine1909.customworldheight.config.BaseDimension;
import io.github.lumine1909.customworldheight.config.Height;
import io.github.lumine1909.customworldheight.data.LevelData;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.function.Function;
import org.bukkit.configuration.file.FileConfiguration;

public class LevelConfig {
    private static final Map<String, String> WORLD_NAME_MAP = new HashMap<String, String>();
    private static final Map<String, String> WORLD_REGEX_MAP = new TreeMap<String, String>();
    private static final Map<String, LevelData<?, ?, ?>> CACHED_DATA = new HashMap();

    public static void readData(FileConfiguration config) {
        WORLD_NAME_MAP.clear();
        WORLD_REGEX_MAP.clear();
        for (String key : config.getKeys(false)) {
            Function<Optional<Integer>, Optional<Integer>> function;
            String name = config.getString(key + ".world", null);
            String regex = config.getString(key + ".regex", "\\w\\b\\w");
            int height = config.getInt(key + ".height", 384);
            int minY = config.getInt(key + ".min-y", -64);
            int logicalHeight = config.getInt(key + ".logical-height", 256);
            String cloudHeight = config.getString(key + ".cloud-height", "empty");
            String dimension = config.getString(key + ".dimension-type", "custom");
            switch (cloudHeight) {
                case "empty": {
                    Function function2 = v -> Optional.empty();
                    function = function2;
                    break;
                }
                case "default": {
                    Function function2 = Function.identity();
                    function = function2;
                    break;
                }
                default: {
                    Function function2;
                    try {
                        int r = Integer.parseInt(cloudHeight);
                        function2 = t -> Optional.of(r);
                        function = function2;
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        function2 = Function.identity();
                        function = function2;
                    }
                }
            }
            Function<Optional<Integer>, Optional<Integer>> cloudHeightFunc = function;
            CustomWorldHeight.plugin.getSLF4JLogger().info("Loaded config: name={}, regex={}, height={}, minY={}, logicalHeight={}, dimension={}, couldHeight={}", new Object[]{name, regex, height, minY, logicalHeight, dimension, cloudHeight});
            Height h = new Height(height, minY, logicalHeight, cloudHeightFunc);
            if (name != null) {
                WORLD_NAME_MAP.put(name, key);
            } else {
                WORLD_REGEX_MAP.put(regex, key);
            }
            CACHED_DATA.put(key, CustomWorldHeight.dataHandler.createData(key, h, BaseDimension.getByName(dimension)));
        }
    }

    public static LevelData<?, ?, ?> getDataOrThrow(String key) {
        return Objects.requireNonNull(CACHED_DATA.get(key));
    }

    public static String checkConfigData(String worldName) {
        if (WORLD_NAME_MAP.containsKey(worldName)) {
            return WORLD_NAME_MAP.get(worldName);
        }
        for (Map.Entry<String, String> entry : WORLD_REGEX_MAP.entrySet()) {
            if (!worldName.matches(entry.getKey())) continue;
            return entry.getValue();
        }
        return null;
    }
}

