/*
 * Decompiled with CFR 0.152.
 */
package io.github.lumine1909.customworldheight.data;

import ca.spottedleaf.moonrise.patches.chunk_system.level.entity.EntityLookup;
import ca.spottedleaf.moonrise.patches.starlight.light.StarLightInterface;
import io.github.lumine1909.customworldheight.config.BaseDimension;
import io.github.lumine1909.customworldheight.config.Height;
import io.github.lumine1909.customworldheight.data.DataHandler;
import io.github.lumine1909.customworldheight.data.LevelData;
import io.github.lumine1909.customworldheight.data.LevelData_1_21;
import io.github.lumine1909.customworldheight.util.ReflectionUtil;
import java.util.IdentityHashMap;
import net.minecraft.core.Holder;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.RegistrationInfo;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.dimension.BuiltinDimensionTypes;
import net.minecraft.world.level.dimension.DimensionType;
import org.bukkit.World;
import org.bukkit.craftbukkit.CraftWorld;

public class DataHandler_1_21
implements DataHandler<DimensionType, Holder<DimensionType>, ResourceKey<DimensionType>> {
    private static final MappedRegistry<DimensionType> REGISTRY = (MappedRegistry)MinecraftServer.getServer().registryAccess().registry(Registries.DIMENSION_TYPE).orElseThrow();

    @Override
    public DimensionType getDimensionType(World world) {
        ServerLevel level = ((CraftWorld)world).getHandle();
        return level.dimensionType();
    }

    @Override
    public ResourceKey<DimensionType> getResourceKey(World world) {
        return (ResourceKey)this.getHolder(world).unwrapKey().orElseThrow();
    }

    @Override
    public Holder<DimensionType> getHolder(World world) {
        ServerLevel level = ((CraftWorld)world).getHandle();
        return level.dimensionTypeRegistration();
    }

    @Override
    public LevelData<DimensionType, ResourceKey<DimensionType>, Holder<DimensionType>> createData(String name, Height height, BaseDimension dimension) {
        LevelData_1_21 levelData = new LevelData_1_21(name, height, dimension);
        switch (dimension) {
            case OVERWORLD: {
                this.processData((LevelData<DimensionType, ResourceKey<DimensionType>, Holder<DimensionType>>)levelData, (Holder<DimensionType>)REGISTRY.getHolderOrThrow(BuiltinDimensionTypes.OVERWORLD));
                break;
            }
            case NETHER: {
                this.processData((LevelData<DimensionType, ResourceKey<DimensionType>, Holder<DimensionType>>)levelData, (Holder<DimensionType>)REGISTRY.getHolderOrThrow(BuiltinDimensionTypes.NETHER));
                break;
            }
            case END: {
                this.processData((LevelData<DimensionType, ResourceKey<DimensionType>, Holder<DimensionType>>)levelData, (Holder<DimensionType>)REGISTRY.getHolderOrThrow(BuiltinDimensionTypes.END));
                break;
            }
            case CAVES: {
                this.processData((LevelData<DimensionType, ResourceKey<DimensionType>, Holder<DimensionType>>)levelData, (Holder<DimensionType>)REGISTRY.getHolderOrThrow(BuiltinDimensionTypes.OVERWORLD_CAVES));
                break;
            }
            case CUSTOM: {
                levelData.accessor = world -> {
                    this.processData((LevelData<DimensionType, ResourceKey<DimensionType>, Holder<DimensionType>>)levelData, this.getHolder((World)world));
                    return (Holder)levelData.getHolder((World)world);
                };
            }
        }
        return levelData;
    }

    @Override
    public void processData(LevelData<DimensionType, ResourceKey<DimensionType>, Holder<DimensionType>> data, Holder<DimensionType> holder) {
        DimensionType old = (DimensionType)holder.value();
        DimensionType newDimension = new DimensionType(old.fixedTime(), old.hasSkyLight(), old.hasCeiling(), old.ultraWarm(), old.natural(), old.coordinateScale(), old.bedWorks(), old.respawnAnchorWorks(), data.getMinY(), data.getHeight(), data.getLogicalHeight(), old.infiniburn(), old.effectsLocation(), old.ambientLight(), old.monsterSettings());
        ResourceKey newResourceKey = ResourceKey.create((ResourceKey)Registries.DIMENSION_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"customworldheight", (String)data.getName()));
        data.setDimensionType(newDimension);
        data.setResourceKey((ResourceKey<DimensionType>)newResourceKey);
        Holder<DimensionType> newHolder = this.register(data.getDimensionType(), data.getResourceKey());
        data.setHolder(newHolder);
    }

    @Override
    public Holder<DimensionType> register(DimensionType dimensionType, ResourceKey<DimensionType> resourceKey) {
        ReflectionUtil.set(MappedRegistry.class, "frozen", REGISTRY, false);
        ReflectionUtil.set(MappedRegistry.class, "unregisteredIntrusiveHolders", REGISTRY, new IdentityHashMap());
        REGISTRY.createIntrusiveHolder((Object)dimensionType);
        Holder.Reference holder = REGISTRY.register(resourceKey, (Object)dimensionType, RegistrationInfo.BUILT_IN);
        ReflectionUtil.set(MappedRegistry.class, "unregisteredIntrusiveHolders", REGISTRY, null);
        ReflectionUtil.set(MappedRegistry.class, "frozen", REGISTRY, true);
        return holder;
    }

    @Override
    public void processWorld(World world, LevelData<DimensionType, ResourceKey<DimensionType>, Holder<DimensionType>> data) {
        ServerLevel level = ((CraftWorld)world).getHandle();
        Holder<DimensionType> holder = data.getHolder(world);
        ReflectionUtil.set(Level.class, "dimensionTypeRegistration", level, holder);
        StarLightInterface lightInterface = level.getLightEngine().starlight$getLightEngine();
        EntityLookup entityLookup = level.moonrise$getEntityLookup();
        int minY = data.getMinY();
        int height = data.getHeight();
        int maxY = minY + height - 1;
        int minSectionY = minY >> 4;
        int maxSectionY = maxY >> 4;
        ReflectionUtil.set(Level.class, "minSection", level, minSectionY);
        ReflectionUtil.set(Level.class, "maxSection", level, maxSectionY);
        ReflectionUtil.set(EntityLookup.class, "minSection", entityLookup, minSectionY);
        ReflectionUtil.set(EntityLookup.class, "maxSection", entityLookup, maxSectionY);
        ReflectionUtil.set(lightInterface.getClass(), "minSection", lightInterface, minSectionY);
        ReflectionUtil.set(lightInterface.getClass(), "maxSection", lightInterface, maxSectionY);
        ReflectionUtil.set(lightInterface.getClass(), "minLightSection", lightInterface, minSectionY - 1);
        ReflectionUtil.set(lightInterface.getClass(), "maxLightSection", lightInterface, maxSectionY + 1);
    }
}

