/*
 * Decompiled with CFR 0.152.
 */
package io.github.lumine1909.customworldheight.data;

import io.github.lumine1909.customworldheight.config.BaseDimension;
import io.github.lumine1909.customworldheight.config.Height;
import java.util.Optional;
import java.util.function.Function;
import org.bukkit.World;

public class LevelData<DimensionType, ResourceKey, Holder> {
    protected final String name;
    protected Height height;
    protected BaseDimension dimension;
    protected DimensionType dimensionType;
    protected ResourceKey resourceKey;
    protected Holder holder;
    protected Function<World, Holder> accessor;

    public LevelData(String name, Height height, BaseDimension dimension) {
        this.name = name;
        this.height = height;
        this.dimension = dimension;
    }

    public String getName() {
        return this.name;
    }

    public int getHeight() {
        return this.height.height();
    }

    public int getMinY() {
        return this.height.minY();
    }

    public int getLogicalHeight() {
        return this.height.logicalHeight();
    }

    public Optional<Integer> getCloudHeight(Optional<Integer> defaultHeight) {
        return this.height.couldHeightFunc().apply(defaultHeight);
    }

    public ResourceKey getResourceKey() {
        return this.resourceKey;
    }

    public void setResourceKey(ResourceKey resourceKey) {
        this.resourceKey = resourceKey;
    }

    public DimensionType getDimensionType() {
        return this.dimensionType;
    }

    public void setDimensionType(DimensionType dimensionType) {
        this.dimensionType = dimensionType;
    }

    public Holder getHolder(World world) {
        if (this.holder != null) {
            return this.holder;
        }
        this.holder = this.accessor.apply(world);
        return this.holder;
    }

    public void setHolder(Holder holder) {
        this.holder = holder;
    }
}

