/*
 * Decompiled with CFR 0.152.
 */
package io.github.lumine1909.customworldheight.util;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.lang.reflect.Field;

public class ReflectionUtil {
    private static final Cache<String, Field> FIELD_CACHE = CacheBuilder.newBuilder().build();

    public static <T> T get(Class<?> clazz, String fieldName, Object instance) {
        try {
            String cacheKey = clazz.getName() + "." + fieldName;
            Field field = (Field)FIELD_CACHE.getIfPresent((Object)cacheKey);
            if (field == null) {
                field = clazz.getDeclaredField(fieldName);
                field.setAccessible(true);
                FIELD_CACHE.put((Object)cacheKey, (Object)field);
            }
            return (T)field.get(instance);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void set(Class<?> clazz, String fieldName, Object instance, Object value) {
        try {
            String cacheKey = clazz.getName() + "." + fieldName;
            Field field = (Field)FIELD_CACHE.getIfPresent((Object)cacheKey);
            if (field == null) {
                field = clazz.getDeclaredField(fieldName);
                field.setAccessible(true);
                FIELD_CACHE.put((Object)cacheKey, (Object)field);
            }
            field.set(instance, value);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

