/*
 * Decompiled with CFR 0.152.
 */
package com.murate.structurecraft.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.murate.structurecraft.util.SelectionHandler;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class StructureMmCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"StructureCraft").then(Commands.m_82127_((String)"MM").then(Commands.m_82129_((String)"controllerId", (ArgumentType)StringArgumentType.string()).executes(StructureMmCommand::executeMmExport))));
    }

    private static int executeMmExport(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerPlayer player = source.m_81375_();
        String controllerId = StringArgumentType.getString(context, (String)"controllerId");
        BlockPos pos1 = SelectionHandler.getFirstPos();
        BlockPos pos2 = SelectionHandler.getSecondPos();
        if (pos1 == null || pos2 == null) {
            source.m_81352_((Component)Component.m_237113_((String)"structurecraft.error.select_area"));
            return 0;
        }
        try {
            String mmStructure = StructureMmCommand.generateMmStructure(player.m_9236_(), pos1, pos2, ResourceLocation.m_135820_((String)controllerId));
            StructureMmCommand.saveToFile(mmStructure, player);
            return 1;
        }
        catch (Exception e) {
            source.m_81352_((Component)Component.m_237113_((String)("Failed to export MM structure: " + e.getMessage())));
            e.printStackTrace();
            return 0;
        }
    }

    private static String generateMmStructure(Level level, BlockPos pos1, BlockPos pos2, ResourceLocation controllerId) {
        int minX = Math.min(pos1.m_123341_(), pos2.m_123341_());
        int minY = Math.min(pos1.m_123342_(), pos2.m_123342_());
        int minZ = Math.min(pos1.m_123343_(), pos2.m_123343_());
        int maxX = Math.max(pos1.m_123341_(), pos2.m_123341_());
        int maxY = Math.max(pos1.m_123342_(), pos2.m_123342_());
        int maxZ = Math.max(pos1.m_123343_(), pos2.m_123343_());
        StringBuilder structure = new StringBuilder("a => {\n    a.layer([\n");
        HashMap<Block, Character> blockMap = new HashMap<Block, Character>();
        AtomicReference<Character> nextKey = new AtomicReference<Character>(Character.valueOf('A'));
        for (int y = minY; y <= maxY; ++y) {
            StringBuilder layer = new StringBuilder("        \"");
            for (int z = minZ; z <= maxZ; ++z) {
                for (int x = minX; x <= maxX; ++x) {
                    BlockPos pos = new BlockPos(x, y, z);
                    BlockState state = level.m_8055_(pos);
                    Block block = state.m_60734_();
                    if (BuiltInRegistries.f_256975_.m_7981_((Object)block).equals((Object)controllerId)) {
                        layer.append('C');
                        continue;
                    }
                    if (!state.m_60795_()) {
                        char key = blockMap.computeIfAbsent(block, k -> {
                            char current = ((Character)nextKey.get()).charValue();
                            nextKey.set(Character.valueOf((char)(current + '\u0001')));
                            return Character.valueOf(current);
                        }).charValue();
                        layer.append(key);
                        continue;
                    }
                    layer.append(' ');
                }
            }
            layer.append("\"");
            structure.append((CharSequence)layer);
            if (y < maxY) {
                structure.append("\n    ]).layer([\n");
                continue;
            }
            structure.append("\n    ])");
        }
        structure.append("\n");
        for (Map.Entry entry : blockMap.entrySet()) {
            if (((Character)entry.getValue()).charValue() == 'C') continue;
            structure.append("    .key(\"").append(entry.getValue()).append("\", {\n");
            structure.append("        block: \"").append(BuiltInRegistries.f_256975_.m_7981_((Object)((Block)entry.getKey()))).append("\"\n");
            structure.append("    })\n");
        }
        structure.append("}");
        return structure.toString();
    }

    private static void saveToFile(String content, ServerPlayer player) throws IOException {
        Path path = Paths.get(".", "kubejs");
        File outputFile = path.resolve("mm_structure.js").toFile();
        Files.createDirectories(path, new FileAttribute[0]);
        Files.writeString(outputFile.toPath(), (CharSequence)content, new OpenOption[0]);
        player.m_213846_((Component)Component.m_237113_((String)("structurecraft.success.export" + outputFile.getAbsolutePath())));
    }
}

