/*
 * Decompiled with CFR 0.152.
 */
package com.murate.structurecraft.event;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.murate.structurecraft.config.StructureCraftModConfig;
import com.murate.structurecraft.util.SelectionHandler;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ClientEvents {
    @SubscribeEvent
    public static void onRenderLevelLast(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS) {
            return;
        }
        BlockPos firstPos = SelectionHandler.getFirstPos();
        BlockPos secondPos = SelectionHandler.getSecondPos();
        if (firstPos != null && secondPos != null) {
            ClientEvents.renderSelectionBox(event.getPoseStack(), firstPos, secondPos);
        }
    }

    private static void renderSelectionBox(PoseStack poseStack, BlockPos pos1, BlockPos pos2) {
        Camera camera = Minecraft.m_91087_().f_91063_.m_109153_();
        Vec3 cameraPos = camera.m_90583_();
        int minX = Math.min(pos1.m_123341_(), pos2.m_123341_());
        int minY = Math.min(pos1.m_123342_(), pos2.m_123342_());
        int minZ = Math.min(pos1.m_123343_(), pos2.m_123343_());
        int maxX = Math.max(pos1.m_123341_(), pos2.m_123341_()) + 1;
        int maxY = Math.max(pos1.m_123342_(), pos2.m_123342_()) + 1;
        int maxZ = Math.max(pos1.m_123343_(), pos2.m_123343_()) + 1;
        VertexConsumer builder = Minecraft.m_91087_().m_91269_().m_110104_().m_6299_(RenderType.m_110504_());
        if (StructureCraftModConfig.RENDER_MODE.get() == StructureCraftModConfig.RenderMode.OUTLINE) {
            ClientEvents.renderOutline(poseStack, builder, minX, minY, minZ, maxX, maxY, maxZ, cameraPos);
        } else {
            ClientEvents.renderFull(poseStack, builder, minX, minY, minZ, maxX, maxY, maxZ, cameraPos);
        }
        Minecraft.m_91087_().m_91269_().m_110104_().m_109912_(RenderType.m_110504_());
    }

    private static void renderOutline(PoseStack poseStack, VertexConsumer builder, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, Vec3 cameraPos) {
        ClientEvents.drawLine(poseStack, builder, minX, minY, minZ, maxX, minY, minZ, cameraPos);
        ClientEvents.drawLine(poseStack, builder, minX, minY, minZ, minX, maxY, minZ, cameraPos);
        ClientEvents.drawLine(poseStack, builder, minX, minY, minZ, minX, minY, maxZ, cameraPos);
        ClientEvents.drawLine(poseStack, builder, maxX, maxY, maxZ, minX, maxY, maxZ, cameraPos);
        ClientEvents.drawLine(poseStack, builder, maxX, maxY, maxZ, maxX, minY, maxZ, cameraPos);
        ClientEvents.drawLine(poseStack, builder, maxX, maxY, maxZ, maxX, maxY, minZ, cameraPos);
        ClientEvents.drawLine(poseStack, builder, minX, maxY, minZ, maxX, maxY, minZ, cameraPos);
        ClientEvents.drawLine(poseStack, builder, minX, maxY, minZ, minX, maxY, maxZ, cameraPos);
        ClientEvents.drawLine(poseStack, builder, minX, minY, maxZ, maxX, minY, maxZ, cameraPos);
        ClientEvents.drawLine(poseStack, builder, maxX, minY, minZ, maxX, maxY, minZ, cameraPos);
        ClientEvents.drawLine(poseStack, builder, maxX, minY, minZ, maxX, minY, maxZ, cameraPos);
        ClientEvents.drawLine(poseStack, builder, minX, minY, maxZ, minX, maxY, maxZ, cameraPos);
    }

    private static void renderFull(PoseStack poseStack, VertexConsumer builder, int minX, int minY, int minZ, int maxX, int maxY, int maxZ, Vec3 cameraPos) {
        int x;
        int z;
        for (int y = minY; y <= maxY; ++y) {
            for (z = minZ; z <= maxZ; ++z) {
                ClientEvents.drawLine(poseStack, builder, minX, y, z, maxX, y, z, cameraPos);
            }
        }
        for (x = minX; x <= maxX; ++x) {
            for (z = minZ; z <= maxZ; ++z) {
                ClientEvents.drawLine(poseStack, builder, x, minY, z, x, maxY, z, cameraPos);
            }
        }
        for (x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                ClientEvents.drawLine(poseStack, builder, x, y, minZ, x, y, maxZ, cameraPos);
            }
        }
    }

    private static void drawLine(PoseStack poseStack, VertexConsumer builder, int x1, int y1, int z1, int x2, int y2, int z2, Vec3 cameraPos) {
        builder.m_252986_(poseStack.m_85850_().m_252922_(), (float)((double)x1 - cameraPos.f_82479_), (float)((double)y1 - cameraPos.f_82480_), (float)((double)z1 - cameraPos.f_82481_)).m_85950_(1.0f, 0.0f, 0.0f, 1.0f).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
        builder.m_252986_(poseStack.m_85850_().m_252922_(), (float)((double)x2 - cameraPos.f_82479_), (float)((double)y2 - cameraPos.f_82480_), (float)((double)z2 - cameraPos.f_82481_)).m_85950_(1.0f, 0.0f, 0.0f, 1.0f).m_5601_(1.0f, 0.0f, 0.0f).m_5752_();
    }
}

