/*
 * Decompiled with CFR 0.152.
 */
package com.murate.structurecraft.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.murate.structurecraft.util.SelectionHandler;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class StructureNbtCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"StructureCraft").then(Commands.m_82127_((String)"NBT").executes(StructureNbtCommand::executeSelect)));
    }

    private static int executeSelect(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        try {
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            ServerPlayer player = source.m_81375_();
            BlockPos pos1 = SelectionHandler.getFirstPos();
            BlockPos pos2 = SelectionHandler.getSecondPos();
            if (pos1 == null || pos2 == null) {
                source.m_81352_((Component)Component.m_237115_((String)"structurecraft.error.select_area"));
                return 0;
            }
            StructureNbtCommand.exportToNbtFile(player.m_9236_(), pos1, pos2, player);
            return 1;
        }
        catch (Exception e) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237110_((String)"structurecraft.error.command_execution", (Object[])new Object[]{e.getMessage()}));
            e.printStackTrace();
            return 0;
        }
    }

    private static void exportToNbtFile(Level level, BlockPos pos1, BlockPos pos2, ServerPlayer player) throws IOException {
        int minX = Math.min(pos1.m_123341_(), pos2.m_123341_());
        int minY = Math.min(pos1.m_123342_(), pos2.m_123342_());
        int minZ = Math.min(pos1.m_123343_(), pos2.m_123343_());
        int maxX = Math.max(pos1.m_123341_(), pos2.m_123341_());
        int maxY = Math.max(pos1.m_123342_(), pos2.m_123342_());
        int maxZ = Math.max(pos1.m_123343_(), pos2.m_123343_());
        CompoundTag rootTag = new CompoundTag();
        ListTag blocksList = new ListTag();
        ListTag palette = new ListTag();
        HashMap<BlockState, Integer> paletteMap = new HashMap<BlockState, Integer>();
        for (BlockPos pos : BlockPos.m_121976_((int)minX, (int)minY, (int)minZ, (int)maxX, (int)maxY, (int)maxZ)) {
            BlockState state = level.m_8055_(pos);
            if (state.m_60795_()) continue;
            CompoundTag blockTag = new CompoundTag();
            ListTag posTag = new ListTag();
            posTag.add((Object)IntTag.m_128679_((int)(pos.m_123341_() - minX)));
            posTag.add((Object)IntTag.m_128679_((int)(pos.m_123342_() - minY)));
            posTag.add((Object)IntTag.m_128679_((int)(pos.m_123343_() - minZ)));
            blockTag.m_128365_("pos", (Tag)posTag);
            int stateId = paletteMap.computeIfAbsent(state, s -> {
                palette.add((Object)NbtUtils.m_129202_((BlockState)s));
                return palette.size() - 1;
            });
            blockTag.m_128405_("state", stateId);
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity != null) {
                CompoundTag beTag = blockEntity.m_187480_();
                blockTag.m_128365_("nbt", (Tag)beTag);
            }
            blocksList.add((Object)blockTag);
        }
        rootTag.m_128365_("blocks", (Tag)blocksList);
        rootTag.m_128365_("palette", (Tag)palette);
        ListTag sizeTag = new ListTag();
        sizeTag.add((Object)IntTag.m_128679_((int)(maxX - minX + 1)));
        sizeTag.add((Object)IntTag.m_128679_((int)(maxY - minY + 1)));
        sizeTag.add((Object)IntTag.m_128679_((int)(maxZ - minZ + 1)));
        rootTag.m_128365_("size", (Tag)sizeTag);
        rootTag.m_128405_("DataVersion", 3465);
        Path path = Paths.get(".", "kubejs");
        File outputFile = path.resolve("structure.nbt").toFile();
        try {
            Files.createDirectories(path, new FileAttribute[0]);
            NbtIo.m_128944_((CompoundTag)rootTag, (File)outputFile);
            player.m_213846_((Component)Component.m_237113_((String)("Structure exported to " + outputFile.getAbsolutePath())));
        }
        catch (IOException e) {
            player.m_213846_((Component)Component.m_237113_((String)("Failed to export structure: " + e.getMessage())));
            throw e;
        }
    }
}

