/*
 * Decompiled with CFR 0.152.
 */
package com.murate.structurecraft.command;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.murate.structurecraft.multiblock.StructureStructure;
import com.murate.structurecraft.util.SelectionHandler;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class StructureJsonCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"StructureCraft").then(Commands.m_82127_((String)"Json").executes(StructureJsonCommand::executeSelect)));
    }

    private static int executeSelect(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        try {
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            ServerPlayer player = source.m_81375_();
            BlockPos pos1 = SelectionHandler.getFirstPos();
            BlockPos pos2 = SelectionHandler.getSecondPos();
            if (pos1 == null || pos2 == null) {
                source.m_81352_((Component)Component.m_237115_((String)"structurecraft.error.select_area"));
                return 0;
            }
            StructureStructure structure = StructureJsonCommand.generateStructure(player.m_9236_(), pos1, pos2);
            StructureJsonCommand.exportToFile(structure, player);
            return 1;
        }
        catch (Exception e) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237110_((String)"structurecraft.error.command_execution", (Object[])new Object[]{e.getMessage()}));
            e.printStackTrace();
            return 0;
        }
    }

    private static StructureStructure generateStructure(Level level, BlockPos pos1, BlockPos pos2) {
        StructureStructure structure = new StructureStructure();
        HashMap<Block, Character> blockMap = new HashMap<Block, Character>();
        char nextChar = 'A';
        BlockPos minPos = new BlockPos(Math.min(pos1.m_123341_(), pos2.m_123341_()), Math.min(pos1.m_123342_(), pos2.m_123342_()), Math.min(pos1.m_123343_(), pos2.m_123343_()));
        for (BlockPos pos : BlockPos.m_121940_((BlockPos)pos1, (BlockPos)pos2)) {
            BlockState state = level.m_8055_(pos);
            Block block = state.m_60734_();
            int x = pos.m_123341_() - minPos.m_123341_();
            int y = pos.m_123342_() - minPos.m_123342_();
            int z = pos.m_123343_() - minPos.m_123343_();
            if (block == Blocks.f_50016_) {
                structure.addBlock(x, y, z, '#');
                continue;
            }
            if (!blockMap.containsKey(block)) {
                char c = nextChar;
                nextChar = (char)(nextChar + 1);
                blockMap.put(block, Character.valueOf(c));
            }
            structure.addBlock(x, y, z, ((Character)blockMap.get(block)).charValue());
        }
        structure.setBlockMap(blockMap);
        return structure;
    }

    private static void exportToFile(StructureStructure structure, ServerPlayer player) {
        JsonArray patternArray = new JsonArray();
        JsonObject keysObject = new JsonObject();
        int maxY = structure.getBlocks().stream().mapToInt(b -> b.y).max().orElse(0);
        int maxZ = structure.getBlocks().stream().mapToInt(b -> b.z).max().orElse(0);
        int maxX = structure.getBlocks().stream().mapToInt(b -> b.x).max().orElse(0);
        for (int y = 0; y <= maxY; ++y) {
            JsonArray layerArray = new JsonArray();
            for (int z = 0; z <= maxZ; ++z) {
                StringBuilder rowBuilder = new StringBuilder();
                int x = 0;
                while (x <= maxX) {
                    int finalX = x++;
                    int finalY = y;
                    int finalZ = z;
                    char symbol = structure.getBlocks().stream().filter(b -> b.x == finalX && b.y == finalY && b.z == finalZ).findFirst().map(b -> Character.valueOf(b.symbol)).orElse(Character.valueOf('#')).charValue();
                    rowBuilder.append(symbol);
                }
                layerArray.add(rowBuilder.toString());
            }
            patternArray.add((JsonElement)layerArray);
        }
        for (Map.Entry<Block, Character> entry : structure.getBlockMap().entrySet()) {
            if (entry.getKey() == Blocks.f_50016_ || entry.getValue().charValue() == '#') continue;
            keysObject.addProperty(String.valueOf(entry.getValue()), BuiltInRegistries.f_256975_.m_7981_((Object)entry.getKey()).toString());
        }
        JsonObject finalObject = new JsonObject();
        finalObject.add("pattern", (JsonElement)patternArray);
        finalObject.add("keys", (JsonElement)keysObject);
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String jsonString = gson.toJson((JsonElement)finalObject);
        jsonString = jsonString.replaceAll("\"pattern\":\\s*", "").replaceAll("\"keys\":\\s*", "").trim();
        jsonString = jsonString.substring(1, jsonString.length() - 1);
        Path path = Paths.get(".", "kubejs");
        path = path.resolve("structure.js");
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            Files.writeString(path, (CharSequence)jsonString, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            player.m_213846_((Component)Component.m_237110_((String)"structurecraft.success.export", (Object[])new Object[]{path}));
        }
        catch (IOException e) {
            player.m_213846_((Component)Component.m_237110_((String)"structurecraft.error.export", (Object[])new Object[]{e.getMessage()}));
        }
    }
}

