/*
 * Decompiled with CFR 0.152.
 */
package com.murate.structurecraft.command;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.murate.structurecraft.multiblock.StructureStructure;
import com.murate.structurecraft.util.SelectionHandler;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class StructureCmCommand {
    private static char nextChar = (char)65;

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"StructureCraft").then(Commands.m_82127_((String)"CM").then(Commands.m_82129_((String)"controllerId", (ArgumentType)StringArgumentType.string()).executes(StructureCmCommand::executeSelect))));
    }

    private static void resetNextChar() {
        nextChar = (char)65;
    }

    private static int executeSelect(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        try {
            StructureCmCommand.resetNextChar();
            CommandSourceStack source = (CommandSourceStack)context.getSource();
            ServerPlayer player = source.m_81375_();
            String controllerId = StringArgumentType.getString(context, (String)"controllerId");
            BlockPos pos1 = SelectionHandler.getFirstPos();
            BlockPos pos2 = SelectionHandler.getSecondPos();
            if (pos1 == null || pos2 == null) {
                source.m_81352_((Component)Component.m_237115_((String)"structurecraft.error.select_area"));
                return 0;
            }
            StructureStructure structure = StructureCmCommand.generateStructure(player.m_9236_(), pos1, pos2, ResourceLocation.m_135820_((String)controllerId));
            StructureCmCommand.exportToFile(structure, player);
            return 1;
        }
        catch (Exception e) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237110_((String)"structurecraft.error.command_execution", (Object[])new Object[]{e.getMessage()}));
            e.printStackTrace();
            return 0;
        }
    }

    private static char getNextSymbol() {
        char symbol = nextChar;
        if ((nextChar = (char)(nextChar + '\u0001')) == 'm') {
            nextChar = (char)(nextChar + '\u0001');
        }
        if (nextChar == '\\') {
            nextChar = (char)(nextChar + '\u0001');
        }
        return symbol;
    }

    private static StructureStructure generateStructure(Level level, BlockPos pos1, BlockPos pos2, ResourceLocation controllerId) {
        StructureStructure structure = new StructureStructure();
        HashMap<String, Character> blockMap = new HashMap<String, Character>();
        BlockPos minPos = new BlockPos(Math.min(pos1.m_123341_(), pos2.m_123341_()), Math.min(pos1.m_123342_(), pos2.m_123342_()), Math.min(pos1.m_123343_(), pos2.m_123343_()));
        for (BlockPos pos : BlockPos.m_121940_((BlockPos)pos1, (BlockPos)pos2)) {
            char symbol;
            BlockState state = level.m_8055_(pos);
            BlockEntity blockEntity = level.m_7702_(pos);
            String blockCommand = state.m_60795_() ? "#" : StructureCmCommand.getBlockCommand(state, blockEntity);
            int x = pos.m_123341_() - minPos.m_123341_();
            int y = pos.m_123342_() - minPos.m_123342_();
            int z = pos.m_123343_() - minPos.m_123343_();
            if (BuiltInRegistries.f_256975_.m_7981_((Object)state.m_60734_()).equals((Object)controllerId)) {
                symbol = 'm';
            } else if (state.m_60795_()) {
                symbol = '#';
            } else {
                if (!blockMap.containsKey(blockCommand)) {
                    blockMap.put(blockCommand, Character.valueOf(StructureCmCommand.getNextSymbol()));
                }
                symbol = ((Character)blockMap.get(blockCommand)).charValue();
            }
            structure.addBlock(x, y, z, symbol);
        }
        structure.setBlockCommandMap(blockMap);
        return structure;
    }

    private static String getBlockCommand(BlockState state, BlockEntity blockEntity) {
        StringBuilder command = new StringBuilder(BuiltInRegistries.f_256975_.m_7981_((Object)state.m_60734_()).toString());
        if (blockEntity != null) {
            CompoundTag nbt = blockEntity.m_187480_();
            nbt.m_128473_("x");
            nbt.m_128473_("y");
            nbt.m_128473_("z");
            if (!nbt.m_128456_()) {
                String nbtString = nbt.toString().replace("\"", "'").replace("\\", "");
                command.append(nbtString);
                return command.toString();
            }
        }
        if (!state.m_61148_().isEmpty()) {
            command.append("[");
            state.m_61148_().forEach((property, value) -> command.append(property.m_61708_()).append("=").append(value).append(","));
            command.setLength(command.length() - 1);
            command.append("]");
        }
        return command.toString();
    }

    private static void exportToFile(StructureStructure structure, ServerPlayer player) {
        JsonArray patternArray = new JsonArray();
        JsonObject keysObject = new JsonObject();
        int maxY = structure.getBlocks().stream().mapToInt(b -> b.y).max().orElse(0);
        int maxZ = structure.getBlocks().stream().mapToInt(b -> b.z).max().orElse(0);
        int maxX = structure.getBlocks().stream().mapToInt(b -> b.x).max().orElse(0);
        for (int y = 0; y <= maxY; ++y) {
            JsonArray layerArray = new JsonArray();
            for (int z = 0; z <= maxZ; ++z) {
                StringBuilder rowBuilder = new StringBuilder();
                int x = 0;
                while (x <= maxX) {
                    int finalX = x++;
                    int finalY = y;
                    int finalZ = z;
                    char symbol = structure.getBlocks().stream().filter(b -> b.x == finalX && b.y == finalY && b.z == finalZ).findFirst().map(b -> Character.valueOf(b.symbol)).orElse(Character.valueOf('#')).charValue();
                    rowBuilder.append(symbol);
                }
                layerArray.add(rowBuilder.toString());
            }
            patternArray.add((JsonElement)layerArray);
        }
        for (Map.Entry<String, Character> entry : structure.getBlockMap().entrySet()) {
            if (entry.getKey().equals("#") || entry.getKey().equals("m")) continue;
            keysObject.addProperty(String.valueOf(entry.getValue()), entry.getKey());
        }
        JsonObject finalObject = new JsonObject();
        finalObject.add("pattern", (JsonElement)patternArray);
        finalObject.add("keys", (JsonElement)keysObject);
        Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        String jsonString = gson.toJson((JsonElement)finalObject);
        jsonString = jsonString.replaceAll("\"pattern\":\\s*", "").replaceAll("\"keys\":\\s*", "").trim();
        jsonString = jsonString.substring(1, jsonString.length() - 1);
        Path path = Paths.get(".", "kubejs");
        path = path.resolve("cm_structure.js");
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            Files.writeString(path, (CharSequence)jsonString, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            player.m_213846_((Component)Component.m_237110_((String)"structurecraft.success.export", (Object[])new Object[]{path}));
        }
        catch (IOException e) {
            player.m_213846_((Component)Component.m_237110_((String)"structurecraft.error.export", (Object[])new Object[]{e.getMessage()}));
        }
    }
}

