/*
 * Decompiled with CFR 0.152.
 */
package com.murate.structurecraft.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.murate.structurecraft.util.SelectionHandler;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;

public class StructureGtmCommand {
    private static char nextChar = (char)65;
    private static final Map<String, String> FUNCTIONAL_BLOCKS = new HashMap<String, String>();
    private static final Map<String, String> SPECIAL_BLOCK_FORMATS;

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"StructureCraft").then(Commands.m_82127_((String)"GTM").then(Commands.m_82129_((String)"controllerId", (ArgumentType)StringArgumentType.string()).executes(StructureGtmCommand::executeGtmExport))));
    }

    private static void resetNextChar() {
        nextChar = (char)65;
    }

    private static char getNextSymbol() {
        char symbol = nextChar;
        if ((nextChar = (char)(nextChar + '\u0001')) == 'K') {
            nextChar = (char)(nextChar + '\u0001');
        }
        if (nextChar == '\\') {
            nextChar = (char)(nextChar + '\u0001');
        }
        return symbol;
    }

    private static int executeGtmExport(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerPlayer player = source.m_81375_();
        String controllerId = StringArgumentType.getString(context, (String)"controllerId");
        BlockPos pos1 = SelectionHandler.getFirstPos();
        BlockPos pos2 = SelectionHandler.getSecondPos();
        if (pos1 == null || pos2 == null) {
            source.m_81352_((Component)Component.m_237115_((String)"structurecraft.error.select_area"));
            return 0;
        }
        try {
            StructureGtmCommand.resetNextChar();
            String gtmStructure = StructureGtmCommand.generateGtmStructure(player.m_9236_(), pos1, pos2, ResourceLocation.m_135820_((String)controllerId));
            StructureGtmCommand.saveToFile(gtmStructure, player);
            return 1;
        }
        catch (Exception e) {
            player.m_213846_((Component)Component.m_237110_((String)"structurecraft.error.export", (Object[])new Object[]{e.getMessage()}));
            e.printStackTrace();
            return 0;
        }
    }

    private static String generateGtmStructure(Level level, BlockPos pos1, BlockPos pos2, ResourceLocation controllerId) {
        int minX = Math.min(pos1.m_123341_(), pos2.m_123341_());
        int minY = Math.min(pos1.m_123342_(), pos2.m_123342_());
        int minZ = Math.min(pos1.m_123343_(), pos2.m_123343_());
        int maxX = Math.max(pos1.m_123341_(), pos2.m_123341_());
        int maxY = Math.max(pos1.m_123342_(), pos2.m_123342_());
        int maxZ = Math.max(pos1.m_123343_(), pos2.m_123343_());
        StringBuilder structure = new StringBuilder("pattern(definition => FactoryBlockPattern.start()\n");
        HashMap<Block, Character> blockMap = new HashMap<Block, Character>();
        HashMap<String, Character> functionalBlockSymbols = new HashMap<String, Character>();
        boolean hasController = false;
        boolean hasAir = false;
        for (int z = minZ; z <= maxZ; ++z) {
            StringBuilder layer = new StringBuilder("  .aisle('");
            for (int y = minY; y <= maxY; ++y) {
                for (int x = minX; x <= maxX; ++x) {
                    char symbol;
                    BlockPos pos = new BlockPos(x, y, z);
                    BlockState state = level.m_8055_(pos);
                    Block block = state.m_60734_();
                    if (state.m_60795_()) {
                        layer.append('#');
                        hasAir = true;
                        continue;
                    }
                    ResourceLocation blockId = ForgeRegistries.BLOCKS.getKey((Object)block);
                    String blockName = blockId.toString();
                    if (blockId.equals((Object)controllerId)) {
                        symbol = 'K';
                        hasController = true;
                    } else if (StructureGtmCommand.isMultiVoltageBlock(blockName)) {
                        String baseBlockName = StructureGtmCommand.getBaseBlockName(blockName);
                        String blockType = baseBlockName.substring(baseBlockName.lastIndexOf(58) + 1);
                        symbol = functionalBlockSymbols.computeIfAbsent(blockType, k -> Character.valueOf(StructureGtmCommand.getNextSymbol())).charValue();
                    } else {
                        symbol = blockMap.computeIfAbsent(block, k -> Character.valueOf(StructureGtmCommand.getNextSymbol())).charValue();
                    }
                    layer.append(symbol);
                }
                if (y >= maxY) continue;
                layer.append("', '");
            }
            layer.append("')\n");
            structure.append((CharSequence)layer);
        }
        if (hasController) {
            structure.append("  .where('K', Predicates.controller(Predicates.blocks(definition.get())))\n");
        }
        StringBuilder whereClauses = new StringBuilder();
        for (Map.Entry entry : blockMap.entrySet()) {
            char symbol = ((Character)entry.getValue()).charValue();
            Block block = (Block)entry.getKey();
            ResourceLocation blockId = BuiltInRegistries.f_256975_.m_7981_((Object)block);
            String blockName = blockId.toString();
            if (SPECIAL_BLOCK_FORMATS.containsKey(blockName)) {
                whereClauses.append(String.format("  .where('%c', %s)\n", Character.valueOf(symbol), SPECIAL_BLOCK_FORMATS.get(blockName)));
                continue;
            }
            whereClauses.append(String.format("  .where('%c', Predicates.blocks('%s'))\n", Character.valueOf(symbol), blockId));
        }
        for (Map.Entry entry : functionalBlockSymbols.entrySet()) {
            String blockType = (String)entry.getKey();
            char symbol = ((Character)entry.getValue()).charValue();
            String predicate = StructureGtmCommand.getFunctionalBlockPredicate(blockType);
            whereClauses.append(String.format("  .where('%c', %s)\n", Character.valueOf(symbol), predicate));
        }
        if (hasAir) {
            whereClauses.append("  .where('#', Predicates.air())\n");
        }
        structure.append((CharSequence)whereClauses);
        structure.append("  .build()\n)");
        return structure.toString();
    }

    private static String getFunctionalBlockPredicate(String baseKey) {
        String ability = FUNCTIONAL_BLOCKS.get(baseKey);
        if (ability == null) {
            throw new IllegalArgumentException("Unknown functional block type: " + baseKey);
        }
        return String.format("Predicates.abilities(%s)", ability);
    }

    private static boolean isMultiVoltageBlock(String blockName) {
        String baseBlockName = StructureGtmCommand.getBaseBlockName(blockName);
        return FUNCTIONAL_BLOCKS.containsKey(baseBlockName.substring(baseBlockName.lastIndexOf(58) + 1));
    }

    private static String getBaseBlockName(String blockName) {
        return blockName.replaceAll("gtceu:(ulv|lv|mv|hv|ev|iv|luv|zpm|uv)_", "gtceu:");
    }

    private static void saveToFile(String content, ServerPlayer player) throws IOException {
        Path path = Paths.get(".", "kubejs");
        File outputFile = path.resolve("gtm_structure.js").toFile();
        try {
            Files.createDirectories(path, new FileAttribute[0]);
            Files.writeString(outputFile.toPath(), (CharSequence)content, new OpenOption[0]);
            player.m_213846_((Component)Component.m_237110_((String)"structurecraft.success.export", (Object[])new Object[]{outputFile.getAbsolutePath()}));
        }
        catch (IOException e) {
            player.m_213846_((Component)Component.m_237110_((String)"structurecraft.error.export", (Object[])new Object[]{e.getMessage()}));
        }
    }

    static {
        FUNCTIONAL_BLOCKS.put("input_bus", "PartAbility.IMPORT_ITEMS");
        FUNCTIONAL_BLOCKS.put("output_bus", "PartAbility.EXPORT_ITEMS");
        FUNCTIONAL_BLOCKS.put("input_hatch", "PartAbility.IMPORT_FLUIDS");
        FUNCTIONAL_BLOCKS.put("output_hatch", "PartAbility.EXPORT_FLUIDS");
        FUNCTIONAL_BLOCKS.put("output_hatch_4x", "PartAbility.EXPORT_FLUIDS_4X");
        FUNCTIONAL_BLOCKS.put("input_hatch_4x", "PartAbility.IMPORT_FLUIDS_4X");
        FUNCTIONAL_BLOCKS.put("output_hatch_9x", "PartAbility.EXPORT_FLUIDS_9X");
        FUNCTIONAL_BLOCKS.put("input_hatch_9x", "PartAbility.IMPORT_FLUIDS_9X");
        FUNCTIONAL_BLOCKS.put("energy_input_hatch", "PartAbility.INPUT_ENERGY");
        FUNCTIONAL_BLOCKS.put("energy_output_hatch", "PartAbility.OUTPUT_ENERGY");
        FUNCTIONAL_BLOCKS.put("substation_input_hatch_64a", "PartAbility.SUBSTATION_INPUT_ENERGY");
        FUNCTIONAL_BLOCKS.put("substation_output_hatch_64a", "PartAbility.SUBSTATION_OUTPUT_ENERGY");
        FUNCTIONAL_BLOCKS.put("kinetic_input_box", "PartAbility.INPUT_KINETIC");
        FUNCTIONAL_BLOCKS.put("kinetic_output_box", "PartAbility.OUTPUT_KINETIC");
        FUNCTIONAL_BLOCKS.put("rotor_holder", "PartAbility.ROTOR_HOLDER");
        FUNCTIONAL_BLOCKS.put("steam_input_hatch", "PartAbility.STEAM");
        FUNCTIONAL_BLOCKS.put("steam_input_bus", "PartAbility.STEAM_IMPORT_ITEMS");
        FUNCTIONAL_BLOCKS.put("steam_output_bus", "PartAbility.STEAM_EXPORT_ITEMS");
        FUNCTIONAL_BLOCKS.put("maintenance_hatch", "PartAbility.MAINTENANCE");
        FUNCTIONAL_BLOCKS.put("configurable_maintenance_hatch", "PartAbility.MAINTENANCE");
        FUNCTIONAL_BLOCKS.put("cleaning_maintenance_hatch", "PartAbility.MAINTENANCE");
        FUNCTIONAL_BLOCKS.put("auto_maintenance_hatch", "PartAbility.MAINTENANCE");
        FUNCTIONAL_BLOCKS.put("muffler_hatch", "PartAbility.MUFFLER");
        FUNCTIONAL_BLOCKS.put("fluid_passthrough_hatch", "PartAbility.PASSTHROUGH_HATCH");
        FUNCTIONAL_BLOCKS.put("item_passthrough_hatch", "PartAbility.PASSTHROUGH_HATCH");
        FUNCTIONAL_BLOCKS.put("parallel_hatch", "PartAbility.PARALLEL_HATCH");
        FUNCTIONAL_BLOCKS.put("256a_laser_target_hatch", "PartAbility.INPUT_LASER");
        FUNCTIONAL_BLOCKS.put("1024a_laser_target_hatch", "PartAbility.INPUT_LASER");
        FUNCTIONAL_BLOCKS.put("4096a_laser_target_hatch", "PartAbility.INPUT_LASER");
        FUNCTIONAL_BLOCKS.put("256a_laser_source_hatch", "PartAbility.OUTPUT_LASER");
        FUNCTIONAL_BLOCKS.put("1024a_laser_source_hatch", "PartAbility.OUTPUT_LASER");
        FUNCTIONAL_BLOCKS.put("4096a_laser_source_hatch", "PartAbility.OUTPUT_LASER");
        FUNCTIONAL_BLOCKS.put("computation_receiver_hatch", "PartAbility.COMPUTATION_DATA_RECEPTION");
        FUNCTIONAL_BLOCKS.put("computation_transmitter_hatch", "PartAbility.COMPUTATION_DATA_TRANSMISSION");
        FUNCTIONAL_BLOCKS.put("data_receiver_hatch", "PartAbility.OPTICAL_DATA_RECEPTION");
        FUNCTIONAL_BLOCKS.put("data_transmitter_hatch", "PartAbility.OPTICAL_DATA_TRANSMISSION");
        FUNCTIONAL_BLOCKS.put("data_access_hatch", "PartAbility.DATA_ACCESS");
        FUNCTIONAL_BLOCKS.put("advanced_data_access_hatch", "PartAbility.DATA_ACCESS");
        FUNCTIONAL_BLOCKS.put("hpca_empty_component", "PartAbility.HPCA_COMPONENT");
        FUNCTIONAL_BLOCKS.put("hpca_computation_component", "PartAbility.HPCA_COMPONENT");
        FUNCTIONAL_BLOCKS.put("hpca_advanced_computation_component", "PartAbility.HPCA_COMPONENT");
        FUNCTIONAL_BLOCKS.put("hpca_heat_sink_component", "PartAbility.HPCA_COMPONENT");
        FUNCTIONAL_BLOCKS.put("hpca_active_cooler_component", "PartAbility.HPCA_COMPONENT");
        FUNCTIONAL_BLOCKS.put("hpca_bridge_component", "PartAbility.HPCA_COMPONENT");
        FUNCTIONAL_BLOCKS.put("object_holder", "PartAbility.OBJECT_HOLDER");
        SPECIAL_BLOCK_FORMATS = new HashMap<String, String>();
        SPECIAL_BLOCK_FORMATS.put("gtceu:normal_laser_pipe", "Predicates.blocks(GTBlocks.LASER_PIPES.get())");
        SPECIAL_BLOCK_FORMATS.put("gtceu:normal_optical_pipe", "Predicates.blocks(GTBlocks.OPTICAL_PIPES.get())");
        SPECIAL_BLOCK_FORMATS.put("gtceu:wood_wall", "Predicates.blocks(GTBlocks.CASING_WOOD_WALL.get())");
        SPECIAL_BLOCK_FORMATS.put("gtceu:coke_oven_bricks", "Predicates.blocks(GTBlocks.CASING_COKE_BRICKS.get())");
        SPECIAL_BLOCK_FORMATS.put("gtceu:steam_machine_casing", "Predicates.blocks(GTBlocks.CASING_PRIMITIVE_BRICKS.get())");
        SPECIAL_BLOCK_FORMATS.put("gtceu:bronze_brick_casing", "Predicates.blocks(GTBlocks.CASING_BRONZE_BRICKS.get())");
        SPECIAL_BLOCK_FORMATS.put("gtceu:heatproof_machine_casing", "Predicates.blocks(GTBlocks.CASING_INVAR_HEATPROOF.get())");
        SPECIAL_BLOCK_FORMATS.put("gtceu:frostproof_machine_casing", "Predicates.blocks(GTBlocks.CASING_ALUMINIUM_FROSTPROOF.get())");
        SPECIAL_BLOCK_FORMATS.put("gtceu:solid_machine_casing", "Predicates.blocks(GTBlocks.CASING_STEEL_SOLID.get())");
        SPECIAL_BLOCK_FORMATS.put("gtceu:clean_machine_casing", "Predicates.blocks(GTBlocks.CASING_STAINLESS_CLEAN.get())");
        SPECIAL_BLOCK_FORMATS.put("gtceu:stable_machine_casing", "Predicates.blocks(GTBlocks.CASING_TITANIUM_STABLE.get())");
        SPECIAL_BLOCK_FORMATS.put("gtceu:robust_machine_casing", "Predicates.blocks(GTBlocks.CASING_TUNGSTENSTEEL_ROBUST.get())");
        SPECIAL_BLOCK_FORMATS.put("gtceu:inert_machine_casing", "Predicates.blocks(GTBlocks.CASING_PTFE_INERT.get())");
        SPECIAL_BLOCK_FORMATS.put("gtceu:sturdy_machine_casing", "Predicates.blocks(GTBlocks.CASING_HSSE_STURDY.get())");
        SPECIAL_BLOCK_FORMATS.put("gtceu:palladium_substation", "Predicates.blocks(GTBlocks.CASING_PALLADIUM_SUBSTATION.get())");
        SPECIAL_BLOCK_FORMATS.put("gtceu:tempered_glass", "Predicates.blocks(GTBlocks.CASING_TEMPERED_GLASS.get())");
        SPECIAL_BLOCK_FORMATS.put("gtceu:stainless_evaporation_casing", "Predicates.blocks(GTBlocks.CASING_STAINLESS_EVAPORATION.get())");
        SPECIAL_BLOCK_FORMATS.put("gtceu:assembly_line_grating", "Predicates.blocks(GTBlocks.CASING_GRATE.get())");
        SPECIAL_BLOCK_FORMATS.put("gtceu:assembly_line_unit", "Predicates.blocks(GTBlocks.CASING_ASSEMBLY_CONTROL.get())");
        SPECIAL_BLOCK_FORMATS.put("gtceu:laminated_glass", "Predicates.blocks(GTBlocks.CASING_LAMINATED_GLASS.get())");
        SPECIAL_BLOCK_FORMATS.put("gtceu:assembly_line_casing", "Predicates.blocks(GTBlocks.CASING_ASSEMBLY_LINE.get())");
        SPECIAL_BLOCK_FORMATS.put("gtceu:bronze_gearbox", "Predicates.blocks(GTBlocks.CASING_BRONZE_GEARBOX.get())");
        SPECIAL_BLOCK_FORMATS.put("gtceu:steel_gearbox", "Predicates.blocks(GTBlocks.CASING_STEEL_GEARBOX.get())");
        SPECIAL_BLOCK_FORMATS.put("gtceu:stainless_steel_gearbox", "Predicates.blocks(GTBlocks.CASING_STAINLESS_STEEL_GEARBOX.get())");
        SPECIAL_BLOCK_FORMATS.put("gtceu:titanium_gearbox", "Predicates.blocks(GTBlocks.CASING_TITANIUM_GEARBOX.get())");
        SPECIAL_BLOCK_FORMATS.put("gtceu:tungstensteel_gearbox", "Predicates.blocks(GTBlocks.CASING_TUNGSTENSTEEL_GEARBOX.get())");
        SPECIAL_BLOCK_FORMATS.put("gtceu:steel_turbine_casing", "Predicates.blocks(GTBlocks.CASING_STEEL_TURBINE.get())");
        SPECIAL_BLOCK_FORMATS.put("gtceu:titanium_turbine_casing", "Predicates.blocks(GTBlocks.CASING_TITANIUM_TURBINE.get())");
        SPECIAL_BLOCK_FORMATS.put("gtceu:stainless_steel_turbine_casing", "Predicates.blocks(GTBlocks.CASING_STAINLESS_TURBINE.get())");
        SPECIAL_BLOCK_FORMATS.put("gtceu:tungstensteel_turbine_casing", "Predicates.blocks(GTBlocks.CASING_TUNGSTENSTEEL_TURBINE.get())");
        SPECIAL_BLOCK_FORMATS.put("gtceu:bronze_pipe_casing", "Predicates.blocks(GTBlocks.CASING_BRONZE_PIPE.get())");
        SPECIAL_BLOCK_FORMATS.put("gtceu:steel_pipe_casing", "Predicates.blocks(GTBlocks.CASING_STEEL_PIPE.get())");
        SPECIAL_BLOCK_FORMATS.put("gtceu:titanium_pipe_casing", "Predicates.blocks(GTBlocks.CASING_TITANIUM_PIPE.get())");
        SPECIAL_BLOCK_FORMATS.put("gtceu:tungstensteel_pipe_casing", "Predicates.blocks(GTBlocks.CASING_TUNGSTENSTEEL_PIPE.get())");
        SPECIAL_BLOCK_FORMATS.put("gtceu:ptfe_pipe_casing", "Predicates.blocks(GTBlocks.CASING_POLYTETRAFLUOROETHYLENE_PIPE.get())");
        SPECIAL_BLOCK_FORMATS.put("gtceu:pump_deck", "Predicates.blocks(GTBlocks.CASING_PUMP_DECK.get())");
        SPECIAL_BLOCK_FORMATS.put("gtceu:ulv_machine_casing", "Predicates.blocks(GTBlocks.MACHINE_CASING_ULV.get())");
        SPECIAL_BLOCK_FORMATS.put("gtceu:lv_machine_casing", "Predicates.blocks(GTBlocks.MACHINE_CASING_LV.get())");
        SPECIAL_BLOCK_FORMATS.put("gtceu:mv_machine_casing", "Predicates.blocks(GTBlocks.MACHINE_CASING_MV.get())");
        SPECIAL_BLOCK_FORMATS.put("gtceu:hv_machine_casing", "Predicates.blocks(GTBlocks.MACHINE_CASING_HV.get())");
        SPECIAL_BLOCK_FORMATS.put("gtceu:ev_machine_casing", "Predicates.blocks(GTBlocks.MACHINE_CASING_EV.get())");
        SPECIAL_BLOCK_FORMATS.put("gtceu:iv_machine_casing", "Predicates.blocks(GTBlocks.MACHINE_CASING_IV.get())");
        SPECIAL_BLOCK_FORMATS.put("gtceu:luv_machine_casing", "Predicates.blocks(GTBlocks.MACHINE_CASING_LuV.get())");
        SPECIAL_BLOCK_FORMATS.put("gtceu:zpm_machine_casing", "Predicates.blocks(GTBlocks.MACHINE_CASING_ZPM.get())");
        SPECIAL_BLOCK_FORMATS.put("gtceu:uv_machine_casing", "Predicates.blocks(GTBlocks.MACHINE_CASING_UV.get())");
        SPECIAL_BLOCK_FORMATS.put("gtceu:uhv_machine_casing", "Predicates.blocks(GTBlocks.MACHINE_CASING_UHV.get())");
        SPECIAL_BLOCK_FORMATS.put("gtceu:lv_hermetic_casing", "Predicates.blocks(GTBlocks.HERMETIC_CASING_LV.get())");
        SPECIAL_BLOCK_FORMATS.put("gtceu:mv_hermetic_casing", "Predicates.blocks(GTBlocks.HERMETIC_CASING_MV.get())");
        SPECIAL_BLOCK_FORMATS.put("gtceu:hv_hermetic_casing", "Predicates.blocks(GTBlocks.HERMETIC_CASING_HV.get())");
        SPECIAL_BLOCK_FORMATS.put("gtceu:ev_hermetic_casing", "Predicates.blocks(GTBlocks.HERMETIC_CASING_EV.get())");
        SPECIAL_BLOCK_FORMATS.put("gtceu:iv_hermetic_casing", "Predicates.blocks(GTBlocks.HERMETIC_CASING_IV.get())");
        SPECIAL_BLOCK_FORMATS.put("gtceu:luv_hermetic_casing", "Predicates.blocks(GTBlocks.HERMETIC_CASING_LuV.get())");
        SPECIAL_BLOCK_FORMATS.put("gtceu:zpm_hermetic_casing", "Predicates.blocks(GTBlocks.HERMETIC_CASING_ZPM.get())");
        SPECIAL_BLOCK_FORMATS.put("gtceu:uv_hermetic_casing", "Predicates.blocks(GTBlocks.HERMETIC_CASING_UV.get())");
        SPECIAL_BLOCK_FORMATS.put("gtceu:uhv_hermetic_casing", "Predicates.blocks(GTBlocks.HERMETIC_CASING_UHV.get())");
        SPECIAL_BLOCK_FORMATS.put("gtceu:bronze_brick_casing", "Predicates.blocks(GTBlocks.BRONZE_BRICKS_HULL.get())");
        SPECIAL_BLOCK_FORMATS.put("gtceu:steel_brick_casing", "Predicates.blocks(GTBlocks.STEEL_BRICKS_HULL.get())");
        SPECIAL_BLOCK_FORMATS.put("gtceu:cupronickel_coil_block", "Predicates.blocks(GTBlocks.COIL_CUPRONICKEL.get())");
        SPECIAL_BLOCK_FORMATS.put("gtceu:kanthal_coil_block", "Predicates.blocks(GTBlocks.COIL_KANTHAL.get())");
        SPECIAL_BLOCK_FORMATS.put("gtceu:nichrome_coil_block", "Predicates.blocks(GTBlocks.COIL_NICHROME.get())");
        SPECIAL_BLOCK_FORMATS.put("gtceu:rtm_alloy_coil_block", "Predicates.blocks(GTBlocks.COIL_RTMALLOY.get())");
        SPECIAL_BLOCK_FORMATS.put("gtceu:hssg_coil_block", "Predicates.blocks(GTBlocks.COIL_HSSG.get())");
        SPECIAL_BLOCK_FORMATS.put("gtceu:naquadah_coil_block", "Predicates.blocks(GTBlocks.COIL_NAQUADAH.get())");
        SPECIAL_BLOCK_FORMATS.put("gtceu:trinium_coil_block", "Predicates.blocks(GTBlocks.COIL_TRINIUM.get())");
        SPECIAL_BLOCK_FORMATS.put("gtceu:tritanium_coil_block", "Predicates.blocks(GTBlocks.COIL_TRITANIUM.get())");
        SPECIAL_BLOCK_FORMATS.put("gtceu:empty_tier_i_battery", "Predicates.blocks(GTBlocks.BATTERY_EMPTY_TIER_I.get())");
        SPECIAL_BLOCK_FORMATS.put("gtceu:ev_lapotronic_battery", "Predicates.blocks(GTBlocks.BATTERY_LAPOTRONIC_EV.get())");
        SPECIAL_BLOCK_FORMATS.put("gtceu:iv_lapotronic_battery", "Predicates.blocks(GTBlocks.BATTERY_LAPOTRONIC_IV.get())");
        SPECIAL_BLOCK_FORMATS.put("gtceu:empty_tier_ii_battery", "Predicates.blocks(GTBlocks.BATTERY_EMPTY_TIER_II.get())");
        SPECIAL_BLOCK_FORMATS.put("gtceu:luv_lapotronic_battery", "Predicates.blocks(GTBlocks.BATTERY_LAPOTRONIC_LuV.get())");
        SPECIAL_BLOCK_FORMATS.put("gtceu:zpm_lapotronic_battery", "Predicates.blocks(GTBlocks.BATTERY_LAPOTRONIC_ZPM.get())");
        SPECIAL_BLOCK_FORMATS.put("gtceu:empty_tier_iii_battery", "Predicates.blocks(GTBlocks.BATTERY_EMPTY_TIER_III.get())");
        SPECIAL_BLOCK_FORMATS.put("gtceu:uv_lapotronic_battery", "Predicates.blocks(GTBlocks.BATTERY_LAPOTRONIC_UV.get())");
        SPECIAL_BLOCK_FORMATS.put("gtceu:uhv_ultimate_battery", "Predicates.blocks(GTBlocks.BATTERY_ULTIMATE_UHV.get())");
        SPECIAL_BLOCK_FORMATS.put("gtceu:engine_intake_casing", "Predicates.blocks(GTBlocks.CASING_ENGINE_INTAKE.get())");
        SPECIAL_BLOCK_FORMATS.put("gtceu:extreme_engine_intake_casing", "Predicates.blocks(GTBlocks.CASING_EXTREME_ENGINE_INTAKE.get())");
        SPECIAL_BLOCK_FORMATS.put("gtceu:superconducting_coil", "Predicates.blocks(GTBlocks.SUPERCONDUCTING_COIL.get())");
        SPECIAL_BLOCK_FORMATS.put("gtceu:fusion_coil", "Predicates.blocks(GTBlocks.FUSION_COIL.get())");
        SPECIAL_BLOCK_FORMATS.put("gtceu:fusion_casing", "Predicates.blocks(GTBlocks.FUSION_CASING.get())");
        SPECIAL_BLOCK_FORMATS.put("gtceu:fusion_casing_mk2", "Predicates.blocks(GTBlocks.FUSION_CASING_MK2.get())");
        SPECIAL_BLOCK_FORMATS.put("gtceu:fusion_casing_mk3", "Predicates.blocks(GTBlocks.FUSION_CASING_MK3.get())");
        SPECIAL_BLOCK_FORMATS.put("gtceu:fusion_glass", "Predicates.blocks(GTBlocks.FUSION_GLASS.get())");
        SPECIAL_BLOCK_FORMATS.put("gtceu:plascrete", "Predicates.blocks(GTBlocks.PLASTCRETE.get())");
        SPECIAL_BLOCK_FORMATS.put("gtceu:filter_casing", "Predicates.blocks(GTBlocks.FILTER_CASING.get())");
        SPECIAL_BLOCK_FORMATS.put("gtceu:cleanroom_glass", "Predicates.blocks(GTBlocks.CLEANROOM_GLASS.get())");
        SPECIAL_BLOCK_FORMATS.put("gtceu:computer_casing", "Predicates.blocks(GTBlocks.COMPUTER_CASING.get())");
        SPECIAL_BLOCK_FORMATS.put("gtceu:advanced_computer_casing", "Predicates.blocks(GTBlocks.ADVANCED_COMPUTER_CASING.get())");
        SPECIAL_BLOCK_FORMATS.put("gtceu:computer_heat_vent", "Predicates.blocks(GTBlocks.COMPUTER_HEAT_VENT.get())");
        SPECIAL_BLOCK_FORMATS.put("gtceu:high_power_casing", "Predicates.blocks(GTBlocks.HIGH_POWER_CASING.get())");
        SPECIAL_BLOCK_FORMATS.put("gtceu:powderbarrel", "Predicates.blocks(GTBlocks.POWDERBARREL.get())");
        SPECIAL_BLOCK_FORMATS.put("gtceu:industrial_tnt", "Predicates.blocks(GTBlocks.INDUSTRIAL_TNT.get())");
        SPECIAL_BLOCK_FORMATS.put("gtceu:treated_wood_planks", "Predicates.blocks(GTBlocks.TREATED_WOOD_PLANK.get())");
        SPECIAL_BLOCK_FORMATS.put("gtceu:treated_wood_slab", "Predicates.blocks(GTBlocks.TREATED_WOOD_SLAB.get())");
        SPECIAL_BLOCK_FORMATS.put("gtceu:treated_wood_stairs", "Predicates.blocks(GTBlocks.TREATED_WOOD_STAIRS.get())");
        SPECIAL_BLOCK_FORMATS.put("gtceu:foam", "Predicates.blocks(GTBlocks.FOAM.get())");
        SPECIAL_BLOCK_FORMATS.put("gtceu:petrified_foam", "Predicates.blocks(GTBlocks.PETRIFIED_FOAM.get())");
        SPECIAL_BLOCK_FORMATS.put("gtceu:reinforced_stone", "Predicates.blocks(GTBlocks.REINFORCED_STONE.get())");
        SPECIAL_BLOCK_FORMATS.put("gtceu:nonconducting_casing", "Predicates.blocks(GCyMBlocks.CASING_NONCONDUCTING.get())");
        SPECIAL_BLOCK_FORMATS.put("gtceu:vibration_safe_casing", "Predicates.blocks(GCyMBlocks.CASING_VIBRATION_SAFE.get())");
        SPECIAL_BLOCK_FORMATS.put("gtceu:watertight_casing", "Predicates.blocks(GCyMBlocks.CASING_WATERTIGHT.get())");
        SPECIAL_BLOCK_FORMATS.put("gtceu:secure_maceration_casing", "Predicates.blocks(GCyMBlocks.CASING_SECURE_MACERATION.get())");
        SPECIAL_BLOCK_FORMATS.put("gtceu:high_temperature_smelting_casing", "Predicates.blocks(GCyMBlocks.CASING_HIGH_TEMPERATURE_SMELTING.get())");
        SPECIAL_BLOCK_FORMATS.put("gtceu:laser_safe_engraving_casing", "Predicates.blocks(GCyMBlocks.CASING_LASER_SAFE_ENGRAVING.get())");
        SPECIAL_BLOCK_FORMATS.put("gtceu:large_scale_assembler_casing", "Predicates.blocks(GCyMBlocks.CASING_LARGE_SCALE_ASSEMBLING.get())");
        SPECIAL_BLOCK_FORMATS.put("gtceu:stress_proof_casing", "Predicates.blocks(GCyMBlocks.CASING_STRESS_PROOF.get())");
        SPECIAL_BLOCK_FORMATS.put("gtceu:corrosion_proof_casing", "Predicates.blocks(GCyMBlocks.CASING_CORROSION_PROOF.get())");
        SPECIAL_BLOCK_FORMATS.put("gtceu:reaction_safe_mixing_casing", "Predicates.blocks(GCyMBlocks.CASING_REACTION_SAFE.get())");
        SPECIAL_BLOCK_FORMATS.put("gtceu:atomic_casing", "Predicates.blocks(GCyMBlocks.CASING_ATOMIC.get())");
        SPECIAL_BLOCK_FORMATS.put("gtceu:industrial_steam_casing", "Predicates.blocks(GCyMBlocks.CASING_INDUSTRIAL_STEAM.get())");
        SPECIAL_BLOCK_FORMATS.put("gtceu:slicing_blades", "Predicates.blocks(GCyMBlocks.SLICING_BLADES.get())");
        SPECIAL_BLOCK_FORMATS.put("gtceu:molybdenum_disilicide_coil_block", "Predicates.blocks(GCyMBlocks.MOLYBDENUM_DISILICIDE_COIL_BLOCK.get())");
        SPECIAL_BLOCK_FORMATS.put("gtceu:electrolytic_cell", "Predicates.blocks(GCyMBlocks.ELECTROLYTIC_CELL.get())");
        SPECIAL_BLOCK_FORMATS.put("gtceu:crushing_wheels", "Predicates.blocks(GCyMBlocks.CRUSHING_WHEELS.get())");
        SPECIAL_BLOCK_FORMATS.put("gtceu:heat_vent", "Predicates.blocks(GCyMBlocks.HEAT_VENT.get())");
    }
}

