/*
 * Decompiled with CFR 0.152.
 */
package com.murate.structurecraft.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.murate.structurecraft.util.SelectionHandler;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class StructureMmCommand {
    private static char nextChar = (char)65;

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"StructureCraft").then(Commands.m_82127_((String)"MM").then(Commands.m_82129_((String)"controllerId", (ArgumentType)StringArgumentType.string()).executes(StructureMmCommand::executeMmExport))));
    }

    private static void resetNextChar() {
        nextChar = (char)65;
    }

    private static int executeMmExport(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack source = (CommandSourceStack)context.getSource();
        ServerPlayer player = source.m_81375_();
        String controllerId = StringArgumentType.getString(context, (String)"controllerId");
        BlockPos pos1 = SelectionHandler.getFirstPos();
        BlockPos pos2 = SelectionHandler.getSecondPos();
        if (pos1 == null || pos2 == null) {
            source.m_81352_((Component)Component.m_237115_((String)"structurecraft.error.select_area"));
            return 0;
        }
        try {
            StructureMmCommand.resetNextChar();
            String mmStructure = StructureMmCommand.generateMmStructure(player.m_9236_(), pos1, pos2, ResourceLocation.m_135820_((String)controllerId));
            StructureMmCommand.saveToFile(mmStructure, player);
            return 1;
        }
        catch (Exception e) {
            player.m_213846_((Component)Component.m_237110_((String)"structurecraft.error.export", (Object[])new Object[]{e.getMessage()}));
            e.printStackTrace();
            return 0;
        }
    }

    private static char getNextSymbol() {
        char symbol = nextChar;
        if ((nextChar = (char)(nextChar + '\u0001')) == 'C') {
            nextChar = (char)(nextChar + '\u0001');
        }
        if (nextChar == '\\') {
            nextChar = (char)(nextChar + '\u0001');
        }
        return symbol;
    }

    private static String generateMmStructure(Level level, BlockPos pos1, BlockPos pos2, ResourceLocation controllerId) {
        int y;
        int minX = Math.min(pos1.m_123341_(), pos2.m_123341_());
        int minY = Math.min(pos1.m_123342_(), pos2.m_123342_());
        int minZ = Math.min(pos1.m_123343_(), pos2.m_123343_());
        int maxX = Math.max(pos1.m_123341_(), pos2.m_123341_());
        int maxY = Math.max(pos1.m_123342_(), pos2.m_123342_());
        int maxZ = Math.max(pos1.m_123343_(), pos2.m_123343_());
        boolean invertX = pos1.m_123341_() > pos2.m_123341_();
        boolean invertY = pos1.m_123342_() > pos2.m_123342_();
        boolean invertZ = pos1.m_123343_() > pos2.m_123343_();
        StringBuilder structure = new StringBuilder("layout(a => {\n    a");
        HashMap<Block, Character> blockMap = new HashMap<Block, Character>();
        for (y = minY; y <= maxY; ++y) {
            for (int z = minZ; z <= maxZ; ++z) {
                for (int x = minX; x <= maxX; ++x) {
                    BlockPos pos = new BlockPos(x, y, z);
                    BlockState state = level.m_8055_(pos);
                    Block block = state.m_60734_();
                    if (state.m_60795_() || blockMap.containsKey(block)) continue;
                    if (BuiltInRegistries.f_256975_.m_7981_((Object)block).equals((Object)controllerId)) {
                        blockMap.put(block, Character.valueOf('C'));
                        continue;
                    }
                    blockMap.put(block, Character.valueOf(StructureMmCommand.getNextSymbol()));
                }
            }
        }
        for (y = maxY; y >= minY; --y) {
            int layerY = invertY ? maxY - (y - minY) : y - minY;
            structure.append(".layer([\n");
            for (int z = minZ; z <= maxZ; ++z) {
                int rowZ = invertZ ? maxZ - (z - minZ) : z - minZ;
                structure.append("        \"");
                for (int x = minX; x <= maxX; ++x) {
                    int colX = invertX ? maxX - (x - minX) : x - minX;
                    BlockPos pos = new BlockPos(invertX ? maxX - (colX - minX) : minX + colX, invertY ? maxY - (layerY - minY) : minY + layerY, invertZ ? maxZ - (rowZ - minZ) : minZ + rowZ);
                    BlockState state = level.m_8055_(pos);
                    Block block = state.m_60734_();
                    if (state.m_60795_()) {
                        structure.append(' ');
                        continue;
                    }
                    structure.append(blockMap.get(block));
                }
                structure.append("\"");
                if (z < maxZ) {
                    structure.append(",");
                }
                structure.append("\n");
            }
            structure.append("    ])");
            if (y >= maxY) continue;
            structure.append("\n    ");
        }
        for (Map.Entry entry : blockMap.entrySet()) {
            if (((Character)entry.getValue()).charValue() == 'C') continue;
            structure.append("\n    .key(\"").append(entry.getValue()).append("\", {\n");
            structure.append("        block: \"").append(BuiltInRegistries.f_256975_.m_7981_((Object)((Block)entry.getKey()))).append("\"\n");
            structure.append("    })");
        }
        structure.append("\n})");
        return structure.toString();
    }

    private static void saveToFile(String content, ServerPlayer player) throws IOException {
        Path path = Paths.get(".", "kubejs");
        File outputFile = path.resolve("mm_structure.js").toFile();
        try {
            Files.createDirectories(path, new FileAttribute[0]);
            Files.writeString(outputFile.toPath(), (CharSequence)content, new OpenOption[0]);
            player.m_213846_((Component)Component.m_237110_((String)"structurecraft.success.export", (Object[])new Object[]{outputFile.getAbsolutePath()}));
        }
        catch (IOException e) {
            player.m_213846_((Component)Component.m_237110_((String)"structurecraft.error.export", (Object[])new Object[]{e.getMessage()}));
        }
    }
}

