/*
 * Decompiled with CFR 0.152.
 */
package net.grilledham.iceball.entity;

import java.util.List;
import net.grilledham.iceball.registry.EntityRegistry;
import net.grilledham.iceball.registry.ItemRegistry;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1316;
import net.minecraft.class_1480;
import net.minecraft.class_1657;
import net.minecraft.class_1690;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1928;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_4048;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import net.minecraft.class_7094;
import net.minecraft.class_9282;
import net.minecraft.class_9334;
import net.minecraft.class_9817;
import org.jetbrains.annotations.Nullable;

public class BigBouncyBallEntity
extends class_1297
implements class_9817,
class_1316 {
    private static final double SQRT_2 = Math.sqrt(2.0);
    protected static final class_2940<Integer> DAMAGE_WOBBLE_TICKS = class_2945.method_12791(BigBouncyBallEntity.class, (class_2941)class_2943.field_13327);
    protected static final class_2940<Integer> DAMAGE_WOBBLE_SIDE = class_2945.method_12791(BigBouncyBallEntity.class, (class_2941)class_2943.field_13327);
    protected static final class_2940<Float> DAMAGE_WOBBLE_STRENGTH = class_2945.method_12791(BigBouncyBallEntity.class, (class_2941)class_2943.field_13320);
    protected static final class_2940<Integer> BALL_COLOR = class_2945.method_12791(BigBouncyBallEntity.class, (class_2941)class_2943.field_13327);
    protected static final class_2940<Byte> ANIMATIONS = class_2945.method_12791(BigBouncyBallEntity.class, (class_2941)class_2943.field_13319);
    public final class_7094 smallBounceAnimationState = new class_7094();
    public final class_7094 bigBounceAnimationState = new class_7094();
    private boolean moveForward = false;
    private boolean moveBack = false;
    private boolean moveLeft = false;
    private boolean moveRight = false;
    private boolean chargingJump = false;
    private int jumpStrength = 0;
    private int chargingTicks = 0;
    private int animationTicks = 0;
    private int lerpTicks;
    private class_9817.class_9818 leashData;

    public BigBouncyBallEntity(class_1299<? extends BigBouncyBallEntity> type, class_1937 world) {
        super(type, world);
    }

    public BigBouncyBallEntity(class_1937 world, double x, double y, double z) {
        this(EntityRegistry.BIG_BOUNCY_BALL_ENTITY, world);
        this.method_5814(x, y, z);
        this.field_6014 = x;
        this.field_6036 = y;
        this.field_5969 = z;
    }

    public boolean method_64397(class_3218 world, class_1282 source, float amount) {
        boolean bl;
        if (this.method_73183().method_8608() || this.method_31481()) {
            return true;
        }
        if (this.method_64421(source)) {
            return false;
        }
        this.setDamageWobbleSide(-this.getDamageWobbleSide());
        this.setDamageWobbleTicks(10);
        this.method_5785();
        this.setDamageWobbleStrength(this.getDamageWobbleStrength() + amount * 10.0f);
        this.method_32875((class_6880)class_5712.field_28736, source.method_5529());
        boolean bl2 = bl = source.method_5529() instanceof class_1657 && ((class_1657)source.method_5529()).method_31549().field_7477;
        if (!bl && this.getDamageWobbleStrength() > 40.0f || this.shouldAlwaysKill(source)) {
            this.killAndDropSelf(world, source);
        } else if (bl) {
            this.method_31472();
        }
        return true;
    }

    boolean shouldAlwaysKill(class_1282 source) {
        return false;
    }

    public void killAndDropItem(class_3218 world, class_1792 selfAsItem) {
        this.method_5768(world);
        if (!world.method_64395().method_8355(class_1928.field_19393)) {
            return;
        }
        class_1799 itemStack = new class_1799((class_1935)selfAsItem);
        itemStack.method_57379(class_9334.field_49631, (Object)this.method_5797());
        if (this.getBallColor() != -7807608) {
            itemStack.method_57379(class_9334.field_49644, (Object)new class_9282(this.getBallColor() & 0xFFFFFF));
        }
        this.method_5775(world, itemStack);
    }

    protected void method_5693(class_2945.class_9222 builder) {
        builder.method_56912(DAMAGE_WOBBLE_TICKS, (Object)0);
        builder.method_56912(DAMAGE_WOBBLE_SIDE, (Object)1);
        builder.method_56912(DAMAGE_WOBBLE_STRENGTH, (Object)Float.valueOf(0.0f));
        builder.method_56912(BALL_COLOR, (Object)-7807608);
        builder.method_56912(ANIMATIONS, (Object)0);
    }

    public void setDamageWobbleTicks(int damageWobbleTicks) {
        this.field_6011.method_12778(DAMAGE_WOBBLE_TICKS, (Object)damageWobbleTicks);
    }

    public void setDamageWobbleSide(int damageWobbleSide) {
        this.field_6011.method_12778(DAMAGE_WOBBLE_SIDE, (Object)damageWobbleSide);
    }

    public void setDamageWobbleStrength(float damageWobbleStrength) {
        this.field_6011.method_12778(DAMAGE_WOBBLE_STRENGTH, (Object)Float.valueOf(damageWobbleStrength));
    }

    public void setSmallBounce(boolean smallBounce) {
        if (smallBounce) {
            this.field_6011.method_12778(ANIMATIONS, (Object)((byte)((Byte)this.field_6011.method_12789(ANIMATIONS) | 1)));
        } else {
            this.field_6011.method_12778(ANIMATIONS, (Object)((byte)((Byte)this.field_6011.method_12789(ANIMATIONS) & 2)));
        }
    }

    public void setBigBounce(boolean bigBounce) {
        if (bigBounce) {
            this.field_6011.method_12778(ANIMATIONS, (Object)((byte)((Byte)this.field_6011.method_12789(ANIMATIONS) | 2)));
        } else {
            this.field_6011.method_12778(ANIMATIONS, (Object)((byte)((Byte)this.field_6011.method_12789(ANIMATIONS) & 1)));
        }
    }

    public float getDamageWobbleStrength() {
        return ((Float)this.field_6011.method_12789(DAMAGE_WOBBLE_STRENGTH)).floatValue();
    }

    public int getDamageWobbleTicks() {
        return (Integer)this.field_6011.method_12789(DAMAGE_WOBBLE_TICKS);
    }

    public int getDamageWobbleSide() {
        return (Integer)this.field_6011.method_12789(DAMAGE_WOBBLE_SIDE);
    }

    public boolean isSmallBounce() {
        return ((Byte)this.field_6011.method_12789(ANIMATIONS) & 1) > 0;
    }

    public boolean isBigBounce() {
        return ((Byte)this.field_6011.method_12789(ANIMATIONS) & 2) > 0;
    }

    protected void killAndDropSelf(class_3218 world, class_1282 source) {
        this.killAndDropItem(world, this.asItem());
    }

    public boolean method_30949(class_1297 other) {
        return class_1690.method_64486((class_1297)this, (class_1297)other);
    }

    public boolean method_30948(@Nullable class_1297 entity) {
        return true;
    }

    public boolean method_5810() {
        return true;
    }

    protected class_243 method_52533(class_1297 passenger, class_4048 dimensions, float scaleFactor) {
        if (this.smallBounceAnimationState.method_41327()) {
            return super.method_52533(passenger, dimensions, scaleFactor).method_1023(0.0, Math.sin(Math.PI * (double)((float)this.smallBounceAnimationState.method_61400((float)this.field_6012) / 250.0f)) / 4.0, 0.0);
        }
        if (this.bigBounceAnimationState.method_41327()) {
            if (this.bigBounceAnimationState.method_61400((float)this.field_6012) >= 750L) {
                return super.method_52533(passenger, dimensions, scaleFactor);
            }
            if (this.bigBounceAnimationState.method_61400((float)this.field_6012) >= 500L) {
                return super.method_52533(passenger, dimensions, scaleFactor).method_1031(0.0, Math.sin(Math.PI * (double)((float)(this.bigBounceAnimationState.method_61400((float)this.field_6012) - 500L) / 250.0f)), 0.0);
            }
            return super.method_52533(passenger, dimensions, scaleFactor).method_1023(0.0, (double)((float)this.bigBounceAnimationState.method_61400((float)this.field_6012) / 500.0f), 0.0);
        }
        return super.method_52533(passenger, dimensions, scaleFactor);
    }

    public boolean method_5863() {
        return !this.method_31481();
    }

    public void method_5773() {
        class_243 prevPos;
        if (this.method_5805()) {
            ++this.field_6012;
        }
        if (this.getDamageWobbleTicks() > 0) {
            this.setDamageWobbleTicks(this.getDamageWobbleTicks() - 1);
        }
        if (this.getDamageWobbleStrength() > 0.0f) {
            this.setDamageWobbleStrength(this.getDamageWobbleStrength() - 1.0f);
        }
        super.method_5773();
        if (this.method_66247()) {
            this.lerpTicks = 0;
            this.method_43391(this.method_23317(), this.method_23318(), this.method_23321());
        }
        if (this.lerpTicks > 0) {
            this.method_52532(this.lerpTicks, this.method_23317(), this.method_23318(), this.method_23321(), this.method_36454(), this.method_36455());
            --this.lerpTicks;
        }
        if (this.method_66247()) {
            float forward = 0.0f;
            float strafe = 0.0f;
            if (!this.chargingJump) {
                if (this.moveForward) {
                    forward += 1.0f;
                }
                if (this.moveBack) {
                    forward -= 1.0f;
                }
                if (this.moveLeft) {
                    strafe -= 1.0f;
                }
                if (this.moveRight) {
                    strafe += 1.0f;
                }
            } else if (this.method_24828()) {
                ++this.chargingTicks;
                if (this.chargingTicks >= 10) {
                    this.chargingJump = false;
                    float jumpStrength = this.jumpStrength >= 90 ? 1.0f : 0.4f + 0.4f * (float)this.jumpStrength / 90.0f;
                    class_243 velocity = this.method_18798();
                    double dx = (double)jumpStrength * 2.5 * Math.cos(Math.toRadians(this.method_36454() + 90.0f));
                    double dz = (double)jumpStrength * 2.5 * Math.sin(Math.toRadians(this.method_36454() + 90.0f));
                    this.method_18800(velocity.field_1352 + dx, velocity.field_1351 + (double)jumpStrength * 2.2, velocity.field_1350 + dz);
                }
            }
            double dx = (double)forward * Math.cos(Math.toRadians(this.method_36454() + 90.0f));
            double dz = (double)forward * Math.sin(Math.toRadians(this.method_36454() + 90.0f));
            dx -= (double)strafe * Math.cos(Math.toRadians(this.method_36454()));
            dz -= (double)strafe * Math.sin(Math.toRadians(this.method_36454()));
            if (strafe != 0.0f && forward != 0.0f) {
                dx /= SQRT_2;
                dz /= SQRT_2;
            }
            dx *= 0.7;
            dz *= 0.7;
            if (this.method_24828()) {
                this.method_18800(this.method_18798().field_1352 * 0.5 + dx * 0.5, this.method_18798().field_1351, this.method_18798().method_10215() * 0.5 + dz * 0.5);
            } else {
                this.method_18800(this.method_18798().field_1352 * 0.95 + dx * 0.05, this.method_18798().field_1351, this.method_18798().method_10215() * 0.95 + dz * 0.05);
            }
            double d = this.method_56989();
            class_243 vec3d = this.method_18798();
            double vy = Math.max(vec3d.field_1351, -2.0);
            this.method_18800(vec3d.field_1352, vy + d, vec3d.field_1350);
            this.method_5784(class_1313.field_6308, this.method_18798());
        } else {
            this.method_18799(class_243.field_1353);
        }
        this.method_61409();
        List list = this.method_73183().method_8333((class_1297)this, this.method_5829().method_1009((double)0.2f, (double)-0.01f, (double)0.2f), class_1301.method_5911((class_1297)this));
        if (!list.isEmpty()) {
            boolean bl = !this.method_73183().method_8608() && !(this.method_5642() instanceof class_1657);
            for (class_1297 entity : list) {
                if (entity.method_5626((class_1297)this)) continue;
                if (bl && this.method_5685().isEmpty() && !entity.method_5765() && entity instanceof class_1309 && !(entity instanceof class_1480) && !(entity instanceof class_1657)) {
                    entity.method_5804((class_1297)this);
                    continue;
                }
                this.method_5697(entity);
            }
        }
        if (this.method_5782() && this.isBigBounce() && (this.method_24828() || this.animationTicks >= 10)) {
            this.smallBounceAnimationState.method_41325();
            this.bigBounceAnimationState.method_41324(this.field_6012);
            if (this.bigBounceAnimationState.method_61400((float)this.field_6012) >= 1000L) {
                this.setBigBounce(false);
            }
        } else {
            this.bigBounceAnimationState.method_41325();
            if (this.isSmallBounce()) {
                this.smallBounceAnimationState.method_41324(this.field_6012);
            } else {
                this.smallBounceAnimationState.method_41325();
            }
        }
        if (this.isBigBounce() && (this.method_24828() || this.animationTicks >= 10)) {
            ++this.animationTicks;
            if (this.animationTicks >= 20) {
                this.animationTicks = 0;
                this.setBigBounce(false);
            }
        }
        this.setSmallBounce((prevPos = new class_243(this.field_6014, 0.0, this.field_5969)).method_1022(this.method_73189().method_18805(1.0, 0.0, 1.0)) > 0.1 && this.method_24828());
    }

    public void setInputs(boolean moveForward, boolean moveBack, boolean moveLeft, boolean moveRight) {
        this.moveForward = moveForward;
        this.moveBack = moveBack;
        this.moveLeft = moveLeft;
        this.moveRight = moveRight;
    }

    public class_1269 method_5688(class_1657 player, class_1268 hand) {
        class_1269 actionResult = super.method_5688(player, hand);
        if (actionResult != class_1269.field_5811) {
            return actionResult;
        }
        if (player.method_21823()) {
            return class_1269.field_5811;
        }
        if (!this.method_73183().method_8608()) {
            return player.method_5804((class_1297)this) ? class_1269.field_21466 : class_1269.field_5811;
        }
        return class_1269.field_5811;
    }

    protected double method_7490() {
        return -0.2;
    }

    public float method_49476() {
        return 1.0f;
    }

    public boolean method_5747(double fallDistance, float damageMultiplier, class_1282 damageSource) {
        return false;
    }

    @Nullable
    public class_1309 method_5642() {
        class_1297 entity = this.method_31483();
        return entity instanceof class_1309 ? (class_1309)entity : super.method_5642();
    }

    public void method_5644(class_1297 passenger) {
        this.method_36456(passenger.method_5791());
    }

    protected void method_5749(class_11368 nbt) {
        this.method_60967(nbt);
        this.setBallColor(nbt.method_71424("Color", -7807608));
    }

    protected void method_5652(class_11372 nbt) {
        this.method_60962(nbt, this.leashData);
        nbt.method_71465("Color", this.getBallColor());
    }

    @Nullable
    public class_9817.class_9818 method_60955() {
        return this.leashData;
    }

    public void method_60960(@Nullable class_9817.class_9818 leashData) {
        this.leashData = leashData;
    }

    public class_1792 asItem() {
        return ItemRegistry.BIG_BOUNCY_BALL_ITEM;
    }

    public int getBallColor() {
        return (Integer)this.field_6011.method_12789(BALL_COLOR);
    }

    public void setBallColor(int rgb) {
        this.field_6011.method_12778(BALL_COLOR, (Object)(0xFF000000 | rgb));
    }

    public void method_6154(int strength) {
        this.chargingJump = true;
        this.chargingTicks = 0;
        this.animationTicks = 0;
        this.setBigBounce(true);
        this.jumpStrength = strength;
    }

    public boolean method_6153() {
        return this.method_5642() != null;
    }

    public void method_6155(int height) {
        this.chargingJump = true;
        this.chargingTicks = 0;
        this.animationTicks = 0;
        this.setBigBounce(true);
    }

    public void method_6156() {
    }
}

