/*
 * Decompiled with CFR 0.152.
 */
package net.grilledham.iceball.item;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import net.fabricmc.fabric.api.item.v1.EnchantingContext;
import net.grilledham.iceball.entity.IceballEntity;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1676;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_239;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_9463;

public class IceballItem
extends class_1792
implements class_9463 {
    private final int damage;
    private final int cooldown;
    private final BiFunction<IceballEntity, class_239, Boolean> onCollide;
    private final Consumer<IceballEntity> onTick;
    private final List<class_5321<class_1887>> primaryEnchants;
    private final List<class_5321<class_1887>> acceptableEnchants;

    IceballItem(class_1792.class_1793 settings, int damage, int cooldown, BiFunction<IceballEntity, class_239, Boolean> onCollide, Consumer<IceballEntity> onTick, List<class_5321<class_1887>> primaryEnchants, List<class_5321<class_1887>> acceptableEnchants) {
        super(settings);
        this.damage = damage;
        this.cooldown = cooldown;
        this.onCollide = onCollide;
        this.onTick = onTick;
        this.primaryEnchants = primaryEnchants;
        this.acceptableEnchants = acceptableEnchants;
    }

    public class_1269 method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 itemStack = user.method_5998(hand);
        world.method_43128(null, user.method_23317(), user.method_23318(), user.method_23321(), class_3417.field_14873, class_3419.field_15254, 0.5f, 0.4f / (world.method_8409().method_43057() * 0.4f + 0.8f));
        user.method_7357().method_62835(itemStack, this.cooldown);
        if (!world.method_8608()) {
            IceballEntity iceballEntity = new IceballEntity(world, (class_1309)user, itemStack, this.damage, this.onCollide, this.onTick);
            iceballEntity.method_16940(itemStack);
            iceballEntity.method_24919((class_1297)user, user.method_36455(), user.method_36454(), 0.0f, 1.5f, 1.0f);
            world.method_8649((class_1297)iceballEntity);
        }
        user.method_7259(class_3468.field_15372.method_14956((Object)this));
        if (!user.method_31549().field_7477) {
            itemStack.method_7934(1);
        }
        return class_1269.field_5812;
    }

    public boolean canBeEnchantedWith(class_1799 stack, class_6880<class_1887> enchantment, EnchantingContext context) {
        switch (context) {
            case PRIMARY: {
                for (class_5321<class_1887> key : this.primaryEnchants) {
                    if (!enchantment.method_40225(key)) continue;
                    return true;
                }
                return super.canBeEnchantedWith(stack, enchantment, context);
            }
            case ACCEPTABLE: {
                for (class_5321<class_1887> key : this.acceptableEnchants) {
                    if (!enchantment.method_40225(key)) continue;
                    return true;
                }
                return super.canBeEnchantedWith(stack, enchantment, context);
            }
        }
        return super.canBeEnchantedWith(stack, enchantment, context);
    }

    public class_1676 method_58648(class_1937 world, class_2374 pos, class_1799 stack, class_2350 direction) {
        IceballEntity iceballEntity = new IceballEntity(world, pos, stack, this.damage, this.onCollide, this.onTick);
        iceballEntity.method_16940(stack);
        return iceballEntity;
    }

    public static class Builder {
        private int damage = 1;
        private int cooldown = 0;
        private BiFunction<IceballEntity, class_239, Boolean> onCollide = (ball, hitResult) -> true;
        private Consumer<IceballEntity> onTick = ball -> {};
        private List<class_5321<class_1887>> primaryEnchants = new ArrayList<class_5321<class_1887>>();
        private List<class_5321<class_1887>> acceptableEnchants = new ArrayList<class_5321<class_1887>>();

        public Builder damage(int damage) {
            this.damage = damage;
            return this;
        }

        public Builder cooldown(int cooldown) {
            this.cooldown = cooldown;
            return this;
        }

        public Builder onCollide(BiFunction<IceballEntity, class_239, Boolean> onCollide) {
            this.onCollide = onCollide;
            return this;
        }

        public Builder onTick(Consumer<IceballEntity> onTick) {
            this.onTick = onTick;
            return this;
        }

        @SafeVarargs
        public final Builder primaryEnchants(class_5321<class_1887> ... enchants) {
            this.primaryEnchants = Arrays.asList(enchants);
            return this;
        }

        @SafeVarargs
        public final Builder acceptableEnchants(class_5321<class_1887> ... enchants) {
            this.acceptableEnchants = Arrays.asList(enchants);
            return this;
        }

        public Function<class_1792.class_1793, IceballItem> build() {
            return settings -> new IceballItem((class_1792.class_1793)settings, this.damage, this.cooldown, this.onCollide, this.onTick, this.primaryEnchants, this.acceptableEnchants);
        }
    }
}

