/*
 * Decompiled with CFR 0.152.
 */
package me.poggercity.staffMode;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class StaffMode
extends JavaPlugin
implements Listener,
CommandExecutor,
TabCompleter {
    private final Set<UUID> staffModePlayers = new HashSet<UUID>();
    private final Set<UUID> visibleStaff = new HashSet<UUID>();
    private final Set<UUID> staffChatEnabled = new HashSet<UUID>();
    private final Map<UUID, ItemStack[]> savedInventories = new HashMap<UUID, ItemStack[]>();
    private final Set<String> staffItemNames = new HashSet<String>(Arrays.asList(String.valueOf(ChatColor.GREEN) + "Tp Compass", String.valueOf(ChatColor.GOLD) + "Gamemode Switcher Wand", String.valueOf(ChatColor.RED) + "Staff mode switcher", String.valueOf(ChatColor.DARK_RED) + "Vanish Switcher"));

    public void onEnable() {
        PluginCommand sc;
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getCommand("staffmode").setExecutor((CommandExecutor)this);
        this.getCommand("staffmode").setTabCompleter((TabCompleter)this);
        PluginCommand sm = this.getCommand("sm");
        if (sm != null) {
            sm.setExecutor((CommandExecutor)this);
            sm.setTabCompleter((TabCompleter)this);
        }
        if ((sc = this.getCommand("staffchat")) != null) {
            sc.setExecutor((CommandExecutor)this);
        }
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            return true;
        }
        Player player = (Player)sender;
        UUID uuid = player.getUniqueId();
        if (label.equalsIgnoreCase("staffmode") || label.equalsIgnoreCase("sm")) {
            if (!player.hasPermission("staffmode.use")) {
                return true;
            }
            if (this.staffModePlayers.contains(uuid)) {
                this.exitStaffMode(player);
            } else {
                this.enterStaffMode(player);
            }
            return true;
        }
        if (label.equalsIgnoreCase("staffchat")) {
            if (!player.hasPermission("staffchat.view")) {
                return true;
            }
            if (this.staffChatEnabled.contains(uuid)) {
                this.staffChatEnabled.remove(uuid);
                player.sendMessage(String.valueOf(ChatColor.RED) + "Staff Chat Disabled.");
            } else {
                this.staffChatEnabled.add(uuid);
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "Staff Chat Enabled. Type any message to send to staff only.");
            }
            return true;
        }
        return false;
    }

    @EventHandler
    public void onPlayerInteract(PlayerInteractEvent e) {
        Player player = e.getPlayer();
        UUID uuid = player.getUniqueId();
        if (!this.staffModePlayers.contains(uuid)) {
            return;
        }
        ItemStack item = e.getItem();
        if (item == null || !item.hasItemMeta()) {
            return;
        }
        String name = item.getItemMeta().getDisplayName();
        if (name.equals(String.valueOf(ChatColor.GREEN) + "Tp Compass")) {
            ArrayList players = new ArrayList(Bukkit.getOnlinePlayers());
            players.remove(player);
            if (!players.isEmpty()) {
                Player target = (Player)players.get(new Random().nextInt(players.size()));
                player.teleport((Entity)target);
                player.sendMessage(String.valueOf(ChatColor.GREEN) + "Teleported to " + target.getName());
            }
        } else if (name.equals(String.valueOf(ChatColor.GOLD) + "Gamemode Switcher Wand")) {
            if (player.getGameMode() == GameMode.CREATIVE) {
                player.setGameMode(GameMode.SPECTATOR);
            } else {
                player.setGameMode(GameMode.CREATIVE);
            }
        } else if (name.equals(String.valueOf(ChatColor.RED) + "Staff mode switcher")) {
            this.exitStaffMode(player);
        } else if (name.equals(String.valueOf(ChatColor.DARK_RED) + "Vanish Switcher")) {
            if (this.visibleStaff.contains(uuid)) {
                this.visibleStaff.remove(uuid);
                Bukkit.getOnlinePlayers().forEach(p -> p.hidePlayer((Plugin)this, player));
                player.sendMessage(String.valueOf(ChatColor.RED) + "You are now vanished.");
            } else {
                this.visibleStaff.add(uuid);
                Bukkit.getOnlinePlayers().forEach(p -> p.showPlayer((Plugin)this, player));
                player.sendMessage(String.valueOf(ChatColor.RED) + "You are now visible.");
            }
        }
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent e) {
        Player joining = e.getPlayer();
        for (UUID uuid : this.staffModePlayers) {
            Player staff;
            if (this.visibleStaff.contains(uuid) || (staff = Bukkit.getPlayer((UUID)uuid)) == null) continue;
            joining.hidePlayer((Plugin)this, staff);
        }
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent e) {
        UUID uuid = e.getPlayer().getUniqueId();
        this.staffModePlayers.remove(uuid);
        this.visibleStaff.remove(uuid);
        this.staffChatEnabled.remove(uuid);
        this.savedInventories.remove(uuid);
    }

    @EventHandler
    public void onItemDrop(PlayerDropItemEvent e) {
        ItemStack item = e.getItemDrop().getItemStack();
        if (item.hasItemMeta() && this.staffItemNames.contains(item.getItemMeta().getDisplayName())) {
            e.setCancelled(true);
        }
    }

    @EventHandler
    public void onStaffChat(AsyncPlayerChatEvent e) {
        Player player = e.getPlayer();
        if (!this.staffChatEnabled.contains(player.getUniqueId())) {
            return;
        }
        e.setCancelled(true);
        String message = String.valueOf(ChatColor.AQUA) + "\u00a7lStaff Chat - " + player.getName() + " - " + String.valueOf(ChatColor.RESET) + e.getMessage();
        for (Player online : Bukkit.getOnlinePlayers()) {
            if (!online.hasPermission("staffchat.view")) continue;
            online.sendMessage(message);
        }
    }

    private void enterStaffMode(final Player player) {
        final UUID uuid = player.getUniqueId();
        this.savedInventories.put(uuid, player.getInventory().getContents());
        this.staffModePlayers.add(uuid);
        this.visibleStaff.remove(uuid);
        player.getInventory().clear();
        player.setGameMode(GameMode.CREATIVE);
        player.setCollidable(false);
        Bukkit.getOnlinePlayers().forEach(p -> p.hidePlayer((Plugin)this, player));
        ItemStack tpCompass = new ItemStack(Material.RECOVERY_COMPASS);
        ItemMeta compassMeta = tpCompass.getItemMeta();
        compassMeta.setDisplayName(String.valueOf(ChatColor.GREEN) + "Tp Compass");
        tpCompass.setItemMeta(compassMeta);
        ItemStack gmSwitcher = new ItemStack(Material.BLAZE_ROD);
        ItemMeta gmMeta = gmSwitcher.getItemMeta();
        gmMeta.setDisplayName(String.valueOf(ChatColor.GOLD) + "Gamemode Switcher Wand");
        gmSwitcher.setItemMeta(gmMeta);
        ItemStack staffExit = new ItemStack(Material.BREEZE_ROD);
        ItemMeta staffExitMeta = staffExit.getItemMeta();
        staffExitMeta.setDisplayName(String.valueOf(ChatColor.RED) + "Staff mode switcher");
        staffExit.setItemMeta(staffExitMeta);
        ItemStack vanishSwitcher = new ItemStack(Material.PRISMARINE_SHARD);
        ItemMeta vanishMeta = vanishSwitcher.getItemMeta();
        vanishMeta.setDisplayName(String.valueOf(ChatColor.DARK_RED) + "Vanish Switcher");
        vanishSwitcher.setItemMeta(vanishMeta);
        player.getInventory().setItem(0, tpCompass);
        player.getInventory().setItem(1, gmSwitcher);
        player.getInventory().setItem(2, staffExit);
        player.getInventory().setItem(3, vanishSwitcher);
        new BukkitRunnable(){

            public void run() {
                if (StaffMode.this.staffModePlayers.contains(uuid)) {
                    if (StaffMode.this.visibleStaff.contains(uuid)) {
                        player.sendActionBar(String.valueOf(ChatColor.GREEN) + "Staff mode " + String.valueOf(ChatColor.RED) + "(people can see you)");
                    } else {
                        player.sendActionBar(String.valueOf(ChatColor.GREEN) + "Staff mode (nobody can see you)");
                    }
                } else {
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)this, 0L, 20L);
    }

    private void exitStaffMode(Player player) {
        UUID uuid = player.getUniqueId();
        this.staffModePlayers.remove(uuid);
        this.visibleStaff.remove(uuid);
        player.getInventory().clear();
        if (this.savedInventories.containsKey(uuid)) {
            player.getInventory().setContents(this.savedInventories.get(uuid));
            this.savedInventories.remove(uuid);
        }
        player.setGameMode(GameMode.SURVIVAL);
        player.setCollidable(true);
        Bukkit.getOnlinePlayers().forEach(p -> p.showPlayer((Plugin)this, player));
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        return Collections.emptyList();
    }
}

