/*
 * Decompiled with CFR 0.152.
 */
package co.crystaldev.alpinecore.framework.ui.event;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;

public abstract class UIEvent {
    private final List<Integer> affectedSlots;

    public UIEvent(@NotNull Iterable<Integer> affectedSlots) {
        this.affectedSlots = ImmutableList.copyOf(affectedSlots);
    }

    public UIEvent(int slot) {
        this.affectedSlots = Collections.singletonList(slot);
    }

    public UIEvent() {
        this.affectedSlots = Collections.emptyList();
    }

    public boolean affectsSlots() {
        return !this.affectedSlots.isEmpty();
    }

    public boolean affectedSlot(int slot) {
        return this.affectedSlots.contains(slot);
    }

    @Generated
    public List<Integer> getAffectedSlots() {
        return this.affectedSlots;
    }
}

