/*
 * Decompiled with CFR 0.152.
 */
package com.cryptomorin.xseries.profiles.objects.transformer;

import com.cryptomorin.xseries.profiles.PlayerProfiles;
import com.cryptomorin.xseries.profiles.objects.Profileable;
import com.google.common.collect.Iterables;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ProfileTransformer {
    @NotNull
    public GameProfile transform(@NotNull Profileable var1, @NotNull GameProfile var2);

    @ApiStatus.Internal
    public boolean canBeCached();

    @NotNull
    public static ProfileTransformer stackable() {
        return RemoveMetadata.INSTANCE;
    }

    @NotNull
    public static ProfileTransformer nonStackable() {
        return MakeNotStackable.INSTANCE;
    }

    @NotNull
    public static ProfileTransformer removeMetadata() {
        return RemoveMetadata.INSTANCE;
    }

    @NotNull
    public static ProfileTransformer includeOriginalValue() {
        return IncludeOriginalValue.INSTANCE;
    }

    public static final class RemoveMetadata
    implements ProfileTransformer {
        private static final RemoveMetadata INSTANCE = new RemoveMetadata();

        @Override
        public GameProfile transform(Profileable profileable, GameProfile profile) {
            PlayerProfiles.removeTimestamp(profile);
            Map props = profile.getProperties().asMap();
            props.remove("XSeries");
            props.remove("OriginalValue");
            return profile;
        }

        @Override
        public boolean canBeCached() {
            return true;
        }
    }

    public static final class MakeNotStackable
    implements ProfileTransformer {
        private static final MakeNotStackable INSTANCE = new MakeNotStackable();
        private static final String PROPERTY_NAME = "XSeriesSeed";
        private static final AtomicLong NEXT_ID = new AtomicLong();

        @Override
        public GameProfile transform(Profileable profileable, GameProfile profile) {
            String value = System.currentTimeMillis() + "-" + NEXT_ID.getAndIncrement();
            profile.getProperties().put((Object)PROPERTY_NAME, (Object)new Property(PROPERTY_NAME, value));
            return profile;
        }

        @Override
        public boolean canBeCached() {
            return false;
        }
    }

    public static final class IncludeOriginalValue
    implements ProfileTransformer {
        private static final IncludeOriginalValue INSTANCE = new IncludeOriginalValue();
        public static final String PROPERTY_NAME = "OriginalValue";

        @Nullable
        public static String getOriginalValue(@NotNull GameProfile profile) {
            PropertyMap props = profile.getProperties();
            Collection prop = props.get((Object)PROPERTY_NAME);
            if (prop.isEmpty()) {
                return null;
            }
            Property first = (Property)Iterables.getFirst((Iterable)prop, null);
            return PlayerProfiles.getPropertyValue(first);
        }

        @Override
        public GameProfile transform(Profileable profileable, GameProfile profile) {
            String originalValue = profileable.getProfileValue();
            profile.getProperties().put((Object)PROPERTY_NAME, (Object)new Property(PROPERTY_NAME, originalValue));
            return profile;
        }

        @Override
        public boolean canBeCached() {
            return true;
        }
    }
}

