/*
 * Decompiled with CFR 0.152.
 */
package dev.rollczi.litecommands.shared;

import java.util.Iterator;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public class IterableMutableArray<T>
implements Iterable<T> {
    private final T[] array;

    @ApiStatus.Internal
    public IterableMutableArray(T[] array) {
        this.array = array;
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return new ArrayIterator();
    }

    private class ArrayIterator
    implements Iterator<T> {
        private int nextIndex = 0;

        private ArrayIterator() {
        }

        @Override
        public boolean hasNext() {
            return IterableMutableArray.this.array.length > this.nextIndex;
        }

        @Override
        public T next() {
            return IterableMutableArray.this.array[this.nextIndex++];
        }
    }
}

