/*
 * Decompiled with CFR 0.152.
 */
package co.crystaldev.alpinecore.framework.config;

import co.crystaldev.alpinecore.framework.config.AlpineConfig;
import co.crystaldev.alpinecore.framework.config.object.ConfigMessage;
import de.exlll.configlib.Comment;
import de.exlll.configlib.Configuration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public final class AlpinePluginConfig
extends AlpineConfig {
    @Comment(value={"Specifies an AlpinePlugin configuration to be used in place of this configuration.", " ", "The plugin name is CaSe SeNsItIvE and must match that of an existing AlpinePlugin.", " ", "Example usage:", " ", "overrideWith: AlpineCore"})
    public String overrideWith;
    @Comment(value={"", "Predefined chat style tags for use in configuration.", "These tags can be used to apply specific formatting to chat messages,", "making it easier to maintain a consistent style across your application.", " ", "Example usage:", " ", "styles:", "  info:      dark_aqua bold", "  highlight: aqua", "  notice:    dark_aqua", " ", "exampleMessage: <info>Example</info> This is an <highlight>example</highlight>!"})
    public HashMap<String, String> styles = new LinkedHashMap<String, String>();
    @Comment(value={"", "Predefined variables for use across all your plugin configurations.", " ", "Example usage:", " ", "variables:", "  prefix: '<bracket>[<info>*</info>]</bracket>'", "  error_prefix: '<bracket>[<error>*</error>]</bracket>'"})
    public HashMap<String, String> variables;
    @Comment(value={"", "Plugin Messages"})
    public ConfigMessage missingPermissions;
    public ConfigMessage invalidNumber;
    public ConfigMessage playerOnly;
    public ConfigMessage playerNotFound;
    public ConfigMessage invalidInstant;
    public ConfigMessage invalidWorld;
    public ConfigMessage invalidLocation;
    public InvalidUsageMessages invalidUsage;
    @Comment(value={"", "Title"})
    public ConfigMessage titleFormat;
    public boolean titleUsesPadding;
    public int titlePaddingLength;
    public String paddingCharacter;
    public String paddingStyle;
    @Comment(value={"", "Pagination"})
    public ConfigMessage paginatorTitleFormat;
    public ConfigMessage previous;
    public ConfigMessage next;
    public ConfigMessage previousDisabled;
    public ConfigMessage nextDisabled;
    public ConfigMessage noPages;
    @Comment(value={"", "Progress Indicator"})
    public ConfigMessage progressBarFormat;
    public int progressLength;
    public String progressIndicatorCharacter;
    public String progressRemainingCharacter;
    public String progressIndicatorStyle;
    public String progressRemainingStyle;

    @ApiStatus.Internal
    public AlpinePluginConfig() {
        this.styles.put("info", "dark_aqua bold");
        this.styles.put("highlight", "aqua");
        this.styles.put("notice", "dark_aqua");
        this.styles.put("error", "red bold");
        this.styles.put("error_highlight", "red");
        this.styles.put("success", "green bold");
        this.styles.put("success_highlight", "green");
        this.styles.put("emphasis", "gray");
        this.styles.put("bracket", "dark_gray");
        this.styles.put("separator", "dark_gray bold");
        this.styles.put("text", "white");
        this.styles.put("error_text", "white");
        this.variables = new LinkedHashMap<String, String>();
        this.missingPermissions = ConfigMessage.of("<red>You don't have the <hover:show_text:'%permission%'>required permission</hover> to execute this command");
        this.invalidNumber = ConfigMessage.of("<red>%input% is not a number");
        this.playerOnly = ConfigMessage.of("<red>This command can only be executed by players");
        this.playerNotFound = ConfigMessage.of("<red>Player %player% was not found");
        this.invalidInstant = ConfigMessage.of("<red>%input% is not a valid date format. Use <yyyy-MM-dd> <HH:mm:ss>");
        this.invalidWorld = ConfigMessage.of("<red>%input% is not a valid world");
        this.invalidLocation = ConfigMessage.of("<red>%input% is not a valid location");
        this.invalidUsage = new InvalidUsageMessages();
        this.titleFormat = ConfigMessage.of("<bracket><</bracket> %content% <bracket>></bracket>");
        this.titleUsesPadding = true;
        this.titlePaddingLength = 54;
        this.paddingCharacter = "-";
        this.paddingStyle = "dark_gray strikethrough";
        this.paginatorTitleFormat = ConfigMessage.of("<bracket><</bracket> %content% <separator>|</separator> %previous% %page%/%max_pages% %next% <bracket>></bracket>");
        this.previous = ConfigMessage.of("<bracket>[</bracket><emphasis><</emphasis><bracket>]</bracket>");
        this.next = ConfigMessage.of("<bracket>[</bracket><emphasis>></emphasis><bracket>]</bracket>");
        this.previousDisabled = ConfigMessage.of("<emphasis>[<]</emphasis>");
        this.nextDisabled = ConfigMessage.of("<emphasis>[>]</emphasis>");
        this.noPages = ConfigMessage.of("<emphasis><i>No pages available to display</i></emphasis>");
        this.progressBarFormat = ConfigMessage.of("<bracket>[</bracket>%progress%<bracket>]</bracket>");
        this.progressLength = 20;
        this.progressIndicatorCharacter = "=";
        this.progressRemainingCharacter = "\u22ef";
        this.progressIndicatorStyle = "aqua strikethrough";
        this.progressRemainingStyle = "light_gray";
    }

    @Override
    @NotNull
    public String getFileName() {
        return "alpinecore.yml";
    }

    @Configuration
    public static final class InvalidUsageMessages {
        public ConfigMessage single = ConfigMessage.of("<red>Invalid command usage:</red> <gray>%syntax%");
        public ConfigMessage multiHeader = ConfigMessage.of("<red>Invalid command usage:");
        public ConfigMessage multiLine = ConfigMessage.of("<gray><b>  *</b> %syntax%");
        public ConfigMessage argumentDescriptionFormat = ConfigMessage.of("%arguments% # %description%");
        public ConfigMessage argumentFormat = ConfigMessage.of("%arguments%");
    }
}

