/*
 * Decompiled with CFR 0.152.
 */
package co.crystaldev.alpinecore.framework.config.object;

import co.crystaldev.alpinecore.util.Formatting;
import com.google.common.collect.ImmutableMap;
import de.exlll.configlib.Configuration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Consumer;
import lombok.Generated;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

@Configuration
public class ConfigRewardPool {
    private List<Entry> entries;

    public void drawForPlayer(@NotNull Player player) {
        ImmutableMap placeholders = ImmutableMap.of((Object)"player", (Object)player.getName());
        this.drawInternal((Map<String, Object>)placeholders, s -> {});
    }

    public void drawForPlayer(@NotNull Player player, @NotNull Consumer<String> callback) {
        ImmutableMap placeholders = ImmutableMap.of((Object)"player", (Object)player.getName());
        this.drawInternal((Map<String, Object>)placeholders, callback);
    }

    public void drawForPlayer(@NotNull Player player, @NotNull Map<String, Object> placeholders) {
        placeholders.put("player", player.getName());
        this.drawInternal(placeholders, s -> {});
    }

    public void drawForPlayer(@NotNull Player player, @NotNull Map<String, Object> placeholders, @NotNull Consumer<String> callback) {
        placeholders.put("player", player.getName());
        this.drawInternal(placeholders, callback);
    }

    private void drawInternal(@NotNull Map<String, Object> placeholders, @NotNull Consumer<String> callback) {
        for (Entry entry : this.entries) {
            double draw = ThreadLocalRandom.current().nextDouble(0.0, 100.0);
            if (!(entry.chance >= draw)) continue;
            entry.executeCommands(placeholders);
            callback.accept(entry.name);
        }
    }

    @Generated
    public ConfigRewardPool(List<Entry> entries) {
        this.entries = entries;
    }

    @Generated
    public ConfigRewardPool() {
    }

    @Configuration
    public static class Entry {
        private String name;
        private double chance;
        private List<String> commands;

        public Entry(@NotNull String name, double chance, @NotNull List<String> commands) {
            Validate.isTrue((chance > 0.0 ? 1 : 0) != 0, (String)"chance must be greater than 0");
            Validate.isTrue((chance < 100.1 ? 1 : 0) != 0, (String)"chance must be less than 100");
            this.name = name;
            this.chance = chance;
            this.commands = commands;
        }

        protected void executeCommands(@NotNull Map<String, Object> placeholders) {
            for (String command : this.commands) {
                command = Formatting.placeholders(command, placeholders);
                Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)command);
            }
        }

        @Generated
        public Entry() {
        }
    }
}

