/*
 * Decompiled with CFR 0.152.
 */
package co.crystaldev.alpinecore.framework.cooldown;

import co.crystaldev.alpinecore.event.ServerTickEvent;
import co.crystaldev.alpinecore.framework.cooldown.Cooldown;
import co.crystaldev.alpinecore.framework.cooldown.CooldownHandler;
import co.crystaldev.alpinecore.util.Messaging;
import java.util.Iterator;
import java.util.Map;
import lombok.Generated;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
final class CooldownListener<T>
implements Listener {
    private final CooldownHandler<T> handler;
    private final Map<T, Cooldown<T>> cooldowns;

    @EventHandler
    public void onServerTick(ServerTickEvent event) {
        if (this.cooldowns.isEmpty()) {
            return;
        }
        Iterator<Map.Entry<T, Cooldown<T>>> iterator = this.cooldowns.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<T, Cooldown<T>> next = iterator.next();
            Cooldown<T> cooldown = next.getValue();
            int ticksRemaining = cooldown.tick();
            boolean removed = false;
            if (ticksRemaining <= 0) {
                removed = true;
                iterator.remove();
                this.handler.getCallbacks().getOnComplete().accept(cooldown);
                cooldown.complete();
            } else if (ticksRemaining % 20 == 0) {
                this.handler.getCallbacks().getOnCountdown().accept(cooldown);
            }
            T key = next.getKey();
            if (key instanceof Player) {
                Player player = (Player)key;
                Messaging.send((CommandSender)player, cooldown.messageType(), cooldown.message());
                cooldown.clearMessage();
            }
            if (!cooldown.isCancelled() || removed) continue;
            this.handler.cancel(key);
        }
    }

    @EventHandler
    public void onPlayerMove(PlayerMoveEvent event) {
        Player player = event.getPlayer();
        if (!this.cooldowns.containsKey(player)) {
            return;
        }
        Cooldown<T> cooldown = this.cooldowns.get(player);
        if (!cooldown.isWarmup() || cooldown.remainingTicks() < 0) {
            return;
        }
        if (CooldownListener.checkDistance(event.getTo(), cooldown.getOrigin(), this.handler.getMovementThreshold())) {
            return;
        }
        this.handler.getCallbacks().getOnMove().accept(cooldown);
        Messaging.send((CommandSender)player, cooldown.messageType(), cooldown.message());
        if (cooldown.isCancelled() || !cooldown.canMove()) {
            this.handler.cancel(player);
        }
    }

    @EventHandler
    public void onPlayerDisconnect(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        if (this.cooldowns.containsKey(player)) {
            this.handler.cancel(player);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean checkDistance(@NotNull Location to, @NotNull Location from, double threshold) {
        double d;
        if (!(Math.abs(from.getY() - to.getY()) < 1.25)) return false;
        double value = from.getX() - to.getX();
        double d2 = value * value;
        value = from.getZ() - to.getZ();
        if (!(d2 + d * value < threshold * threshold)) return false;
        return true;
    }

    @Generated
    public CooldownListener(CooldownHandler<T> handler, Map<T, Cooldown<T>> cooldowns) {
        this.handler = handler;
        this.cooldowns = cooldowns;
    }
}

