/*
 * Decompiled with CFR 0.152.
 */
package co.crystaldev.alpinecore.libs.org.apache.commons.dbcp2.datasources;

import co.crystaldev.alpinecore.libs.org.apache.commons.dbcp2.ListException;
import co.crystaldev.alpinecore.libs.org.apache.commons.dbcp2.Utils;
import co.crystaldev.alpinecore.libs.org.apache.commons.dbcp2.datasources.InstanceKeyDataSource;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;

abstract class InstanceKeyDataSourceFactory
implements ObjectFactory {
    private static final Map<String, InstanceKeyDataSource> INSTANCE_MAP = new ConcurrentHashMap<String, InstanceKeyDataSource>();

    InstanceKeyDataSourceFactory() {
    }

    public static void closeAll() throws ListException {
        ArrayList<Throwable> exceptionList = new ArrayList<Throwable>(INSTANCE_MAP.size());
        INSTANCE_MAP.entrySet().forEach(entry -> {
            if (entry != null) {
                InstanceKeyDataSource value = (InstanceKeyDataSource)entry.getValue();
                Utils.close(value, exceptionList::add);
            }
        });
        INSTANCE_MAP.clear();
        if (!exceptionList.isEmpty()) {
            throw new ListException("Could not close all InstanceKeyDataSource instances.", exceptionList);
        }
    }

    protected static final Object deserialize(byte[] data) throws IOException, ClassNotFoundException {
        Object object;
        ObjectInputStream in = null;
        try {
            in = new ObjectInputStream(new ByteArrayInputStream(data));
            object = in.readObject();
        }
        catch (Throwable throwable) {
            Utils.closeQuietly(in);
            throw throwable;
        }
        Utils.closeQuietly(in);
        return object;
    }

    static synchronized String registerNewInstance(InstanceKeyDataSource ds) {
        int max = 0;
        for (String s : INSTANCE_MAP.keySet()) {
            if (s == null) continue;
            try {
                max = Math.max(max, Integer.parseInt(s));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        String instanceKey = String.valueOf(max + 1);
        INSTANCE_MAP.put(instanceKey, ds);
        return instanceKey;
    }

    static void removeInstance(String key) {
        if (key != null) {
            INSTANCE_MAP.remove(key);
        }
    }

    private Boolean booleanValueOf(RefAddr refAddr) {
        return Boolean.valueOf(this.toString(refAddr));
    }

    protected abstract InstanceKeyDataSource getNewInstance(Reference var1) throws IOException, ClassNotFoundException;

    @Override
    public Object getObjectInstance(Object refObj, Name name, Context context, Hashtable<?, ?> env) throws IOException, ClassNotFoundException {
        Reference ref;
        InstanceKeyDataSource obj = null;
        if (refObj instanceof Reference && this.isCorrectClass((ref = (Reference)refObj).getClassName())) {
            RefAddr refAddr = ref.get("instanceKey");
            if (this.hasContent(refAddr)) {
                obj = INSTANCE_MAP.get(refAddr.getContent());
            } else {
                String key = null;
                if (name != null) {
                    key = name.toString();
                    obj = INSTANCE_MAP.get(key);
                }
                if (obj == null) {
                    InstanceKeyDataSource ds = this.getNewInstance(ref);
                    this.setCommonProperties(ref, ds);
                    obj = ds;
                    if (key != null) {
                        INSTANCE_MAP.put(key, ds);
                    }
                }
            }
        }
        return obj;
    }

    private boolean hasContent(RefAddr refAddr) {
        return refAddr != null && refAddr.getContent() != null;
    }

    protected abstract boolean isCorrectClass(String var1);

    boolean parseBoolean(RefAddr refAddr) {
        return Boolean.parseBoolean(this.toString(refAddr));
    }

    int parseInt(RefAddr refAddr) {
        return Integer.parseInt(this.toString(refAddr));
    }

    long parseLong(RefAddr refAddr) {
        return Long.parseLong(this.toString(refAddr));
    }

    private void setCommonProperties(Reference ref, InstanceKeyDataSource ikds) throws IOException, ClassNotFoundException {
        RefAddr refAddr = ref.get("dataSourceName");
        if (this.hasContent(refAddr)) {
            ikds.setDataSourceName(this.toString(refAddr));
        }
        if (this.hasContent(refAddr = ref.get("description"))) {
            ikds.setDescription(this.toString(refAddr));
        }
        if (this.hasContent(refAddr = ref.get("jndiEnvironment"))) {
            byte[] serialized = (byte[])refAddr.getContent();
            ikds.setJndiEnvironment((Properties)InstanceKeyDataSourceFactory.deserialize(serialized));
        }
        if (this.hasContent(refAddr = ref.get("loginTimeout"))) {
            ikds.setLoginTimeout(this.toDurationFromSeconds(refAddr));
        }
        if (this.hasContent(refAddr = ref.get("blockWhenExhausted"))) {
            ikds.setDefaultBlockWhenExhausted(this.parseBoolean(refAddr));
        }
        if (this.hasContent(refAddr = ref.get("evictionPolicyClassName"))) {
            ikds.setDefaultEvictionPolicyClassName(this.toString(refAddr));
        }
        if (this.hasContent(refAddr = ref.get("lifo"))) {
            ikds.setDefaultLifo(this.parseBoolean(refAddr));
        }
        if (this.hasContent(refAddr = ref.get("maxIdlePerKey"))) {
            ikds.setDefaultMaxIdle(this.parseInt(refAddr));
        }
        if (this.hasContent(refAddr = ref.get("maxTotalPerKey"))) {
            ikds.setDefaultMaxTotal(this.parseInt(refAddr));
        }
        if (this.hasContent(refAddr = ref.get("maxWaitMillis"))) {
            ikds.setDefaultMaxWait(this.toDurationFromMillis(refAddr));
        }
        if (this.hasContent(refAddr = ref.get("minEvictableIdleTimeMillis"))) {
            ikds.setDefaultMinEvictableIdle(this.toDurationFromMillis(refAddr));
        }
        if (this.hasContent(refAddr = ref.get("minIdlePerKey"))) {
            ikds.setDefaultMinIdle(this.parseInt(refAddr));
        }
        if (this.hasContent(refAddr = ref.get("numTestsPerEvictionRun"))) {
            ikds.setDefaultNumTestsPerEvictionRun(this.parseInt(refAddr));
        }
        if (this.hasContent(refAddr = ref.get("softMinEvictableIdleTimeMillis"))) {
            ikds.setDefaultSoftMinEvictableIdle(this.toDurationFromMillis(refAddr));
        }
        if (this.hasContent(refAddr = ref.get("testOnCreate"))) {
            ikds.setDefaultTestOnCreate(this.parseBoolean(refAddr));
        }
        if (this.hasContent(refAddr = ref.get("testOnBorrow"))) {
            ikds.setDefaultTestOnBorrow(this.parseBoolean(refAddr));
        }
        if (this.hasContent(refAddr = ref.get("testOnReturn"))) {
            ikds.setDefaultTestOnReturn(this.parseBoolean(refAddr));
        }
        if (this.hasContent(refAddr = ref.get("testWhileIdle"))) {
            ikds.setDefaultTestWhileIdle(this.parseBoolean(refAddr));
        }
        if (this.hasContent(refAddr = ref.get("timeBetweenEvictionRunsMillis"))) {
            ikds.setDefaultDurationBetweenEvictionRuns(this.toDurationFromMillis(refAddr));
        }
        if (this.hasContent(refAddr = ref.get("validationQuery"))) {
            ikds.setValidationQuery(this.toString(refAddr));
        }
        if (this.hasContent(refAddr = ref.get("validationQueryTimeout"))) {
            ikds.setValidationQueryTimeout(this.toDurationFromSeconds(refAddr));
        }
        if (this.hasContent(refAddr = ref.get("rollbackAfterValidation"))) {
            ikds.setRollbackAfterValidation(this.parseBoolean(refAddr));
        }
        if (this.hasContent(refAddr = ref.get("maxConnLifetimeMillis"))) {
            ikds.setMaxConnLifetime(this.toDurationFromMillis(refAddr));
        }
        if (this.hasContent(refAddr = ref.get("defaultAutoCommit"))) {
            ikds.setDefaultAutoCommit(this.booleanValueOf(refAddr));
        }
        if (this.hasContent(refAddr = ref.get("defaultTransactionIsolation"))) {
            ikds.setDefaultTransactionIsolation(this.parseInt(refAddr));
        }
        if (this.hasContent(refAddr = ref.get("defaultReadOnly"))) {
            ikds.setDefaultReadOnly(this.booleanValueOf(refAddr));
        }
    }

    private Duration toDurationFromMillis(RefAddr refAddr) {
        return Duration.ofMillis(this.parseLong(refAddr));
    }

    private Duration toDurationFromSeconds(RefAddr refAddr) {
        return Duration.ofSeconds(this.parseInt(refAddr));
    }

    String toString(RefAddr refAddr) {
        return refAddr.getContent().toString();
    }
}

